/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.property;

import java.util.logging.Logger;
import org.goplanit.output.enums.DataType;
import org.goplanit.output.property.OutputPropertyPriority;
import org.goplanit.output.property.OutputPropertyType;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.unit.Unit;

public abstract class OutputProperty
implements Comparable<OutputProperty> {
    private static final Logger LOGGER = Logger.getLogger(OutputProperty.class.getCanonicalName());
    private Unit overrideUnits = null;

    public abstract String getName();

    public abstract Unit getDefaultUnit();

    public boolean supportsUnitOverride() {
        return false;
    }

    public boolean isUnitOverride() {
        return this.overrideUnits != null;
    }

    public void setUnitOverride(Unit overrideUnit) {
        if (!this.supportsUnitOverride()) {
            LOGGER.warning(String.format("IGNORE: overriding default units for output property %s, not allowed", this.getClass().getCanonicalName()));
        }
        if (!this.getDefaultUnit().canConvertTo(overrideUnit)) {
            LOGGER.warning(String.format("IGNORE: overriding units %s yield unsupported conversion from default units %s for output ptoperty %s", this.getDefaultUnit().toString(), overrideUnit.toString(), this.getClass().getCanonicalName()));
        }
        this.overrideUnits = overrideUnit;
    }

    public Unit getOverrideUnit() {
        return this.isUnitOverride() ? this.overrideUnits : this.getDefaultUnit();
    }

    public abstract DataType getDataType();

    public abstract OutputPropertyType getOutputPropertyType();

    public abstract OutputPropertyPriority getColumnPriority();

    public boolean equals(Object otherProperty) {
        return this.getClass().getCanonicalName().equals(otherProperty.getClass().getCanonicalName());
    }

    public int hashCode() {
        return this.getDefaultUnit().hashCode() + this.getDataType().hashCode() + this.getName().hashCode();
    }

    @Override
    public int compareTo(OutputProperty otherProperty) {
        if (this.getColumnPriority().equals((Object)otherProperty.getColumnPriority())) {
            if (this.getName().equals(otherProperty.getName())) {
                return this.getOutputPropertyType().compareTo(otherProperty.getOutputPropertyType());
            }
            return this.getName().compareTo(otherProperty.getName());
        }
        return this.getColumnPriority().value() - otherProperty.getColumnPriority().value();
    }

    public static OutputProperty of(String propertyClassName) throws PlanItException {
        try {
            Class<?> entityClass = Class.forName(propertyClassName);
            OutputProperty outputProperty = (OutputProperty)entityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return outputProperty;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException(String.format("Error when converting base output property %s", propertyClassName), e);
        }
    }

    public static OutputProperty of(OutputPropertyType outputProperty) throws PlanItException {
        return OutputProperty.of(outputProperty.value());
    }
}

