/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.formatter;

import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.goplanit.od.path.OdPathMatrix;
import org.goplanit.od.skim.OdSkimMatrix;
import org.goplanit.output.adapter.MacroscopicLinkOutputTypeAdapter;
import org.goplanit.output.adapter.OdOutputTypeAdapter;
import org.goplanit.output.adapter.OutputAdapter;
import org.goplanit.output.adapter.PathOutputTypeAdapter;
import org.goplanit.output.configuration.OutputConfiguration;
import org.goplanit.output.configuration.OutputTypeConfiguration;
import org.goplanit.output.configuration.PathOutputTypeConfiguration;
import org.goplanit.output.enums.OdSkimSubOutputType;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.enums.OutputTypeEnum;
import org.goplanit.output.enums.SubOutputTypeEnum;
import org.goplanit.output.formatter.FileOutputFormatter;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.output.property.OutputPropertyType;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.output.OutputUtils;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.unit.VehiclesUnit;

public abstract class CsvFileOutputFormatter
extends FileOutputFormatter {
    private static final Logger LOGGER = Logger.getLogger(CsvFileOutputFormatter.class.getCanonicalName());
    protected final Map<OutputTypeEnum, List<String>> csvFileNameMap = new HashMap<OutputTypeEnum, List<String>>();

    protected CsvFileOutputFormatter(IdGroupingToken groupId) {
        super(groupId);
    }

    protected PlanItException writeOdResultsForCurrentTimePeriodToCsvPrinter(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, CSVPrinter csvPrinter) {
        try {
            OdOutputTypeAdapter odOutputTypeAdapter = (OdOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputTypeConfiguration.getOutputType());
            SortedSet<OutputProperty> outputProperties = outputTypeConfiguration.getOutputProperties();
            PlanItException.throwIf(!(currentOutputType instanceof SubOutputTypeEnum) || !((SubOutputTypeEnum)currentOutputType instanceof OdSkimSubOutputType), "currentOutputType is not compatible with od results", new Object[0]);
            OdSkimSubOutputType currentSubOutputType = (OdSkimSubOutputType)currentOutputType;
            OutputProperty odCostProperty = OutputProperty.of(OutputPropertyType.OD_COST);
            for (Mode mode : modes) {
                VehiclesUnit.updatePcuToVehicleFactor(1.0 / mode.getPcu());
                Optional<OdSkimMatrix> odSkimMatrix = odOutputTypeAdapter.getOdSkimMatrix(currentSubOutputType, mode);
                odSkimMatrix.orElseThrow(() -> new PlanItException("od skim matrix could not be retrieved when persisting"));
                OdSkimMatrix.OdSkimMatrixIterator odMatrixIterator = odSkimMatrix.get().iterator();
                while (odMatrixIterator.hasNext()) {
                    odMatrixIterator.next();
                    Optional<?> cost = odOutputTypeAdapter.getOdOutputPropertyValue(odCostProperty, odMatrixIterator, mode, timePeriod);
                    cost.orElseThrow(() -> new PlanItException("cost could not be retrieved when persisting"));
                    if (!outputConfiguration.isPersistZeroFlow() && !((Double)cost.get() > 1.0E-6)) continue;
                    List rowValues = outputProperties.stream().map(outputProperty -> odOutputTypeAdapter.getOdOutputPropertyValue((OutputProperty)outputProperty, odMatrixIterator, mode, timePeriod).get()).map(outValue -> OutputUtils.formatObject(outValue)).collect(Collectors.toList());
                    csvPrinter.printRecord(rowValues);
                }
            }
        }
        catch (PlanItException e) {
            return e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            return new PlanItException("Error when writing od results for current time period in CSVOutputFileformatter", e);
        }
        return null;
    }

    protected PlanItException writePathResultsForCurrentTimePeriodToCsvPrinter(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, CSVPrinter csvPrinter) {
        try {
            PlanItException.throwIf(!(currentOutputType instanceof OutputType), "currentOutputType not compatible with path output", new Object[0]);
            OutputType outputType = (OutputType)currentOutputType;
            PathOutputTypeAdapter pathOutputTypeAdapter = (PathOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputType);
            PathOutputTypeConfiguration pathOutputTypeConfiguration = (PathOutputTypeConfiguration)outputTypeConfiguration;
            SortedSet<OutputProperty> outputProperties = outputTypeConfiguration.getOutputProperties();
            for (Mode mode : modes) {
                VehiclesUnit.updatePcuToVehicleFactor(1.0 / mode.getPcu());
                Optional<OdPathMatrix> odPathMatrix = pathOutputTypeAdapter.getOdPathMatrix(mode);
                odPathMatrix.orElseThrow(() -> new PlanItException("od path matrix could not be retrieved when persisting"));
                OdPathMatrix.OdPathMatrixIterator odPathIterator = odPathMatrix.get().iterator();
                while (odPathIterator.hasNext()) {
                    odPathIterator.next();
                    if (!outputConfiguration.isPersistZeroFlow() && odPathIterator.getCurrentValue() == null) continue;
                    List rowValues = outputProperties.stream().map(outputProperty -> pathOutputTypeAdapter.getPathOutputPropertyValue((OutputProperty)outputProperty, odPathIterator, mode, timePeriod, pathOutputTypeConfiguration.getPathIdentificationType()).get()).map(outValue -> OutputUtils.formatObject(outValue)).collect(Collectors.toList());
                    csvPrinter.printRecord(rowValues);
                }
            }
        }
        catch (PlanItException e) {
            return e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            return new PlanItException("Error when writing path results for current time period in CSVOutputFileformatter", e);
        }
        return null;
    }

    protected PlanItException writeLinkResultsForCurrentTimePeriodToCsvPrinter(OutputConfiguration outputConfiguration, OutputTypeConfiguration outputTypeConfiguration, OutputTypeEnum currentOutputType, OutputAdapter outputAdapter, Set<Mode> modes, TimePeriod timePeriod, CSVPrinter csvPrinter) {
        try {
            PlanItException.throwIf(!(currentOutputType instanceof OutputType), "currentOutputType not compatible with link output", new Object[0]);
            OutputType outputType = (OutputType)currentOutputType;
            MacroscopicLinkOutputTypeAdapter linkOutputTypeAdapter = (MacroscopicLinkOutputTypeAdapter)outputAdapter.getOutputTypeAdapter(outputType);
            SortedSet<OutputProperty> outputProperties = outputTypeConfiguration.getOutputProperties();
            for (Mode mode : modes) {
                VehiclesUnit.updatePcuToVehicleFactor(1.0 / mode.getPcu());
                Optional<Long> networkLayerId = linkOutputTypeAdapter.getInfrastructureLayerIdForMode(mode);
                if (networkLayerId.isPresent()) {
                    for (MacroscopicLinkSegment linkSegment : linkOutputTypeAdapter.getPhysicalLinkSegments(networkLayerId.get())) {
                        if (!linkSegment.isModeAllowed(mode)) continue;
                        Optional<Boolean> flowPositive = linkOutputTypeAdapter.isFlowPositive(linkSegment, mode);
                        flowPositive.orElseThrow(() -> new PlanItException("unable to determine if flow is positive on link segment"));
                        if (!outputConfiguration.isPersistZeroFlow() && !flowPositive.get().booleanValue()) continue;
                        List rowValues = outputProperties.stream().map(outputProperty -> linkOutputTypeAdapter.getLinkSegmentOutputPropertyValue((OutputProperty)outputProperty, linkSegment, mode, timePeriod).get()).map(outValue -> OutputUtils.formatObject(outValue)).collect(Collectors.toList());
                        csvPrinter.printRecord(rowValues);
                    }
                    continue;
                }
                LOGGER.severe(String.format("network layer could not be identified for mode %s by csv output formatter", mode.getXmlId()));
            }
        }
        catch (PlanItException e) {
            return e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            return new PlanItException("Error when writing link results for current time period in CSVOutputFileformatter", e);
        }
        return null;
    }

    protected CSVPrinter openCsvFileAndWriteHeaders(OutputTypeConfiguration outputTypeConfiguration, String csvFileName) throws Exception {
        CSVPrinter csvPrinter = new CSVPrinter(new FileWriter(csvFileName), CSVFormat.DEFAULT.withIgnoreSurroundingSpaces());
        List headerValues = outputTypeConfiguration.getOutputProperties().stream().map(OutputProperty::getName).collect(Collectors.toList());
        csvPrinter.printRecord(headerValues);
        return csvPrinter;
    }

    public void addCsvFileNamePerOutputType(OutputTypeEnum currentoutputType, String csvFileName) {
        if (!this.csvFileNameMap.containsKey(currentoutputType)) {
            this.csvFileNameMap.put(currentoutputType, new ArrayList());
        }
        this.csvFileNameMap.get(currentoutputType).add(csvFileName);
    }
}

