/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.configuration;

import java.util.Arrays;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.network.layer.macroscopic.MacroscopicLinkSegmentImpl;
import org.goplanit.output.configuration.OutputTypeConfiguration;
import org.goplanit.output.enums.OdSkimSubOutputType;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.output.property.OutputPropertyType;
import org.goplanit.utils.exceptions.PlanItException;

public class OdOutputTypeConfiguration
extends OutputTypeConfiguration {
    private static final Logger LOGGER = Logger.getLogger(MacroscopicLinkSegmentImpl.class.getCanonicalName());
    private static final int ORIGIN_DESTINATION_ID_IDENTIFICATION = 1;
    private static final int ORIGIN_DESTINATION_XML_ID_IDENTIFICATION = 2;
    private static final int ORIGIN_DESTINATION_EXTERNAL_ID_IDENTIFICATION = 3;
    private static final int ORIGIN_DESTINATION_NOT_IDENTIFIED = 4;

    private int findIdentificationMethod(OutputProperty[] outputKeyProperties) {
        Set outputKeyPropertyList = Arrays.stream(outputKeyProperties).map(op -> op.getOutputPropertyType()).collect(Collectors.toSet());
        if (outputKeyPropertyList.contains((Object)OutputPropertyType.ORIGIN_ZONE_ID) && outputKeyPropertyList.contains((Object)OutputPropertyType.DESTINATION_ZONE_ID)) {
            return 1;
        }
        if (outputKeyPropertyList.contains((Object)OutputPropertyType.ORIGIN_ZONE_XML_ID) && outputKeyPropertyList.contains((Object)OutputPropertyType.DESTINATION_ZONE_XML_ID)) {
            return 2;
        }
        if (outputKeyPropertyList.contains((Object)OutputPropertyType.ORIGIN_ZONE_EXTERNAL_ID) && outputKeyPropertyList.contains((Object)OutputPropertyType.DESTINATION_ZONE_EXTERNAL_ID)) {
            return 3;
        }
        return 4;
    }

    public OdOutputTypeConfiguration() throws PlanItException {
        super(OutputType.OD);
        this.activeSubOutputTypes.add(OdSkimSubOutputType.COST);
        this.addProperty(OutputPropertyType.TIME_PERIOD_XML_ID);
        this.addProperty(OutputPropertyType.MODE_XML_ID);
        this.addProperty(OutputPropertyType.ORIGIN_ZONE_XML_ID);
        this.addProperty(OutputPropertyType.DESTINATION_ZONE_XML_ID);
        this.addProperty(OutputPropertyType.OD_COST);
    }

    @Override
    public OutputProperty[] validateAndFilterKeyProperties(OutputProperty[] outputKeyProperties) {
        OutputProperty[] outputKeyPropertiesArray = null;
        boolean valid = false;
        try {
            switch (this.findIdentificationMethod(outputKeyProperties)) {
                case 1: {
                    outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.of(OutputPropertyType.ORIGIN_ZONE_ID), OutputProperty.of(OutputPropertyType.DESTINATION_ZONE_ID)};
                    valid = true;
                    break;
                }
                case 2: {
                    outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.of(OutputPropertyType.ORIGIN_ZONE_XML_ID), OutputProperty.of(OutputPropertyType.DESTINATION_ZONE_XML_ID)};
                    valid = true;
                    break;
                }
                case 3: {
                    outputKeyPropertiesArray = new OutputProperty[]{OutputProperty.of(OutputPropertyType.ORIGIN_ZONE_EXTERNAL_ID), OutputProperty.of(OutputPropertyType.DESTINATION_ZONE_EXTERNAL_ID)};
                    valid = true;
                    break;
                }
                default: {
                    LOGGER.warning("configured keys cannot identify origin-destination cell in the skim matrix");
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
            LOGGER.warning("Invalid keys encountered for identifying od data ");
        }
        if (valid) {
            return outputKeyPropertiesArray;
        }
        return null;
    }

    public void activateOdSkimOutputType(OdSkimSubOutputType odSkimOutputType) {
        this.activateSubOutputType(odSkimOutputType);
    }

    public void deactivateOdSkimOutputType(OdSkimSubOutputType odSkimOutputType) {
        this.deactivateSubOutputType(odSkimOutputType);
    }

    @Override
    public boolean isOutputPropertyValid(OutputProperty baseOutputProperty) {
        switch (baseOutputProperty.getOutputPropertyType()) {
            case DESTINATION_ZONE_EXTERNAL_ID: {
                return true;
            }
            case DESTINATION_ZONE_XML_ID: {
                return true;
            }
            case DESTINATION_ZONE_ID: {
                return true;
            }
            case ITERATION_INDEX: {
                return true;
            }
            case MODE_EXTERNAL_ID: {
                return true;
            }
            case MODE_XML_ID: {
                return true;
            }
            case MODE_ID: {
                return true;
            }
            case OD_COST: {
                return true;
            }
            case ORIGIN_ZONE_EXTERNAL_ID: {
                return true;
            }
            case ORIGIN_ZONE_XML_ID: {
                return true;
            }
            case ORIGIN_ZONE_ID: {
                return true;
            }
            case RUN_ID: {
                return true;
            }
            case TIME_PERIOD_EXTERNAL_ID: {
                return true;
            }
            case TIME_PERIOD_XML_ID: {
                return true;
            }
            case TIME_PERIOD_ID: {
                return true;
            }
        }
        LOGGER.warning("tried to add " + baseOutputProperty.getName() + " as an output property, which is inappropriate for Origin-Destination output. This will be ignored");
        return false;
    }
}

