/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.output.adapter;

import java.util.Optional;
import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.output.adapter.OutputTypeAdapterImpl;
import org.goplanit.output.adapter.UntypedLinkOutputTypeAdapter;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.network.layer.physical.LinkSegment;

public abstract class UntypedLinkOutputTypeAdapterImpl<LS extends LinkSegment>
extends OutputTypeAdapterImpl
implements UntypedLinkOutputTypeAdapter<LS> {
    private static final Logger LOGGER = Logger.getLogger(UntypedLinkOutputTypeAdapterImpl.class.getCanonicalName());

    public UntypedLinkOutputTypeAdapterImpl(OutputType outputType, TrafficAssignment trafficAssignment) {
        super(outputType, trafficAssignment);
    }

    @Override
    public Optional<?> getLinkSegmentOutputPropertyValue(OutputProperty outputProperty, LS linkSegment) {
        Optional<Object> result = Optional.empty();
        try {
            switch (outputProperty.getOutputPropertyType()) {
                case DOWNSTREAM_NODE_EXTERNAL_ID: {
                    result = this.getDownstreamNodeExternalId(linkSegment);
                    break;
                }
                case DOWNSTREAM_NODE_XML_ID: {
                    result = this.getDownstreamNodeXmlId(linkSegment);
                    break;
                }
                case DOWNSTREAM_NODE_ID: {
                    result = this.getDownstreamNodeId(linkSegment);
                    break;
                }
                case DOWNSTREAM_NODE_LOCATION: {
                    result = this.getDownstreamNodeLocation(linkSegment);
                    break;
                }
                case LENGTH: {
                    result = this.getLength(linkSegment);
                    break;
                }
                case LINK_SEGMENT_EXTERNAL_ID: {
                    result = this.getLinkSegmentExternalId(linkSegment);
                    break;
                }
                case LINK_SEGMENT_XML_ID: {
                    result = this.getLinkSegmentXmlId(linkSegment);
                    break;
                }
                case LINK_SEGMENT_ID: {
                    result = this.getLinkSegmentId(linkSegment);
                    break;
                }
                case NUMBER_OF_LANES: {
                    result = this.getNumberOfLanes(linkSegment);
                    break;
                }
                case UPSTREAM_NODE_EXTERNAL_ID: {
                    result = this.getUpstreamNodeExternalId(linkSegment);
                    break;
                }
                case UPSTREAM_NODE_XML_ID: {
                    result = this.getUpstreamNodeXmlId(linkSegment);
                    break;
                }
                case UPSTREAM_NODE_ID: {
                    result = this.getUpstreamNodeId(linkSegment);
                    break;
                }
                case UPSTREAM_NODE_LOCATION: {
                    result = this.getUpstreamNodeLocation(linkSegment);
                    break;
                }
            }
            if (outputProperty.supportsUnitOverride() && outputProperty.isUnitOverride()) {
                result = UntypedLinkOutputTypeAdapterImpl.createConvertedUnitsValue(outputProperty, result);
            }
        }
        catch (PlanItException e) {
            result = Optional.of(e.getMessage());
        }
        return result;
    }
}

