/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.locationtech.jts.geom.Geometry;

public class PlanitOsmUtils {
    static final Logger LOGGER = Logger.getLogger(PlanitOsmUtils.class.getCanonicalName());
    public static final Pattern SPEED_LIMIT_PATTERN = Pattern.compile("([^0-9]*)([0-9]*\\.?[0-9]+).*(km/h|kmh|kph|mph|knots)?.*");

    private static double determineMaxSpeedUnitMultiplierKmPerHour(String unitString) throws PlanItException {
        switch (unitString) {
            case "mph": {
                return 0.621371;
            }
            case "knots": {
                return 0.539957;
            }
        }
        throw new PlanItException(String.format("unit conversion to km/h not available from %s", unitString));
    }

    public static double parseMaxSpeedValueKmPerHour(String maxSpeedValue) throws PlanItException {
        PlanItException.throwIfNull(maxSpeedValue, "max speed value is null");
        double speedLimitKmh = -1.0;
        Matcher speedLimitMatcher = SPEED_LIMIT_PATTERN.matcher(maxSpeedValue);
        if (!speedLimitMatcher.matches()) {
            throw new PlanItException(String.format("invalid value string encountered for maxSpeed: %s", maxSpeedValue));
        }
        if (speedLimitMatcher.group(2) != null) {
            speedLimitKmh = Double.parseDouble(speedLimitMatcher.group(2));
        }
        if (speedLimitMatcher.group(3) != null) {
            speedLimitKmh *= PlanitOsmUtils.determineMaxSpeedUnitMultiplierKmPerHour(speedLimitMatcher.group(3));
        }
        return speedLimitKmh;
    }

    public static double[] parseMaxSpeedValueLanesKmPerHour(String maxSpeedLanes) throws PlanItException {
        PlanItException.throwIfNull(maxSpeedLanes, "max speed lanes value is null");
        String[] maxSpeedByLane = maxSpeedLanes.split("|");
        double[] speedLimitKmh = new double[maxSpeedByLane.length];
        for (int index = 0; index < maxSpeedByLane.length; ++index) {
            speedLimitKmh[index] = PlanitOsmUtils.parseMaxSpeedValueKmPerHour(maxSpeedByLane[index]);
        }
        return speedLimitKmh;
    }

    public static Edge findEdgeClosest(OsmEntity osmEntity, Collection<? extends Edge> edges, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        EntityType type = Osm4JUtils.getEntityType(osmEntity);
        switch (type) {
            case Node: {
                return OsmNodeUtils.findEdgeClosest((OsmNode)osmEntity, edges, geoUtils);
            }
            case Way: {
                return OsmWayUtils.findEdgeClosest((OsmWay)osmEntity, edges, osmNodes, geoUtils);
            }
        }
        LOGGER.warning(String.format("unsupported osm entity type when finding closest edge to %d", osmEntity.getId()));
        return null;
    }

    public static Geometry extractGeometry(OsmEntity osmEntity, Map<Long, OsmNode> osmNodes) throws PlanItException {
        return PlanitOsmUtils.extractGeometry(osmEntity, osmNodes, LOGGER.getLevel());
    }

    public static Geometry extractGeometry(OsmEntity osmEntity, Map<Long, OsmNode> osmNodes, Level logLevel) throws PlanItException {
        Level originalLogLevel = LOGGER.getLevel();
        LOGGER.setLevel(logLevel);
        Geometry theGeometry = null;
        if (osmEntity instanceof OsmNode) {
            OsmNode osmNode = (OsmNode)OsmNode.class.cast(osmEntity);
            try {
                theGeometry = PlanitJtsUtils.createPoint(OsmNodeUtils.getX(osmNode), OsmNodeUtils.getY(osmNode));
            }
            catch (PlanItException e) {
                LOGGER.severe(String.format("unable to construct location information for osm node %d when creating transfer zone", osmNode.getId()));
            }
        } else if (osmEntity instanceof OsmWay) {
            OsmWay osmWay = (OsmWay)OsmWay.class.cast(osmEntity);
            theGeometry = OsmWayUtils.extractGeometry(osmWay, osmNodes, logLevel);
        }
        LOGGER.setLevel(originalLogLevel);
        return theGeometry;
    }
}

