/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.util;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkHandlerHelper;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.tags.OsmDirectionTags;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.function.PlanitExceptionConsumer;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.locale.DrivingDirectionDefaultByCountry;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.zoning.Zone;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class OsmWayUtils {
    private static final Logger LOGGER = Logger.getLogger(OsmWayUtils.class.getCanonicalName());

    protected static <T> T findPlanitEntityClosest(OsmWay osmWay, Collection<? extends T> planitEntities, double maxDistanceMeters, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        T closestPlanitEntity = null;
        double minDistanceMeters = Double.POSITIVE_INFINITY;
        for (int index = 0; index < osmWay.getNumberOfNodes(); ++index) {
            Pair<T, Double> result;
            OsmNode osmNode = osmNodes.get(osmWay.getNodeId(index));
            if (osmNode == null || (result = OsmNodeUtils.findPlanitEntityClosest(osmNode, planitEntities, maxDistanceMeters, geoUtils)) == null || !(result.second() < minDistanceMeters)) continue;
            closestPlanitEntity = result.first();
            minDistanceMeters = result.second();
        }
        return closestPlanitEntity;
    }

    public static boolean isCircularOsmWay(OsmWay osmWay, Map<String, String> tags, boolean mustEndAtstart) {
        if (tags.containsKey("highway") || tags.containsKey("railway") && osmWay.getNumberOfNodes() > 2) {
            if (mustEndAtstart) {
                return OsmWayUtils.isOsmWayPerfectLoop(osmWay);
            }
            return OsmWayUtils.findIndicesOfFirstLoop(osmWay, 0) != null;
        }
        return false;
    }

    public static boolean isOsmWayPerfectLoop(OsmWay osmWay) {
        return osmWay.getNodeId(0) == osmWay.getNodeId(osmWay.getNumberOfNodes() - 1);
    }

    public static Pair<Integer, Integer> findIndicesOfFirstLoop(OsmWay osmWay, int initialNodeIndex) {
        for (int index = initialNodeIndex; index < osmWay.getNumberOfNodes(); ++index) {
            long nodeIdToCheck = osmWay.getNodeId(index);
            for (int index2 = index + 1; index2 < osmWay.getNumberOfNodes(); ++index2) {
                if (nodeIdToCheck != osmWay.getNodeId(index2)) continue;
                return Pair.of(index, index2);
            }
        }
        return null;
    }

    public static boolean isCircularWayDefaultDirectionClockwise(String countryName) {
        return DrivingDirectionDefaultByCountry.isLeftHandDrive(countryName);
    }

    public static boolean isCircularWayDirectionClosed(Map<String, String> tags, boolean isForwardDirection, String countryName) {
        Boolean isClockWise = null;
        isClockWise = OsmDirectionTags.isDirectionExplicitClockwise(tags) ? Boolean.valueOf(true) : (OsmDirectionTags.isDirectionExplicitAntiClockwise(tags) ? Boolean.valueOf(false) : Boolean.valueOf(OsmWayUtils.isCircularWayDefaultDirectionClockwise(countryName)));
        return isClockWise != isForwardDirection;
    }

    public static Coordinate[] createCoordinateArray(OsmWay osmWay, Map<Long, OsmNode> osmNodes, int startNodeIndex, int endNodeIndex, PlanitExceptionConsumer<Set<Long>> missingNodeConsumer) throws PlanItException {
        HashSet<Long> missingNodes = null;
        Coordinate[] coordArray = null;
        int stopIndex = endNodeIndex;
        if (endNodeIndex < startNodeIndex) {
            stopIndex = osmWay.getNumberOfNodes() - 1;
            coordArray = new Coordinate[stopIndex - startNodeIndex + 1 + endNodeIndex + 1];
        } else {
            coordArray = new Coordinate[endNodeIndex - startNodeIndex + 1];
        }
        for (int index = startNodeIndex; index <= stopIndex; ++index) {
            OsmNode osmNode = osmNodes.get(osmWay.getNodeId(index));
            if (osmNode == null) {
                if (missingNodes == null) {
                    missingNodes = new HashSet<Long>();
                }
                missingNodes.add(osmWay.getNodeId(index));
                continue;
            }
            coordArray[index - startNodeIndex] = new Coordinate(OsmNodeUtils.getX(osmNode), OsmNodeUtils.getY(osmNode));
        }
        if (endNodeIndex < startNodeIndex) {
            int offsetIndex = stopIndex - startNodeIndex + 1;
            for (int index = 0; index <= endNodeIndex; ++index) {
                OsmNode osmNode = osmNodes.get(osmWay.getNodeId(index));
                if (osmNode == null) {
                    if (missingNodes == null) {
                        missingNodes = new HashSet();
                    }
                    missingNodes.add(osmWay.getNodeId(index));
                    continue;
                }
                coordArray[offsetIndex + index] = new Coordinate(OsmNodeUtils.getX(osmNode), OsmNodeUtils.getY(osmNode));
            }
        }
        if (missingNodes != null && missingNodeConsumer != null) {
            missingNodeConsumer.accept(missingNodes);
            coordArray = PlanitJtsUtils.copyWithoutNullEntries(coordArray);
        }
        return coordArray;
    }

    public static Coordinate[] createCoordinateArray(OsmWay osmWay, Map<Long, OsmNode> osmNodes) throws PlanItException {
        return OsmWayUtils.createCoordinateArray(osmWay, 0, osmWay.getNumberOfNodes() - 1, osmNodes);
    }

    public static Coordinate[] createCoordinateArray(OsmWay osmWay, int startNodeIndex, int endNodeIndex, Map<Long, OsmNode> osmNodes) throws PlanItException {
        PlanitExceptionConsumer<Set<Long>> missingNodeConsumer = missingNodes -> {
            if (missingNodes != null) {
                throw new PlanItException(String.format("Missing OSM nodes for OSM way %d: %s", osmWay.getId(), missingNodes.toString()));
            }
        };
        return OsmWayUtils.createCoordinateArray(osmWay, osmNodes, startNodeIndex, endNodeIndex, missingNodeConsumer);
    }

    public static Coordinate[] createCoordinateArrayNoThrow(OsmWay osmWay, int startNodeIndex, int endNodeIndex, Map<Long, OsmNode> osmNodes) throws PlanItException {
        PlanitExceptionConsumer<Set<Long>> missingNodeConsumer = missingNodes -> {
            if (missingNodes != null) {
                LOGGER.warning(String.format("Missing OSM nodes for OSM way %d: %s", osmWay.getId(), missingNodes.toString()));
            }
        };
        return OsmWayUtils.createCoordinateArray(osmWay, osmNodes, startNodeIndex, endNodeIndex, missingNodeConsumer);
    }

    public static Coordinate[] createCoordinateArrayNoThrow(OsmWay osmWay, Map<Long, OsmNode> osmNodes) {
        PlanitExceptionConsumer<Set<Long>> missingNodeConsumer = missingNodes -> {
            if (missingNodes != null) {
                LOGGER.warning(String.format("Missing OSM nodes for for OSM way %d: %s", osmWay.getId(), missingNodes.toString()));
            }
        };
        Coordinate[] coordArray = null;
        try {
            coordArray = OsmWayUtils.createCoordinateArray(osmWay, osmNodes, 0, osmWay.getNumberOfNodes() - 1, missingNodeConsumer);
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
        }
        return coordArray;
    }

    public static Geometry extractGeometry(OsmWay osmWay, Map<Long, OsmNode> osmNodes) throws PlanItException {
        return OsmWayUtils.extractGeometry(osmWay, osmNodes, LOGGER.getLevel());
    }

    public static Geometry extractGeometry(OsmWay osmWay, Map<Long, OsmNode> osmNodes, Level logLevel) throws PlanItException {
        Level originalLevel = LOGGER.getLevel();
        LOGGER.setLevel(logLevel);
        Geometry geometry = null;
        if (OsmWayUtils.isOsmWayPerfectLoop(osmWay)) {
            geometry = OsmWayUtils.extractPolygonNoThrow(osmWay, osmNodes);
        }
        if (geometry == null) {
            geometry = OsmWayUtils.extractLineStringNoThrow(osmWay, osmNodes);
        }
        if (geometry == null) {
            geometry = OsmWayUtils.extractPoint(osmWay, osmNodes);
        }
        LOGGER.setLevel(originalLevel);
        return geometry;
    }

    public static LineString extractLineString(OsmWay osmWay, Map<Long, OsmNode> osmNodes) throws PlanItException {
        Coordinate[] coordArray = OsmWayUtils.createCoordinateArray(osmWay, osmNodes);
        return PlanitJtsUtils.createLineString(coordArray);
    }

    public static LineString extractLineString(OsmWay osmWay, int startNodeIndex, int endNodeIndex, Map<Long, OsmNode> osmNodes) throws PlanItException {
        Coordinate[] coordArray = OsmWayUtils.createCoordinateArray(osmWay, startNodeIndex, endNodeIndex, osmNodes);
        return PlanitJtsUtils.createLineString(coordArray);
    }

    public static LineString extractLineStringNoThrow(OsmWay osmWay, int startNodeIndex, int endNodeIndex, Map<Long, OsmNode> osmNodes) throws PlanItException {
        Coordinate[] coordArray = OsmWayUtils.createCoordinateArrayNoThrow(osmWay, startNodeIndex, endNodeIndex, osmNodes);
        return PlanitJtsUtils.createLineString(coordArray);
    }

    public static LineString extractLineStringNoThrow(OsmWay osmWay, Map<Long, OsmNode> osmNodes) {
        LineString lineString = null;
        try {
            Coordinate[] coordArray = OsmWayUtils.createCoordinateArrayNoThrow(osmWay, osmNodes);
            if (coordArray != null && coordArray.length >= 2 && (lineString = PlanitJtsUtils.createLineString(coordArray)) != null && coordArray.length < osmWay.getNumberOfNodes()) {
                LOGGER.info(String.format("SALVAGED: linestring for OSM way %d, truncated to available nodes", osmWay.getId()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lineString;
    }

    public static Point extractPoint(OsmWay osmWay, Map<Long, OsmNode> osmNodes) throws PlanItException {
        Coordinate[] coordArray = OsmWayUtils.createCoordinateArrayNoThrow(osmWay, osmNodes);
        if (coordArray != null && coordArray.length >= 1) {
            return PlanitJtsUtils.createPoint(coordArray[0]);
        }
        LOGGER.severe(String.format("Unable to extract a single location from nodes references by osm way %d", osmWay.getId()));
        return null;
    }

    public static Polygon extractPolygon(OsmWay osmWay, Map<Long, OsmNode> osmNodes) throws PlanItException {
        Coordinate[] coordArray = OsmWayUtils.createCoordinateArray(osmWay, osmNodes);
        return PlanitJtsUtils.createPolygon(coordArray);
    }

    public static Polygon extractPolygonNoThrow(OsmWay osmWay, Map<Long, OsmNode> osmNodes) {
        Polygon polygon = null;
        boolean salvaged = false;
        try {
            Coordinate[] coordArray = OsmWayUtils.createCoordinateArrayNoThrow(osmWay, osmNodes);
            if (coordArray != null && coordArray.length >= 2) {
                if (coordArray.length < osmWay.getNumberOfNodes()) {
                    coordArray = PlanitJtsUtils.makeClosed2D(coordArray);
                    salvaged = true;
                }
                if ((polygon = PlanitJtsUtils.createPolygon(coordArray)) != null && salvaged) {
                    LOGGER.info(String.format("SALVAGED: polygon for OSM way %d, truncated to available nodes", osmWay.getId()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Zone findZoneClosest(OsmWay osmWay, Collection<? extends Zone> zones, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return OsmWayUtils.findZoneClosest(osmWay, zones, Double.POSITIVE_INFINITY, osmNodes, geoUtils);
    }

    public static Zone findZoneClosest(OsmWay osmWay, Collection<? extends Zone> zones, double maxDistanceMeters, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return OsmWayUtils.findPlanitEntityClosest(osmWay, zones, maxDistanceMeters, osmNodes, geoUtils);
    }

    public static Edge findEdgeClosest(OsmWay osmWay, Collection<? extends Edge> edges, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return OsmWayUtils.findEdgeClosest(osmWay, edges, Double.POSITIVE_INFINITY, osmNodes, geoUtils);
    }

    public static Edge findEdgeClosest(OsmWay osmWay, Collection<? extends Edge> edges, double maxDistanceMeters, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        return OsmWayUtils.findPlanitEntityClosest(osmWay, edges, maxDistanceMeters, osmNodes, geoUtils);
    }

    public static LineSegment findMinimumLineSegmentBetween(OsmWay osmWay, LineString geometry, Map<Long, OsmNode> osmNodes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        double minDistanceMeters = Double.POSITIVE_INFINITY;
        Coordinate osmWayMinDistanceCoordinate = null;
        Coordinate geometryMinDistanceCoordinate = null;
        for (int index = 0; index < osmWay.getNumberOfNodes(); ++index) {
            Coordinate closestCoordinate;
            double distanceMeters;
            OsmNode osmNode = osmNodes.get(osmWay.getNodeId(index));
            Coordinate osmNodeCoordinate = new Coordinate(OsmNodeUtils.getX(osmNode), OsmNodeUtils.getY(osmNode));
            if (osmNode == null || !((distanceMeters = geoUtils.getDistanceInMetres(osmNodeCoordinate, closestCoordinate = OsmNodeUtils.findClosestProjectedCoordinateTo(osmNode, geometry, geoUtils))) < minDistanceMeters)) continue;
            minDistanceMeters = distanceMeters;
            osmWayMinDistanceCoordinate = osmNodeCoordinate;
            geometryMinDistanceCoordinate = closestCoordinate;
        }
        if (minDistanceMeters < Double.POSITIVE_INFINITY) {
            return PlanitJtsUtils.createLineSegment(osmWayMinDistanceCoordinate, geometryMinDistanceCoordinate);
        }
        return null;
    }

    public static String findMostProminentOsmHighWayType(Set<? extends Edge> edges) {
        String mostProminent = "unclassified";
        for (Edge edge : edges) {
            String osmWayType = OsmNetworkHandlerHelper.getLinkOsmWayType((Link)edge);
            if (OsmHighwayTags.compareHighwayType(mostProminent, osmWayType) >= 0) continue;
            mostProminent = osmWayType;
        }
        return mostProminent;
    }

    public static void removeEdgesWithOsmHighwayTypesLessImportantThan(String osmHighwayType, Set<? extends Edge> edgesToFilter) {
        Iterator<? extends Edge> iterator = edgesToFilter.iterator();
        while (iterator.hasNext()) {
            Edge edge = iterator.next();
            String osmWayType = OsmNetworkHandlerHelper.getLinkOsmWayType((Link)edge);
            if (OsmHighwayTags.compareHighwayType(osmHighwayType, osmWayType) <= 0) continue;
            iterator.remove();
        }
    }

    public static Integer findFirstAvailableOsmNodeIndexAfter(int offsetIndex, OsmWay osmWay, Map<Long, OsmNode> osmNodes) {
        for (int nodeIndex = offsetIndex + 1; nodeIndex < osmWay.getNumberOfNodes(); ++nodeIndex) {
            if (!osmNodes.containsKey(osmWay.getNodeId(nodeIndex))) continue;
            return nodeIndex;
        }
        return null;
    }

    public static boolean isAllOsmWayNodesAvailable(OsmWay osmWay, Map<Long, OsmNode> osmNodes) {
        for (int nodeIndex = 0; nodeIndex < osmWay.getNumberOfNodes(); ++nodeIndex) {
            if (osmNodes.containsKey(osmWay.getNodeId(nodeIndex))) continue;
            return false;
        }
        return true;
    }

    public static Integer getOsmWayNodeIndexByLocation(OsmWay osmWay, Point nodePosition, OsmNetworkReaderData networkData) {
        for (int nodeIndex = 0; nodeIndex < osmWay.getNumberOfNodes(); ++nodeIndex) {
            long osmNodeId = osmWay.getNodeId(nodeIndex);
            OsmNode osmNode = networkData.getOsmNode(osmNodeId);
            if (osmNode == null || !OsmNodeUtils.nodeLocationEquals2D(osmNode, nodePosition.getCoordinate())) continue;
            return nodeIndex;
        }
        return null;
    }

    public static Integer findLastAvailableOsmNodeIndexAfter(int offsetIndex, OsmWay osmWay, Map<Long, OsmNode> osmNodes) throws PlanItException {
        for (int nodeIndex = offsetIndex + 1; nodeIndex < osmWay.getNumberOfNodes(); ++nodeIndex) {
            if (osmNodes.containsKey(osmWay.getNodeId(nodeIndex))) continue;
            return nodeIndex - 1;
        }
        return null;
    }
}

