/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.tags;

import java.util.Map;
import java.util.stream.Stream;
import org.goplanit.osm.util.OsmTagUtils;

public class OsmBicycleTags {
    protected static final String[] CYCLEWAY_REGULAR_POSITIVE_VALUE_TAGS = new String[]{"lane", "shared_lane", "shoulder", "track", "share_busway"};
    protected static final String[] CYCLEWAY_REGULAR_NEGATIVE_VALUE_TAGS = new String[]{"no", "separate", "proposed"};
    protected static final String[] CYCLEWAY_OPPOSITE_DIRECTION_POSITIVE_VALUE_TAGS = new String[]{"opposite_track", "opposite_lane", "opposite_share_busway"};
    protected static final String[] BASIC_CYCLEWAY_KEY_TAGS = new String[]{"cycleway", CYCLEWAY_BOTH, CYCLEWAY_RIGHT, CYCLEWAY_LEFT};
    protected static final String[] LOCATION_BASED_CYCLEWAY_KEY_TAGS = new String[]{CYCLEWAY_RIGHT, CYCLEWAY_LEFT};
    protected static final String[] BASIC_AND_LOCATION_BASED_KEY_TAGS = (String[])Stream.concat(Stream.of(BASIC_CYCLEWAY_KEY_TAGS), Stream.of(LOCATION_BASED_CYCLEWAY_KEY_TAGS)).toArray(String[]::new);
    protected static final String[] ONEWAY_LOCATION_BASED_CYCLEWAY_KEY_TAGS = new String[]{CYCLEWAY_LEFT_ONEWAY, CYCLEWAY_RIGHT_ONEWAY};
    public static final String BICYCLE = "bicycle";
    public static final String CYCLEWAY = "cycleway";
    public static final String CYCLEWAY_BOTH = OsmTagUtils.createCompositeOsmKey("cycleway", "both");
    public static final String CYCLEWAY_RIGHT = OsmTagUtils.createCompositeOsmKey("cycleway", "right");
    public static final String CYCLEWAY_LEFT = OsmTagUtils.createCompositeOsmKey("cycleway", "left");
    public static final String CYCLEWAY_RIGHT_ONEWAY = OsmTagUtils.createCompositeOsmKey(CYCLEWAY_RIGHT, "oneway");
    public static final String CYCLEWAY_LEFT_ONEWAY = OsmTagUtils.createCompositeOsmKey(CYCLEWAY_LEFT, "oneway");
    public static final String DISMOUNT = "dismount";
    public static final String LANE = "lane";
    public static final String NO = "no";
    public static final String OPPOSITE = "opposite";
    public static final String OPPOSITE_TRACK = "opposite_track";
    public static final String OPPOSITE_LANE = "opposite_lane";
    public static final String OPPOSITE_SHARE_BUSWAY = "opposite_share_busway";
    public static final String SHARE_BUSWAY = "share_busway";
    public static final String SHARED_LANE = "shared_lane";
    public static final String SHOULDER = "shoulder";
    public static final String SEPARATE = "separate";
    public static final String SIDEPATH = "sidepath";
    public static final String TRACK = "track";
    public static final String YES = "yes";
    private static final String PROPOSED = "proposed";

    public static final String[] getCycleWayKeyTags(boolean includeLocationSubKey) {
        if (!includeLocationSubKey) {
            return BASIC_CYCLEWAY_KEY_TAGS;
        }
        return BASIC_AND_LOCATION_BASED_KEY_TAGS;
    }

    public static String[] getCycleWayOneWayLocationBasedKeyTags() {
        return ONEWAY_LOCATION_BASED_CYCLEWAY_KEY_TAGS;
    }

    public static String[] getCycleWayRegularPositiveValueTags() {
        return CYCLEWAY_REGULAR_POSITIVE_VALUE_TAGS;
    }

    public static String[] getCycleWayPositiveOppositeDirectionValueTags() {
        return CYCLEWAY_OPPOSITE_DIRECTION_POSITIVE_VALUE_TAGS;
    }

    public static String[] getCycleWayRegularNegativeValueTags() {
        return CYCLEWAY_REGULAR_NEGATIVE_VALUE_TAGS;
    }

    public static boolean isCyclewayIncludedForAnyOf(Map<String, String> tags, boolean oppositeDirection, String ... cyclewayKeys) {
        if (!oppositeDirection) {
            return OsmTagUtils.anyKeyMatchesAnyValueTag(tags, cyclewayKeys, OsmBicycleTags.getCycleWayRegularPositiveValueTags());
        }
        return OsmTagUtils.anyKeyMatchesAnyValueTag(tags, cyclewayKeys, OsmBicycleTags.getCycleWayPositiveOppositeDirectionValueTags());
    }

    public static boolean isOppositeCyclewayIncludedForAnyOf(Map<String, String> tags, String ... cyclewayKeys) {
        return OsmBicycleTags.isCyclewayIncludedForAnyOf(tags, true, cyclewayKeys);
    }

    public static boolean isCyclewayIncludedForAnyOf(Map<String, String> tags, String ... cyclewayKeys) {
        return OsmBicycleTags.isCyclewayIncludedForAnyOf(tags, false, cyclewayKeys);
    }

    public static boolean isCyclewayExcludedForAnyOf(Map<String, String> tags, String ... cyclewayKeys) {
        return OsmTagUtils.anyKeyMatchesAnyValueTag(tags, cyclewayKeys, OsmBicycleTags.getCycleWayRegularNegativeValueTags());
    }

    public static boolean isNoOneWayCyclewayInAnyLocation(Map<String, String> tags) {
        return OsmTagUtils.anyKeyMatchesAnyValueTag(tags, OsmBicycleTags.getCycleWayOneWayLocationBasedKeyTags(), OsmBicycleTags.getCycleWayRegularNegativeValueTags());
    }
}

