/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OsmSpeedLimitDefaultsCategory
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(OsmSpeedLimitDefaultsCategory.class.getCanonicalName());
    protected final Map<String, Double> speedLimitDefaults;
    protected final OsmSpeedLimitDefaultsCategory backupDefaults;
    protected final String countryName;

    public OsmSpeedLimitDefaultsCategory(String countryName) {
        this.countryName = countryName;
        this.backupDefaults = null;
        this.speedLimitDefaults = new HashMap<String, Double>();
    }

    public OsmSpeedLimitDefaultsCategory(String countryName, OsmSpeedLimitDefaultsCategory backupDefaults) {
        this.countryName = countryName;
        this.backupDefaults = backupDefaults;
        this.speedLimitDefaults = new HashMap<String, Double>();
    }

    public OsmSpeedLimitDefaultsCategory(OsmSpeedLimitDefaultsCategory other) {
        this.backupDefaults = other.backupDefaults;
        this.countryName = other.countryName;
        this.speedLimitDefaults = new HashMap<String, Double>(other.speedLimitDefaults);
    }

    public void setSpeedLimitDefault(String type, double speedLimitKmH) {
        this.speedLimitDefaults.put(type, speedLimitKmH);
    }

    public Double getSpeedLimit(String type) {
        Double speedLimit = this.speedLimitDefaults.get(type);
        if (speedLimit == null) {
            speedLimit = this.backupDefaults.getSpeedLimit(type);
        }
        return speedLimit;
    }

    public boolean containsSpeedLimit(String type) {
        return this.speedLimitDefaults.containsKey(type);
    }

    public String getCountry() {
        return this.countryName;
    }

    public OsmSpeedLimitDefaultsCategory clone() {
        return new OsmSpeedLimitDefaultsCategory(this);
    }
}

