/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVRecord;
import org.goplanit.osm.defaults.CountrySpecificDefaultUtils;
import org.goplanit.osm.defaults.OsmModeAccessDefaults;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.utils.locale.LocaleUtils;
import org.goplanit.utils.misc.StringUtils;

public class OsmModeAccessDefaultsByCountry {
    private static final Logger LOGGER = Logger.getLogger(OsmModeAccessDefaultsByCountry.class.getCanonicalName());
    private static final OsmModeAccessDefaults GLOBAL_MODE_ACCESS_DEFAULTS = new OsmModeAccessDefaults();
    private static final Map<String, OsmModeAccessDefaults> MODE_ACCESS_DEFAULTS_BY_COUNTRY = new HashMap<String, OsmModeAccessDefaults>();
    private static final String MODE_ACCESS_RESOURCE_DIR = "mode_access";
    protected static OsmModeAccessDefaults globalModeAccessDefaults;
    protected static Map<String, OsmModeAccessDefaults> modeAccessDefaultsByCountry;

    protected static void populateGlobalDefaultHighwayModeAccess() {
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("motorway", "motor_vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultDisallowedModes("motorway", "moped", "mofa", "atv", "golf_cart");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("motorway_link", "motor_vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultDisallowedModes("motorway_link", "moped", "mofa", "atv", "golf_cart");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("trunk", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("trunk", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("trunk_link", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("trunk_link", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("primary", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("primary", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("primary_link", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("primary_link", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("secondary", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("secondary", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("secondary_link", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("secondary_link", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("tertiary", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("tertiary", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("tertiary_link", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("tertiary_link", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("unclassified", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("unclassified", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("residential", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("residential", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("living_street", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("living_street", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("road", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("road", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("service", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("service", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModeCategories("track", "vehicle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("track", "foot");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("pedestrian", "foot", "dog");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("steps", "foot", "dog");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("path", "foot", "dog", "horse", "bicycle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("bridleway", "horse");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("cycleway", "bicycle");
        GLOBAL_MODE_ACCESS_DEFAULTS.getHighwayModeAccessDefaults().addDefaultAllowedModes("footway", "foot");
    }

    protected static void populateGlobalDefaultRailwayModeAccess() {
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes("funicular", OsmRailModeTags.convertRailwayToMode("funicular"));
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes("light_rail", OsmRailModeTags.convertRailwayToMode("light_rail"));
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes("light_rail", OsmRailModeTags.convertRailwayToMode("tram"));
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes("monorail", OsmRailModeTags.convertRailwayToMode("monorail"));
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes("narrow_gauge", OsmRailModeTags.convertRailwayToMode("narrow_gauge"));
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes("rail", OsmRailModeTags.convertRailwayToMode("rail"));
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes("subway", OsmRailModeTags.convertRailwayToMode("subway"));
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes("tram", OsmRailModeTags.convertRailwayToMode("tram"));
        GLOBAL_MODE_ACCESS_DEFAULTS.getRailwayModeAccessDefaults().addDefaultAllowedModes("tram", OsmRailModeTags.convertRailwayToMode("light_rail"));
    }

    protected static void populateCountrySpecificDefaultModeAccess() {
        CountrySpecificDefaultUtils.callForEachFileInResourceDir(MODE_ACCESS_RESOURCE_DIR, OsmModeAccessDefaultsByCountry::populateCountrySpecificDefaultModeAccess);
    }

    protected static void populateCountrySpecificDefaultModeAccess(InputStreamReader inputReader, String fullCountryName) {
        try {
            Iterable<CSVRecord> records = CountrySpecificDefaultUtils.collectCsvRecordIterable(inputReader);
            for (CSVRecord record : records) {
                String osmWayType = record.get(0).trim();
                boolean isOsmHighway = OsmHighwayTags.isRoadBasedHighwayValueTag(osmWayType);
                boolean isOsmRailwayTag = false;
                if (!isOsmHighway && !(isOsmRailwayTag = OsmRailwayTags.isRailBasedRailway(osmWayType))) {
                    LOGGER.warning(String.format("IGNORED: OSM way type (%s) in country specific mode access defaults is not a valid highway or railway type", osmWayType));
                }
                ArrayList<String> allowedOsmModes = new ArrayList<String>(record.size() - 1);
                for (int columnIndex = 1; columnIndex < record.size(); ++columnIndex) {
                    String osmMode = record.get(columnIndex).trim();
                    if (StringUtils.isNullOrBlank(osmMode)) continue;
                    allowedOsmModes.add(osmMode);
                }
                if (allowedOsmModes.isEmpty()) continue;
                OsmModeAccessDefaults countryDefaults = GLOBAL_MODE_ACCESS_DEFAULTS.clone();
                countryDefaults.setCountry(fullCountryName);
                if (isOsmHighway) {
                    countryDefaults.getHighwayModeAccessDefaults().setAllowedModes(osmWayType, false, allowedOsmModes);
                } else {
                    countryDefaults.getRailwayModeAccessDefaults().setAllowedModes(osmWayType, false, allowedOsmModes);
                }
                OsmModeAccessDefaultsByCountry.setDefaultsByCountry(countryDefaults);
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Parsing of csv input stream with mode access defaults failed for %s", fullCountryName));
        }
    }

    protected static void setDefaultsByCountry(OsmModeAccessDefaults modeAccessDefaults) {
        if (modeAccessDefaults.getCountry() != "global") {
            MODE_ACCESS_DEFAULTS_BY_COUNTRY.put(LocaleUtils.getIso2CountryCodeByName(modeAccessDefaults.getCountry()), modeAccessDefaults);
        } else {
            LOGGER.warning("setting OSM mode access defaults by country, then the defaults should have a country specified, this is not the case, defaults, ignored");
        }
    }

    public static OsmModeAccessDefaults create() {
        OsmModeAccessDefaults theDefaults = null;
        try {
            theDefaults = GLOBAL_MODE_ACCESS_DEFAULTS.clone();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("unable to initialise global mode access defaults");
        }
        return theDefaults;
    }

    public static OsmModeAccessDefaults create(String countryName) {
        OsmModeAccessDefaults theDefaults = null;
        try {
            String iso2CountryCode = LocaleUtils.getIso2CountryCodeByName(countryName);
            if (iso2CountryCode != null && MODE_ACCESS_DEFAULTS_BY_COUNTRY.containsKey(iso2CountryCode)) {
                theDefaults = MODE_ACCESS_DEFAULTS_BY_COUNTRY.get(iso2CountryCode).clone();
            } else {
                LOGGER.info("Reverting to global mode access defaults, rather than country specific ones");
                theDefaults = GLOBAL_MODE_ACCESS_DEFAULTS.clone();
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("Unable to initialise global mode access defaults");
        }
        return theDefaults;
    }

    static {
        modeAccessDefaultsByCountry = new HashMap<String, OsmModeAccessDefaults>();
        OsmModeAccessDefaultsByCountry.populateGlobalDefaultHighwayModeAccess();
        OsmModeAccessDefaultsByCountry.populateGlobalDefaultRailwayModeAccess();
        OsmModeAccessDefaultsByCountry.populateCountrySpecificDefaultModeAccess();
    }
}

