/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.defaults;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.BiConsumer;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.locale.LocaleUtils;
import org.goplanit.utils.misc.FileUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.misc.UriUtils;
import org.goplanit.utils.resource.ResourceUtils;

public class CountrySpecificDefaultUtils {
    private static final Logger LOGGER = Logger.getLogger(CountrySpecificDefaultUtils.class.getCanonicalName());

    public static void callForEachFileInResourceDir(String resourceDir, BiConsumer<InputStreamReader, String> callBack) {
        try {
            URI uri = null;
            try {
                uri = ResourceUtils.getResourceUri(resourceDir);
            }
            catch (Exception e) {
                LOGGER.warning(e.getMessage());
                e.printStackTrace();
                return;
            }
            FileSystem fs = null;
            DirectoryStream<Path> directoryStream = null;
            if (UriUtils.isInJar(uri)) {
                fs = ResourceUtils.getJarFileSystem(uri);
                directoryStream = Files.newDirectoryStream(fs.getPath(resourceDir, new String[0]));
            } else {
                directoryStream = Files.newDirectoryStream(Paths.get(uri));
            }
            for (Path resourcePath : directoryStream) {
                String fullCountryName = CountrySpecificDefaultUtils.extractCountryNameFromFile(resourcePath);
                if (StringUtils.isNullOrBlank(fullCountryName)) {
                    LOGGER.warning(String.format("DISCARD: Unrecognised country code encountered (%s) when parsing default OSM highway speed limit values", fullCountryName));
                    continue;
                }
                String resourceInDirRelUri = resourceDir + "/" + resourcePath.getFileName().toString();
                URI fileResourceUri = ResourceUtils.getResourceUri(resourceInDirRelUri);
                InputStreamReader inputReader = ResourceUtils.getResourceAsInputStreamReader(fileResourceUri);
                callBack.accept(inputReader, fullCountryName);
                inputReader.close();
            }
            directoryStream.close();
            if (UriUtils.isInJar(uri)) {
                fs.close();
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Unable to parse files in resource dir %s", resourceDir));
        }
    }

    public static String extractCountryNameFromFile(Path filePath) throws PlanItException {
        PlanItException.throwIfNull(filePath, "path provided is null");
        String countryCodeFileName = filePath.getFileName().toString();
        PlanItException.throwIfNull(countryCodeFileName, "file name not present on path %s", filePath);
        countryCodeFileName = FileUtils.getFileNameWithoutExtension(countryCodeFileName);
        return LocaleUtils.getCountryNameCodeByIso2Code(countryCodeFileName);
    }

    public static Iterable<CSVRecord> collectCsvRecordIterable(File file) throws IOException {
        FileReader in = new FileReader(file.toPath().toAbsolutePath().toString());
        return CountrySpecificDefaultUtils.collectCsvRecordIterable(in);
    }

    public static Iterable<CSVRecord> collectCsvRecordIterable(Reader readerToUse) throws IOException {
        return CSVFormat.DEFAULT.withFirstRecordAsHeader().parse(readerToUse);
    }
}

