/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler.helper;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.goplanit.osm.converter.helper.OsmModeHelper;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;

public class OsmPublicTransportModeHelper
extends OsmModeHelper {
    public OsmPublicTransportModeHelper(OsmNetworkReaderSettings settings) {
        super(settings);
    }

    public Pair<Collection<String>, Collection<Mode>> collectPublicTransportModesFromPtEntity(long osmPtEntityId, Map<String, String> tags, String defaultMode) {
        Collection<String> eligibleOsmModes = OsmModeUtils.collectEligibleOsmPublicTransportModesOnPtOsmEntity(osmPtEntityId, tags, defaultMode);
        if (eligibleOsmModes == null || eligibleOsmModes.isEmpty()) {
            return null;
        }
        Set<Mode> eligiblePlanitModes = this.getSettings().getMappedPlanitModes(eligibleOsmModes);
        return Pair.of(eligibleOsmModes, eligiblePlanitModes);
    }

    public Pair<Collection<String>, Collection<Mode>> collectModesFromPtEntity(long osmPtEntityId, Map<String, String> tags, String defaultMode) {
        Collection<String> eligibleOsmModes = OsmModeUtils.collectEligibleOsmModesOnPtOsmEntity(osmPtEntityId, tags, defaultMode);
        if (eligibleOsmModes == null || eligibleOsmModes.isEmpty()) {
            return null;
        }
        Set<Mode> eligiblePlanitModes = this.getSettings().getMappedPlanitModes(eligibleOsmModes);
        return Pair.of(eligibleOsmModes, eligiblePlanitModes);
    }
}

