/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmRelation;
import de.topobyte.osm4j.core.model.iface.OsmRelationMember;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerBase;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.TransferZoneGroupHelper;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmPtv1Tags;
import org.goplanit.osm.tags.OsmPtv2Tags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.osm.util.OsmPtVersionScheme;
import org.goplanit.osm.util.OsmRelationUtils;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.osm.util.PlanitTransferZoneUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.zoning.Zoning;

public class OsmZoningProcessingHandler
extends OsmZoningHandlerBase {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningProcessingHandler.class.getCanonicalName());

    private void registerPtv2StopAreaPlatformOnGroup(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmRelationMember member) {
        OsmRelationMember internalMember;
        EntityType type = member.getType();
        long osmId = member.getId();
        if (member.getType().equals((Object)EntityType.Relation) && (internalMember = OsmRelationUtils.findFirstOsmRelationMemberWithRole(osmRelation, "outer")) != null) {
            if (this.getZoningReaderData().getOsmData().hasOuterRoleOsmWay(internalMember.getId())) {
                OsmWay osmWay = this.getZoningReaderData().getOsmData().getOuterRoleOsmWay(internalMember.getId());
                type = EntityType.Way;
                osmId = osmWay.getId();
            } else {
                LOGGER.severe("Identified platform as multi-polygon/relation, however its `outer role` member is not available or converted into a transfer zone");
            }
        }
        this.getTransferZoneGroupHelper().registerTransferZoneOnGroup(osmId, type, transferZoneGroup);
    }

    private boolean isPtv2StopAreaWronglyTaggedStopRole(OsmRelationMember member) {
        boolean wronglyTaggedRole = false;
        if (member.getType() == EntityType.Node) {
            OsmNode osmNode = this.getNetworkToZoningData().getOsmNodes().get(member.getId());
            if (osmNode == null) {
                return false;
            }
            Map<String, String> tags = OsmModelUtil.getTagsAsMap(osmNode);
            if (!OsmPtv2Tags.hasPublicTransportKeyTag(tags) || !tags.get("public_transport").equals("stop_position")) {
                wronglyTaggedRole = true;
            }
        } else {
            wronglyTaggedRole = true;
        }
        return wronglyTaggedRole;
    }

    private void salvageWronglyTaggedStopRolePtv2StopAreaRelation(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmRelationMember member) {
        Pair<OsmPtVersionScheme, OsmEntity> unprocessedStationPair = this.getZoningReaderData().getOsmData().getUnprocessedStation(member.getType(), member.getId());
        if (unprocessedStationPair != null) {
            LOGGER.info(String.format("SALVAGED: stop_area %s member %d incorrectly given stop role...identified as station", transferZoneGroup.getExternalId(), member.getId()));
            TransferZoneGroupHelper.updateTransferZoneGroupStationName(transferZoneGroup, unprocessedStationPair.second(), OsmModelUtil.getTagsAsMap(unprocessedStationPair.second()));
        } else if (this.getZoningReaderData().getPlanitData().getTransferZoneByOsmId(member.getType(), member.getId()) != null) {
            LOGGER.info(String.format("SALVAGED: stop_area %s member %d incorrectly given stop role...identified as platform", transferZoneGroup.getExternalId(), member.getId()));
            this.registerPtv2StopAreaPlatformOnGroup(transferZoneGroup, osmRelation, member);
        } else {
            LOGGER.warning(String.format("DISCARD: stop_area %s member %d incorrectly given stop role...remains unidentified", transferZoneGroup.getExternalId(), member.getId()));
        }
    }

    private void processPtv2StopAreaMemberNodePtv1HighwayWithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmNode osmNode, Map<String, String> tags) throws PlanItException {
        String ptv1ValueTag = tags.get("highway");
        if (ptv1ValueTag == null) {
            LOGGER.severe(String.format("highway tag not present for alleged Ptv1 highway %d on stop_area %d, this should not happen ignored", osmNode.getId(), osmRelation.getId()));
            return;
        }
        if ("bus_stop".equals(ptv1ValueTag)) {
            this.getTransferZoneGroupHelper().registerTransferZoneOnGroup(osmNode, tags, transferZoneGroup);
        } else if ("platform".equals(ptv1ValueTag)) {
            this.getProfiler().incrementOsmPtv1TagCounter(ptv1ValueTag);
            this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(osmNode, tags, TransferZoneType.PLATFORM, "bus", this.getGeoUtils());
        } else {
            LOGGER.warning(String.format("unsupported Ptv1 higway=%s tag encountered, ignored", ptv1ValueTag));
        }
    }

    private void processPtv2StopAreaMemberNodePtv1RailwayWithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmNode osmNode, Map<String, String> tags) {
        String ptv1ValueTag = tags.get("railway");
        if (ptv1ValueTag == null) {
            LOGGER.severe(String.format("railway tag not present for alleged Ptv1 railway %d on stop_area %d, this should not happen ignored", osmNode.getId(), osmRelation.getId()));
            return;
        }
        if (this.getNetworkToZoningData().getNetworkSettings().isRailwayParserActive() && this.getNetworkToZoningData().getNetworkSettings().getRailwaySettings().hasAnyMappedPlanitModeOtherThan("tram")) {
            if (OsmTagUtils.matchesAnyValueTag(ptv1ValueTag, "station", "halt")) {
                TransferZoneGroupHelper.updateTransferZoneGroupStationName(transferZoneGroup, osmNode, tags);
                this.getProfiler().incrementOsmPtv1TagCounter(ptv1ValueTag);
            } else if ("platform".equals(ptv1ValueTag)) {
                this.getTransferZoneGroupHelper().registerTransferZoneOnGroup(osmNode, tags, transferZoneGroup);
            }
        }
        if ("tram_stop".equals(ptv1ValueTag)) {
            this.getTransferZoneGroupHelper().registerTransferZoneOnGroup(osmNode, tags, transferZoneGroup);
        }
        if (!"subway_entrance".equals(ptv1ValueTag) || this.getNetworkToZoningData().getNetworkSettings().getHighwaySettings().hasMappedPlanitMode("foot")) {
            // empty if block
        }
    }

    private void processPtv2StopAreaMemberNodePtv1WithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmNode osmNode, Map<String, String> tags) throws PlanItException {
        if (OsmRailwayTags.hasRailwayKeyTag(tags)) {
            this.processPtv2StopAreaMemberNodePtv1RailwayWithoutRole(transferZoneGroup, osmRelation, osmNode, tags);
        } else if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
            this.processPtv2StopAreaMemberNodePtv1HighwayWithoutRole(transferZoneGroup, osmRelation, osmNode, tags);
        }
    }

    private void processPtv2StopAreaMemberNodePtv2WithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmNode osmNode, Map<String, String> tags) {
        if (OsmPtv2Tags.hasPublicTransportKeyTag(tags) && tags.get("public_transport").equals("station")) {
            TransferZoneGroupHelper.updateTransferZoneGroupStationName(transferZoneGroup, osmNode, tags);
            this.getProfiler().incrementOsmPtv2TagCounter("station");
        }
    }

    private void processPtv2StopAreaMemberNodeWithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmNode osmNode) throws PlanItException {
        Map<String, String> osmNodeTags = OsmModelUtil.getTagsAsMap(osmNode);
        OsmPtVersionScheme ptVersion = this.isActivatedPublicTransportInfrastructure(osmNodeTags);
        switch (ptVersion) {
            case VERSION_2: {
                this.processPtv2StopAreaMemberNodePtv2WithoutRole(transferZoneGroup, osmRelation, osmNode, osmNodeTags);
                break;
            }
            case VERSION_1: {
                this.processPtv2StopAreaMemberNodePtv1WithoutRole(transferZoneGroup, osmRelation, osmNode, osmNodeTags);
            }
        }
    }

    private void processPtv2StopAreaMemberStation(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmEntity osmStation) {
        Map<String, String> tags = OsmModelUtil.getTagsAsMap(osmStation);
        TransferZoneGroupHelper.updateTransferZoneGroupStationName(transferZoneGroup, osmStation, tags);
        for (int index = 0; index < osmRelation.getNumberOfMembers(); ++index) {
            OsmRelationMember transferZoneMember = osmRelation.getMember(index);
            TransferZone transferZone = this.getZoningReaderData().getPlanitData().getTransferZoneByOsmId(transferZoneMember.getType(), osmStation.getId());
            if (transferZone == null) continue;
            PlanitTransferZoneUtils.updateTransferZoneStationName(transferZone, tags);
        }
        OsmPtVersionScheme ptVersion = this.isActivatedPublicTransportInfrastructure(tags);
        this.getZoningReaderData().getOsmData().removeUnproccessedStation(ptVersion, osmStation);
        this.getProfiler().incrementOsmTagCounter(ptVersion, "station");
    }

    private void processPtv2StopAreaMemberWayWithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmRelationMember osmWayMember) {
        TransferZone transferZone;
        boolean unidentified = false;
        Pair<OsmPtVersionScheme, OsmEntity> osmWayPair = this.getZoningReaderData().getOsmData().getUnprocessedStation(EntityType.Way, osmWayMember.getId());
        if (osmWayPair != null) {
            this.processPtv2StopAreaMemberStation(transferZoneGroup, osmRelation, osmWayPair.second());
            unidentified = false;
        }
        if (unidentified && (transferZone = this.getZoningReaderData().getPlanitData().getTransferZoneByOsmId(EntityType.Way, osmWayMember.getId())) != null) {
            this.registerPtv2StopAreaPlatformOnGroup(transferZoneGroup, osmRelation, osmWayMember);
            unidentified = false;
        }
        if (unidentified) {
            LOGGER.warning(String.format("DISCARD: unable to collect osm way %d referenced in stop_area %d", osmWayMember.getId(), osmRelation.getId()));
        }
    }

    private void processPtv2StopAreaMemberWithoutRole(TransferZoneGroup transferZoneGroup, OsmRelation osmRelation, OsmRelationMember member) throws PlanItException {
        if (member.getType() == EntityType.Node) {
            OsmNode osmNode = this.getNetworkToZoningData().getOsmNodes().get(member.getId());
            if (osmNode == null) {
                if (!this.getSettings().hasBoundingPolygon()) {
                    LOGGER.warning(String.format("unable to collect osm node %d referenced in stop_area %d, this shouldn't happen", member.getId(), osmRelation.getId()));
                }
                return;
            }
            this.processPtv2StopAreaMemberNodeWithoutRole(transferZoneGroup, osmRelation, osmNode);
        } else if (member.getType() == EntityType.Way) {
            this.processPtv2StopAreaMemberWayWithoutRole(transferZoneGroup, osmRelation, member);
        } else {
            LOGGER.info(String.format("stop_area (%d) member without a role found (%d) that is not a node or way, ignored", osmRelation.getId(), member.getId()));
        }
    }

    private void extractPtv2StopPosition(OsmNode osmNode, Map<String, String> tags) throws PlanItException {
        if (OsmPtv1Tags.isTramStop(tags)) {
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
                LOGGER.info(String.format("DISCARD: Ptv2 stop_location with railway=tram_stop (%d) does not reside on tram tracks", osmNode.getId()));
            }
            this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode.getId());
        } else if (OsmPtv1Tags.isBusStop(tags)) {
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
                LOGGER.info(String.format("SALVAGED: Ptv2 public_transport=stop_location also tagged as Ptv1 bus_stop (%d), yet it does not reside on road infrastructure, parse as pole instead", osmNode.getId()));
                this.extractTransferInfrastructurePtv1(osmNode, tags, this.getGeoUtils());
            } else {
                this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode.getId());
            }
        } else if (OsmPtv1Tags.isHalt(tags)) {
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
                LOGGER.info(String.format("SALVAGED: Ptv2 public_transport=stop_location also tagged as Ptv1 halt (%d), yet it does not reside on road infrastructure, parse as small station instead", osmNode.getId()));
                this.extractTransferInfrastructurePtv1(osmNode, tags, this.getGeoUtils());
            } else {
                this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode.getId());
            }
        } else if (OsmPtv1Tags.isStation(tags)) {
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
                LOGGER.info(String.format("SALVAGED: Ptv2 public_transport=stop_location also tagged as Ptv1 station (%d), yet it does not reside on road infrastructure, parse as station instead", osmNode.getId()));
                this.extractTransferInfrastructurePtv1(osmNode, tags, this.getGeoUtils());
            } else {
                LOGGER.warning(String.format("Ptv2 public_transport=stop_location also tagged as Ptv1 station (%d), because it resides on road infrastructure parse as PTv2 stop_position, unusual and likely a tagging error please verify correctness", osmNode.getId()));
                this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode.getId());
            }
        } else {
            this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode.getId());
        }
    }

    private void extractPtv2Platform(OsmNode osmNode, Map<String, String> tags) throws PlanItException {
        this.getProfiler().incrementOsmPtv2TagCounter("platform");
        String defaultOsmMode = OsmModeUtils.identifyPtv1DefaultMode(tags);
        if (this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
            this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode.getId());
        } else {
            this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(osmNode, tags, TransferZoneType.PLATFORM, defaultOsmMode, this.getGeoUtils());
        }
    }

    private void extractPtv1RailwayPlatform(OsmEntity osmEntity, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        this.getProfiler().incrementOsmPtv1TagCounter("platform");
        String defaultMode = OsmModeUtils.identifyPtv1DefaultMode(tags);
        if (!defaultMode.equals("train")) {
            LOGGER.warning(String.format("unexpected osm mode identified for Ptv1 railway platform %s,", defaultMode));
        }
        this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(osmEntity, tags, TransferZoneType.PLATFORM, defaultMode, geoUtils);
    }

    private void extractPtv1StandAloneHalt(OsmNode osmNode, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        this.getProfiler().incrementOsmPtv1TagCounter("halt");
        String expectedDefaultMode = "train";
        String defaultMode = OsmModeUtils.identifyPtv1DefaultMode(tags);
        if (!defaultMode.equals(expectedDefaultMode)) {
            LOGGER.warning(String.format("Unexpected osm mode identified for Ptv1 halt %s", defaultMode));
        }
        this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(osmNode, tags, TransferZoneType.SMALL_STATION, defaultMode, geoUtils);
    }

    private void extractTransferInfrastructurePtv1HighwayPlatform(OsmEntity osmEntity, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Pair<Collection<String>, Collection<Mode>> modeResult;
        String defaultOsmMode = OsmModeUtils.identifyPtv1DefaultMode(tags);
        if (!defaultOsmMode.equals("bus")) {
            LOGGER.warning(String.format("unexpected osm mode identified for Ptv1 highway platform %s,", defaultOsmMode));
        }
        if (OsmModeUtils.hasMappedPlanitMode(modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity(osmEntity.getId(), tags, defaultOsmMode))) {
            this.getProfiler().incrementOsmPtv1TagCounter("platform");
            this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsSetAccessModes(osmEntity, tags, TransferZoneType.PLATFORM, modeResult.first(), geoUtils);
        }
    }

    private void extractTransferInfrastructurePtv1HighwayBusStop(OsmEntity osmEntity, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Pair<Collection<String>, Collection<Mode>> modeResult;
        String defaultOsmMode = OsmModeUtils.identifyPtv1DefaultMode(tags);
        if (!defaultOsmMode.equals("bus")) {
            LOGGER.warning(String.format("unexpected osm mode identified for Ptv1 bus_stop %s,", defaultOsmMode));
        }
        if (OsmModeUtils.hasMappedPlanitMode(modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity(osmEntity.getId(), tags, defaultOsmMode))) {
            this.getProfiler().incrementOsmPtv1TagCounter("bus_stop");
            if (Osm4JUtils.getEntityType(osmEntity).equals((Object)EntityType.Node) && this.hasNetworkLayersWithActiveOsmNode(osmEntity.getId())) {
                this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmEntity.getId());
            } else {
                this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsSetAccessModes(osmEntity, tags, TransferZoneType.POLE, modeResult.first(), geoUtils);
            }
        }
    }

    private void extractTransferInfrastructurePtv1Highway(OsmWay osmWay, Map<String, String> tags, String ptv1ValueTag) throws PlanItException {
        if ("platform".equals(ptv1ValueTag)) {
            this.extractTransferInfrastructurePtv1HighwayPlatform(osmWay, tags, this.getGeoUtils());
        }
    }

    private void extractTransferInfrastructurePtv1Highway(OsmNode osmNode, Map<String, String> tags, String ptv1ValueTag, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        if ("bus_stop".equals(ptv1ValueTag)) {
            this.extractTransferInfrastructurePtv1HighwayBusStop(osmNode, tags, geoUtils);
        } else if ("platform".equals(ptv1ValueTag)) {
            this.extractTransferInfrastructurePtv1HighwayPlatform(osmNode, tags, geoUtils);
        } else {
            LOGGER.warning(String.format("unsupported Ptv1 higway=%s tag encountered, ignored", ptv1ValueTag));
        }
    }

    private void extractTransferInfrastructurePtv1Railway(OsmWay osmWay, Map<String, String> tags, String ptv1ValueTag) throws PlanItException {
        OsmNetworkReaderSettings networkSettings = this.getNetworkToZoningData().getNetworkSettings();
        if ("platform_edge".equals(ptv1ValueTag)) {
            this.getProfiler().incrementOsmPtv1TagCounter(ptv1ValueTag);
        }
        if ("platform".equals(ptv1ValueTag)) {
            this.extractPtv1RailwayPlatform(osmWay, tags, this.getGeoUtils());
        }
        if ("station".equals(ptv1ValueTag) && networkSettings.isRailwayParserActive() && networkSettings.getRailwaySettings().hasAnyMappedPlanitModeOtherThan("tram")) {
            this.getZoningReaderData().getOsmData().addUnprocessedPtv1Station(osmWay);
            this.getProfiler().incrementOsmPtv1TagCounter("station");
        }
    }

    private void extractTransferInfrastructurePtv1Railway(OsmNode osmNode, Map<String, String> tags, String ptv1ValueTag, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        OsmNetworkReaderSettings networkSettings = this.getNetworkToZoningData().getNetworkSettings();
        if ("tram_stop".equals(ptv1ValueTag) && networkSettings.isRailwayParserActive() && networkSettings.getRailwaySettings().hasMappedPlanitMode("tram")) {
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
                LOGGER.info(String.format("DISCARD: Ptv1 railway=tram_stop (%d) does not reside on tram tracks", osmNode.getId()));
            } else {
                this.getProfiler().incrementOsmPtv1TagCounter("tram_stop");
                this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode.getId());
            }
        }
        if ("platform".equals(ptv1ValueTag)) {
            this.extractPtv1RailwayPlatform(osmNode, tags, geoUtils);
        }
        if ("halt".equals(ptv1ValueTag) && networkSettings.getRailwaySettings().hasAnyMappedPlanitModeOtherThan("tram")) {
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNode.getId())) {
                this.extractPtv1StandAloneHalt(osmNode, tags, geoUtils);
            } else {
                this.getProfiler().incrementOsmPtv1TagCounter("halt");
                this.getZoningReaderData().getOsmData().addUnprocessedStopPosition(osmNode.getId());
            }
        }
        if ("station".equals(ptv1ValueTag) && networkSettings.getRailwaySettings().hasAnyMappedPlanitModeOtherThan("tram")) {
            this.getZoningReaderData().getOsmData().addUnprocessedPtv1Station(osmNode);
        }
    }

    private void extractTransferInfrastructurePtv2(OsmWay osmWay, Map<String, String> tags) throws PlanItException {
        if (OsmPtv2Tags.hasPublicTransportKeyTag(tags)) {
            String ptv2ValueTag = tags.get("public_transport");
            if ("platform".equals(ptv2ValueTag)) {
                this.getProfiler().incrementOsmPtv2TagCounter(ptv2ValueTag);
                this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(osmWay, tags, TransferZoneType.PLATFORM, OsmModeUtils.identifyPtv1DefaultMode(tags), this.getGeoUtils());
            }
            if ("stop_position".equals(ptv2ValueTag)) {
                LOGGER.info(String.format("encountered stop_position on osm way %d, this is not properly tagged, ignored", osmWay.getId()));
            }
            if ("station".equals(ptv2ValueTag)) {
                this.getZoningReaderData().getOsmData().addUnprocessedPtv2Station(osmWay);
            }
            if ("stop_area".equals(ptv2ValueTag)) {
                LOGGER.info(String.format("encountered stop_area on osm way %d, this is not properly tagged, ignored", osmWay.getId()));
            }
        } else {
            throw new PlanItException(String.format("parsing transfer infrastructure (Ptv2) for osm way %s, but no public_transport key tag found", osmWay.getId()));
        }
    }

    private void extractTransferInfrastructurePtv1(OsmWay osmWay, Map<String, String> tags) throws PlanItException {
        if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
            String ptv1ValueTag = tags.get("highway");
            this.extractTransferInfrastructurePtv1Highway(osmWay, tags, ptv1ValueTag);
        } else if (OsmRailwayTags.hasRailwayKeyTag(tags) && this.getNetworkToZoningData().getNetworkSettings().isRailwayParserActive()) {
            String ptv1ValueTag = tags.get("railway");
            this.extractTransferInfrastructurePtv1Railway(osmWay, tags, ptv1ValueTag);
        } else {
            throw new PlanItException(String.format("parsing transfer infrastructure (Ptv1) for osm way %s, but no compatible key tags found", osmWay.getId()));
        }
    }

    private void extractTransferInfrastructurePtv2(OsmNode osmNode, Map<String, String> tags) throws PlanItException {
        if (OsmPtv2Tags.hasPublicTransportKeyTag(tags)) {
            String ptv2ValueTag = tags.get("public_transport");
            if ("platform".equals(ptv2ValueTag)) {
                this.extractPtv2Platform(osmNode, tags);
            } else if ("stop_position".equals(ptv2ValueTag)) {
                this.extractPtv2StopPosition(osmNode, tags);
            } else if ("station".equals(ptv2ValueTag)) {
                this.getZoningReaderData().getOsmData().addUnprocessedPtv2Station(osmNode);
                this.getProfiler().incrementOsmPtv2TagCounter("station");
            } else if ("stop_area".equals(ptv2ValueTag)) {
                LOGGER.info(String.format("encountered stop_area on osm node %d, this is not properly tagged, ignored", osmNode.getId()));
            }
        } else {
            throw new PlanItException(String.format("parsing transfer infrastructure (Ptv2) for osm node %s, but no compatible key tags found", osmNode.getId()));
        }
    }

    private void extractTransferInfrastructurePtv1(OsmNode osmNode, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        if (OsmHighwayTags.hasHighwayKeyTag(tags)) {
            String ptv1ValueTag = tags.get("highway");
            this.extractTransferInfrastructurePtv1Highway(osmNode, tags, ptv1ValueTag, geoUtils);
        } else if (OsmRailwayTags.hasRailwayKeyTag(tags)) {
            String ptv1ValueTag = tags.get("railway");
            this.extractTransferInfrastructurePtv1Railway(osmNode, tags, ptv1ValueTag, geoUtils);
        } else {
            throw new PlanItException("parsing transfer infrastructure (Ptv1) for osm node %s, but no compatible key tags found", osmNode.getId());
        }
    }

    private void extractPtv2StopAreaRelation(OsmRelation osmRelation, Map<String, String> tags) throws PlanItException {
        TransferZoneGroup transferZoneGroup = this.getTransferZoneGroupHelper().createPopulateAndRegisterTransferZoneGroup(osmRelation, tags);
        for (int index = 0; index < osmRelation.getNumberOfMembers(); ++index) {
            OsmRelationMember member = osmRelation.getMember(index);
            if (this.skipOsmPtEntity(member)) continue;
            if (member.getRole().equals("platform")) {
                this.registerPtv2StopAreaPlatformOnGroup(transferZoneGroup, osmRelation, member);
                continue;
            }
            if (member.getRole().equals("stop")) {
                if (!this.isPtv2StopAreaWronglyTaggedStopRole(member)) continue;
                this.salvageWronglyTaggedStopRolePtv2StopAreaRelation(transferZoneGroup, osmRelation, member);
                this.getZoningReaderData().getOsmData().addInvalidStopAreaStopPosition(member.getType(), member.getId());
                continue;
            }
            if (!member.getRole().equals("")) continue;
            this.processPtv2StopAreaMemberWithoutRole(transferZoneGroup, osmRelation, member);
        }
    }

    private void extractPtv2OuterRolePlatformRelation(OsmRelation osmRelation, OsmRelationMember member, Map<String, String> tags) throws PlanItException {
        TransferZone transferZone = this.getZoningReaderData().getPlanitData().getIncompleteTransferZoneByOsmId(EntityType.Way, member.getId());
        if (transferZone == null && this.getZoningReaderData().getOsmData().hasOuterRoleOsmWay(member.getId())) {
            OsmWay unprocessedWay = this.getZoningReaderData().getOsmData().getOuterRoleOsmWay(member.getId());
            if (unprocessedWay == null) {
                LOGGER.severe(String.format("Osm way %d referenced by Ptv2 multipolygon %d not available in parser, this should not happen, relation ignored", member.getId(), osmRelation.getId()));
                return;
            }
            this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(unprocessedWay, tags, TransferZoneType.PLATFORM, OsmModeUtils.identifyPtv1DefaultMode(tags), this.getGeoUtils());
        }
    }

    private void extractPtv2PlatformRelation(OsmRelation osmRelation, Map<String, String> tags) throws PlanItException {
        OsmRelationMember member = OsmRelationUtils.findFirstOsmRelationMemberWithRole(osmRelation, "outer");
        if (member != null && !this.skipOsmPtEntity(member)) {
            this.extractPtv2OuterRolePlatformRelation(osmRelation, member, tags);
        }
    }

    protected void extractTransferInfrastructure(OsmNode osmNode, OsmPtVersionScheme ptVersion, Map<String, String> tags) throws PlanItException {
        if (ptVersion == OsmPtVersionScheme.VERSION_2) {
            this.extractTransferInfrastructurePtv2(osmNode, tags);
        } else if (ptVersion == OsmPtVersionScheme.VERSION_1) {
            this.extractTransferInfrastructurePtv1(osmNode, tags, this.getGeoUtils());
        }
    }

    protected void extractTransferInfrastructure(OsmWay osmWay, OsmPtVersionScheme ptVersion, Map<String, String> tags) throws PlanItException {
        if (ptVersion == OsmPtVersionScheme.VERSION_2) {
            this.extractTransferInfrastructurePtv2(osmWay, tags);
        } else if (ptVersion == OsmPtVersionScheme.VERSION_1) {
            this.extractTransferInfrastructurePtv1(osmWay, tags);
        }
    }

    public OsmZoningProcessingHandler(OsmPublicTransportReaderSettings transferSettings, OsmZoningReaderData zoningReaderData, Zoning zoningToPopulate, OsmZoningHandlerProfiler profiler) {
        super(transferSettings, zoningReaderData, zoningToPopulate, profiler);
    }

    @Override
    public void initialiseBeforeParsing() throws PlanItException {
        this.reset();
        PlanItException.throwIf(this.getSettings().getReferenceNetwork().getTransportLayers() == null || ((MacroscopicNetworkLayers)this.getSettings().getReferenceNetwork().getTransportLayers()).size() <= 0, "Network is expected to be populated at start of parsing OSM zoning", new Object[0]);
    }

    @Override
    public void handle(OsmNode osmNode) throws IOException {
        Map<String, String> tags = OsmModelUtil.getTagsAsMap(osmNode);
        try {
            OsmPtVersionScheme ptVersion = this.isActivatedPublicTransportInfrastructure(tags);
            if (ptVersion != OsmPtVersionScheme.NONE) {
                if (this.skipOsmNode(osmNode)) {
                    LOGGER.fine(String.format("Skipped osm node %d, marked for exclusion", osmNode.getId()));
                    return;
                }
                if (!this.isCoveredByZoningBoundingPolygon(osmNode)) {
                    return;
                }
                this.extractTransferInfrastructure(osmNode, ptVersion, tags);
            }
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Error during parsing of OSM node (id:%d) for transfer infrastructure", osmNode.getId()));
        }
    }

    @Override
    public void handle(OsmWay osmWay) throws IOException {
        Map<String, String> tags = OsmModelUtil.getTagsAsMap(osmWay);
        try {
            OsmPtVersionScheme ptVersion = this.isActivatedPublicTransportInfrastructure(tags);
            if (ptVersion != OsmPtVersionScheme.NONE || this.getZoningReaderData().getOsmData().shouldOsmRelationOuterRoleOsmWayBeKept(osmWay)) {
                if (this.skipOsmWay(osmWay)) {
                    LOGGER.fine(String.format("Skipped osm way %d, marked for exclusion", osmWay.getId()));
                    return;
                }
                if (ptVersion != OsmPtVersionScheme.NONE) {
                    if (!this.isCoveredByZoningBoundingPolygon(osmWay)) {
                        return;
                    }
                    this.extractTransferInfrastructure(osmWay, ptVersion, tags);
                } else if (this.isCoveredByZoningBoundingPolygon(osmWay)) {
                    this.getZoningReaderData().getOsmData().addOsmRelationOuterRoleOsmWay(osmWay);
                } else {
                    this.getZoningReaderData().getOsmData().removeOsmRelationOuterRoleOsmWay(osmWay.getId());
                }
            }
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Error during parsing of OSM way (id:%d) for transfer infrastructure", osmWay.getId()));
        }
    }

    @Override
    public void handle(OsmRelation osmRelation) throws IOException {
        Map<String, String> tags = OsmModelUtil.getTagsAsMap(osmRelation);
        try {
            if (this.getSettings().isParserActive() && tags.containsKey("type")) {
                if (tags.get("type").equals("public_transport")) {
                    if (OsmPtv2Tags.hasPublicTransportKeyTag(tags) && tags.get("public_transport").equals("stop_area")) {
                        this.getProfiler().incrementOsmPtv2TagCounter("stop_area");
                        this.extractPtv2StopAreaRelation(osmRelation, tags);
                    } else {
                        LOGGER.info(String.format("unsupported public_transport relation `%s` (%d) ignored", tags.get("public_transport"), osmRelation.getId()));
                    }
                }
                if (tags.get("type").equals("multipolygon") && OsmPtv2Tags.hasPublicTransportKeyTag(tags) && tags.get("public_transport").equals("platform")) {
                    this.getProfiler().incrementOsmPtv2TagCounter("platform");
                    this.extractPtv2PlatformRelation(osmRelation, tags);
                }
            }
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Error during parsing of OSM relation (id:%d) for transfer infrastructure", osmRelation.getId()));
        }
    }

    @Override
    public void complete() throws IOException {
        LOGGER.fine(" OSM transfer zone group parsing...DONE");
    }

    @Override
    public void reset() {
    }
}

