/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning.handler;

import de.topobyte.osm4j.core.model.iface.EntityType;
import de.topobyte.osm4j.core.model.iface.OsmEntity;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmRelation;
import de.topobyte.osm4j.core.model.iface.OsmRelationMember;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.converter.zoning.OsmZoningReaderOsmData;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerBase;
import org.goplanit.osm.converter.zoning.handler.OsmZoningHandlerProfiler;
import org.goplanit.osm.converter.zoning.handler.helper.TransferZoneGroupHelper;
import org.goplanit.osm.tags.OsmPtv2Tags;
import org.goplanit.osm.tags.OsmRailModeTags;
import org.goplanit.osm.tags.OsmRoadModeTags;
import org.goplanit.osm.tags.OsmWaterModeTags;
import org.goplanit.osm.util.Osm4JUtils;
import org.goplanit.osm.util.OsmBoundingAreaUtils;
import org.goplanit.osm.util.OsmModeUtils;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmPtVersionScheme;
import org.goplanit.osm.util.OsmPtVersionSchemeUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.osm.util.PlanitLinkUtils;
import org.goplanit.osm.util.PlanitTransferZoneUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitGraphGeoUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.locale.DrivingDirectionDefaultByCountry;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.linearref.LinearLocation;

public class OsmZoningPostProcessingHandler
extends OsmZoningHandlerBase {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningPostProcessingHandler.class.getCanonicalName());
    private Map<MacroscopicNetworkLayer, Quadtree> spatiallyIndexedOsmNodesInternalToPlanitLinks = null;

    private static Pair<Double, Integer> determineSearchDistanceAndMaxStopLocationMatchesForStandAloneStation(long osmStationId, String osmStationMode, OsmPublicTransportReaderSettings settings) {
        Double searchDistance = null;
        Integer maxMatches = null;
        if (OsmRailModeTags.isRailModeTag(osmStationMode)) {
            searchDistance = settings.getStationToWaitingAreaSearchRadiusMeters();
            maxMatches = 2;
        } else if (OsmRoadModeTags.isRoadModeTag(osmStationMode)) {
            searchDistance = settings.getStopToWaitingAreaSearchRadiusMeters();
            maxMatches = 1;
        } else if (OsmWaterModeTags.isWaterModeTag(osmStationMode)) {
            LOGGER.warning(String.format("DISCARD: water based stand-alone station detected %d, not supported yet, skip", osmStationId));
            return null;
        }
        return Pair.of(searchDistance, maxMatches);
    }

    private void initialiseSpatiallyIndexedOsmNodesInternalToPlanitLinks() {
        double envelopeMinExtentAbsolute = Double.POSITIVE_INFINITY;
        for (MacroscopicNetworkLayer layer : (MacroscopicNetworkLayers)this.getSettings().getReferenceNetwork().getTransportLayers()) {
            OsmNetworkReaderLayerData layerData = this.getNetworkToZoningData().getNetworkLayerData(layer);
            this.spatiallyIndexedOsmNodesInternalToPlanitLinks.put(layer, new Quadtree());
            Quadtree spatialcontainer = this.spatiallyIndexedOsmNodesInternalToPlanitLinks.get(layer);
            Set<Point> registeredInternalLinkLocations = layerData.getRegisteredLocationsInternalToAnyPlanitLink();
            for (Point location : registeredInternalLinkLocations) {
                OsmNode osmNodeAtLocation = layerData.getOsmNodeInternalToLinkByLocation(location);
                Envelope pointEnvelope = new Envelope(location.getCoordinate());
                this.getGeoUtils().createBoundingBox(pointEnvelope, 5.0);
                spatialcontainer.insert(Quadtree.ensureExtent(pointEnvelope, envelopeMinExtentAbsolute), osmNodeAtLocation);
            }
        }
    }

    private Collection<Link> filterDrivingDirectionCompatibleLinks(Geometry waitingAreaGeometry, Collection<String> eligibleOsmModes, Collection<Link> linksToVerify) throws PlanItException {
        boolean isLeftHandDrive = DrivingDirectionDefaultByCountry.isLeftHandDrive(this.getZoningReaderData().getCountryName());
        Set<Mode> accessModes = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitModes(OsmModeUtils.extractPublicTransportModesFrom(eligibleOsmModes));
        return PlanitLinkUtils.excludeLinksOnWrongSideOf(waitingAreaGeometry, linksToVerify, isLeftHandDrive, accessModes, this.getGeoUtils());
    }

    private Link findMostAppropriateStopLocationLinkForWaitingArea(TransferZone transferZone, String osmAccessMode, Collection<Link> eligibleLinks) throws PlanItException {
        boolean salvaging = false;
        do {
            Link closestLink = (Link)PlanitGraphGeoUtils.findEdgeClosest(transferZone.getGeometry(), eligibleLinks, this.getGeoUtils());
            Collection<Link> result = this.filterDrivingDirectionCompatibleLinks(transferZone.getGeometry(), Collections.singleton(osmAccessMode), Collections.singleton(closestLink));
            if (result != null && !result.isEmpty()) break;
            LOGGER.fine(String.format("Waiting area (osm id %s) for mode %s is situated on the wrong side of closest eligible road %s, attempting to salvage", transferZone.getExternalId(), osmAccessMode, closestLink.getExternalId()));
            eligibleLinks.remove(closestLink);
            salvaging = true;
        } while (!eligibleLinks.isEmpty());
        if (eligibleLinks.isEmpty()) {
            this.logWarningIfNotNearBoundingBox(String.format("DISCARD: No suitable stop_location on correct side of osm way candidates available for transfer zone %s and mode %s", transferZone.getExternalId(), osmAccessMode), transferZone.getGeometry());
            return null;
        }
        Link selectedAccessLink = null;
        Pair<? extends Edge, Set<? extends Edge>> candidatesForStopLocation = PlanitGraphGeoUtils.findEdgesClosest(transferZone.getGeometry(), eligibleLinks, OsmPublicTransportReaderSettings.DEFAULT_CLOSEST_EDGE_SEARCH_BUFFER_DISTANCE_M, this.getGeoUtils());
        if (candidatesForStopLocation == null) {
            throw new PlanItException("No closest link could be found from selection of eligible closeby links when finding stop locations for transfer zone (osm entity id %s), this should not happen", transferZone.getExternalId());
        }
        if (candidatesForStopLocation.second() == null || candidatesForStopLocation.second().isEmpty()) {
            selectedAccessLink = (Link)candidatesForStopLocation.first();
        } else {
            Mode accessMode = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitMode(osmAccessMode);
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getSettings().getReferenceNetwork().getLayerByMode(accessMode);
            Set candidatesToFilter = candidatesForStopLocation.second();
            candidatesToFilter.add((Edge)((Link)candidatesForStopLocation.first()));
            candidatesToFilter = (Set)this.filterDrivingDirectionCompatibleLinks(transferZone.getGeometry(), Collections.singleton(osmAccessMode), candidatesToFilter);
            Iterator iterator = candidatesToFilter.iterator();
            while (iterator.hasNext()) {
                Edge candidateLink = (Edge)iterator.next();
                Point connectoidLocation = this.getConnectoidHelper().findConnectoidLocationForstandAloneTransferZoneOnLink(transferZone, (Link)candidateLink, accessMode, this.getSettings().getStopToWaitingAreaSearchRadiusMeters(), networkLayer);
                if (connectoidLocation != null) continue;
                iterator.remove();
            }
            if (candidatesToFilter == null || candidatesToFilter.isEmpty()) {
                this.logWarningIfNotNearBoundingBox(String.format("DISCARD: No suitable stop_location on potential osm way candidates found for transfer zone %s and mode %s", transferZone.getExternalId(), accessMode.getName()), transferZone.getGeometry());
                return null;
            }
            if (OsmRoadModeTags.isRoadModeTag(osmAccessMode)) {
                OsmWayUtils.removeEdgesWithOsmHighwayTypesLessImportantThan(OsmWayUtils.findMostProminentOsmHighWayType(candidatesToFilter), candidatesToFilter);
            }
            selectedAccessLink = candidatesToFilter.size() == 1 ? (Link)candidatesToFilter.iterator().next() : (Link)PlanitGraphGeoUtils.findEdgeClosest(transferZone.getGeometry(), candidatesToFilter, this.getGeoUtils());
        }
        if (salvaging) {
            LOGGER.info(String.format("SALVAGED: Used non-closest osm way to %s %s to ensure waiting area %s is on correct side of road for mode %s", selectedAccessLink.getExternalId(), selectedAccessLink.getName() != null ? selectedAccessLink.getName() : "", transferZone.getExternalId(), osmAccessMode));
        }
        return selectedAccessLink;
    }

    private Collection<Link> findModeBBoxCompatibleLinksForOsmGeometry(Long osmEntityId, Geometry waitingAreaGeometry, String eligibleOsmMode, Envelope searchBoundingBox) throws PlanItException {
        Set<String> eligibleOsmModes = Collections.singleton(eligibleOsmMode);
        Collection<Link> spatiallyMatchedLinks = this.getZoningReaderData().getPlanitData().findLinksSpatially(searchBoundingBox);
        if (spatiallyMatchedLinks == null || spatiallyMatchedLinks.isEmpty()) {
            this.logWarningIfNotNearBoundingBox(String.format("Waiting area (osm id %d) has no nearby infrastructure that qualifies for pt modes %s as stop locations", osmEntityId, OsmModeUtils.extractPublicTransportModesFrom(eligibleOsmModes).toString()), waitingAreaGeometry);
            return null;
        }
        Collection<Link> modeAndSpatiallyCompatibleLinks = this.getPtModeHelper().filterModeCompatibleLinks(eligibleOsmModes, spatiallyMatchedLinks, false);
        if (modeAndSpatiallyCompatibleLinks == null || modeAndSpatiallyCompatibleLinks.isEmpty()) {
            LOGGER.warning(String.format("OSM entitity (%d) has no compatible modes (%s) on nearby infrastructure that qualifies for stop location", osmEntityId, OsmModeUtils.extractPublicTransportModesFrom(eligibleOsmModes).toString()));
            return null;
        }
        return modeAndSpatiallyCompatibleLinks;
    }

    private Collection<Link> findStopLocationLinksForStation(OsmEntity stationEntity, TransferZone transferZone, String referenceOsmMode, Envelope searchBoundingBox, Integer maxMatches) throws PlanItException {
        Collection<Link> directionModeSpatiallyCompatibleLinks = this.findModeBBoxCompatibleLinksForOsmGeometry(stationEntity.getId(), transferZone.getGeometry(), referenceOsmMode, searchBoundingBox);
        if (directionModeSpatiallyCompatibleLinks == null || directionModeSpatiallyCompatibleLinks.isEmpty()) {
            return null;
        }
        Set<Link> chosenLinksForStopLocations = null;
        Link idealAccessLink = this.findMostAppropriateStopLocationLinkForWaitingArea(transferZone, referenceOsmMode, directionModeSpatiallyCompatibleLinks);
        if (idealAccessLink == null) {
            throw new PlanItException("No appropriate link could be found from selection of eligible closeby links when finding stop locations for station %s, this should not happen", transferZone.getExternalId());
        }
        if (maxMatches == 1) {
            chosenLinksForStopLocations = Collections.singleton(idealAccessLink);
        } else if (maxMatches > 1) {
            chosenLinksForStopLocations = new HashSet<Link>();
            LineSegment stationToClosestPointOnClosestLinkSegment = null;
            if (Osm4JUtils.getEntityType(stationEntity) == EntityType.Node) {
                Coordinate closestCoordinate = OsmNodeUtils.findClosestProjectedCoordinateTo((OsmNode)stationEntity, idealAccessLink.getGeometry(), this.getGeoUtils());
                Point osmStationLocation = PlanitJtsUtils.createPoint(OsmNodeUtils.createCoordinate((OsmNode)stationEntity));
                stationToClosestPointOnClosestLinkSegment = PlanitJtsUtils.createLineSegment(osmStationLocation.getCoordinate(), closestCoordinate);
            } else if (Osm4JUtils.getEntityType(stationEntity) == EntityType.Way) {
                stationToClosestPointOnClosestLinkSegment = OsmWayUtils.findMinimumLineSegmentBetween((OsmWay)stationEntity, idealAccessLink.getGeometry(), this.getNetworkToZoningData().getOsmNodes(), this.getGeoUtils());
            } else {
                throw new PlanItException("unknown entity type %s for osm station encountered, this should not happen", Osm4JUtils.getEntityType(stationEntity).toString());
            }
            LineSegment interSectionLineSegment = this.getGeoUtils().createExtendedLineSegment(stationToClosestPointOnClosestLinkSegment, this.getSettings().getStationToParallelTracksSearchRadiusMeters(), true, true);
            LineString virtualInterSectionGeometryForParallelTracks = PlanitJtsUtils.createLineString(interSectionLineSegment.getCoordinate(0), interSectionLineSegment.getCoordinate(1));
            for (Link link : directionModeSpatiallyCompatibleLinks) {
                if (!link.getGeometry().intersects(virtualInterSectionGeometryForParallelTracks)) continue;
                LinearLocation closestLinkLinearLocation = this.getGeoUtils().getClosestGeometryExistingCoordinateToProjectedLinearLocationOnLineString(transferZone.getGeometry(), link.getGeometry());
                Point closestLinkLocation = PlanitJtsUtils.createPoint(closestLinkLinearLocation.getCoordinate(link.getGeometry()));
                double distanceStationToPotentialAccessLink = this.getGeoUtils().getClosestDistanceInMeters(closestLinkLocation, transferZone.getGeometry());
                if (!(distanceStationToPotentialAccessLink < this.getSettings().getStationToWaitingAreaSearchRadiusMeters())) continue;
                chosenLinksForStopLocations.add(link);
            }
        } else if (maxMatches < 1) {
            LOGGER.severe(String.format("Invalid number of maximum matches %d provided when finding stop location links for station %d", maxMatches, stationEntity.getId()));
            return null;
        }
        if (chosenLinksForStopLocations == null || chosenLinksForStopLocations.isEmpty()) {
            throw new PlanItException("No links could be identified from virtual line connecting station to closest by point on closest link for osm station %d, this should not happen", stationEntity.getId());
        }
        return chosenLinksForStopLocations;
    }

    private void processStationNotPartOfStopArea(OsmEntity osmStation, Envelope eligibleSearchBoundingBox) throws PlanItException {
        Map<String, String> tags = OsmModelUtil.getTagsAsMap(osmStation);
        OsmPtVersionScheme ptVersion = this.isActivatedPublicTransportInfrastructure(tags);
        this.getZoningReaderData().getOsmData().removeUnproccessedStation(ptVersion, osmStation);
        Pair<Collection<String>, Collection<Mode>> modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity(osmStation.getId(), tags, OsmModeUtils.identifyPtv1DefaultMode(tags));
        Collection<String> eligibleOsmModes = modeResult != null ? modeResult.first() : null;
        HashSet<TransferZone> matchedTransferZones = new HashSet<TransferZone>();
        Collection<TransferZone> potentialTransferZones = this.getZoningReaderData().getPlanitData().getTransferZonesSpatially(eligibleSearchBoundingBox);
        if (potentialTransferZones != null && !potentialTransferZones.isEmpty()) {
            Set<TransferZoneGroup> potentialTransferZoneGroups = this.getTransferZoneGroupHelper().findModeCompatibleTransferZoneGroups(eligibleOsmModes, potentialTransferZones, false);
            if (potentialTransferZoneGroups != null && !potentialTransferZoneGroups.isEmpty()) {
                if (!potentialTransferZoneGroups.isEmpty()) {
                    TransferZone closestZone = PlanitTransferZoneUtils.findTransferZoneClosestByTransferGroup(osmStation, potentialTransferZoneGroups, this.getNetworkToZoningData().getOsmNodes(), this.getGeoUtils());
                    Set<TransferZoneGroup> groups = closestZone.getTransferZoneGroups();
                    for (TransferZoneGroup group : groups) {
                        TransferZoneGroupHelper.updateTransferZoneGroupStationName(group, osmStation, tags);
                        for (TransferZone zone : group.getTransferZones()) {
                            PlanitTransferZoneUtils.updateTransferZoneStationName(zone, tags);
                            matchedTransferZones.add(zone);
                        }
                    }
                }
            } else {
                Set<TransferZone> modeCompatibleTransferZones = this.getTransferZoneHelper().filterModeCompatibleTransferZones(eligibleOsmModes, potentialTransferZones, true);
                if (modeCompatibleTransferZones != null && !modeCompatibleTransferZones.isEmpty()) {
                    for (TransferZone zone : modeCompatibleTransferZones) {
                        PlanitTransferZoneUtils.updateTransferZoneStationName(zone, tags);
                        matchedTransferZones.add(zone);
                    }
                }
            }
        }
        if (matchedTransferZones.isEmpty()) {
            if (OsmModeUtils.hasMappedPlanitMode(modeResult)) {
                this.extractStandAloneStation(osmStation, tags, this.getGeoUtils());
            }
        } else if (LOGGER.getLevel() == Level.FINE) {
            String transferZonesExternalId = matchedTransferZones.stream().map(z -> z.getExternalId()).collect(Collectors.toSet()).toString();
            LOGGER.fine(String.format("Station %d mapped to platform/pole(s) %s", osmStation.getId(), transferZonesExternalId));
        }
    }

    private void processStationsNotPartOfStopArea(Set<OsmEntity> unprocessedStations, EntityType type, OsmPtVersionScheme ptVersion) throws PlanItException {
        if (unprocessedStations != null) {
            block4: for (OsmEntity osmStation : unprocessedStations) {
                Envelope boundingBox = OsmBoundingAreaUtils.createBoundingBoxForOsmWay(osmStation, this.getSettings().getStationToWaitingAreaSearchRadiusMeters(), this.getNetworkToZoningData().getOsmNodes(), this.getGeoUtils());
                if (boundingBox == null) continue;
                this.processStationNotPartOfStopArea(osmStation, boundingBox);
                switch (ptVersion) {
                    case VERSION_1: {
                        this.getProfiler().incrementOsmPtv1TagCounter("station");
                        continue block4;
                    }
                    case VERSION_2: {
                        this.getProfiler().incrementOsmPtv2TagCounter("station");
                        continue block4;
                    }
                }
                LOGGER.severe(String.format("unknown Pt version found %s when processing station %s not part of a stop_area", osmStation.getId(), ptVersion.toString()));
            }
        }
    }

    private void processStationsNotPartOfStopArea() throws PlanItException {
        HashSet<OsmEntity> unprocessedStations;
        OsmZoningReaderOsmData osmData = this.getZoningReaderData().getOsmData();
        if (!osmData.getUnprocessedPtv1Stations(EntityType.Node).isEmpty()) {
            unprocessedStations = new HashSet<OsmEntity>(osmData.getUnprocessedPtv1Stations(EntityType.Node).values());
            this.processStationsNotPartOfStopArea(unprocessedStations, EntityType.Node, OsmPtVersionScheme.VERSION_1);
        }
        if (!osmData.getUnprocessedPtv1Stations(EntityType.Way).isEmpty()) {
            unprocessedStations = new HashSet<OsmEntity>(osmData.getUnprocessedPtv1Stations(EntityType.Way).values());
            this.processStationsNotPartOfStopArea(unprocessedStations, EntityType.Way, OsmPtVersionScheme.VERSION_1);
        }
        if (!osmData.getUnprocessedPtv2Stations(EntityType.Node).isEmpty()) {
            unprocessedStations = new HashSet<OsmEntity>(osmData.getUnprocessedPtv2Stations(EntityType.Node).values());
            this.processStationsNotPartOfStopArea(unprocessedStations, EntityType.Node, OsmPtVersionScheme.VERSION_2);
        }
        if (!osmData.getUnprocessedPtv2Stations(EntityType.Way).isEmpty()) {
            unprocessedStations = new HashSet<OsmEntity>(osmData.getUnprocessedPtv2Stations(EntityType.Way).values());
            this.processStationsNotPartOfStopArea(unprocessedStations, EntityType.Way, OsmPtVersionScheme.VERSION_2);
        }
    }

    private void processStopPositionNotPartOfStopArea(OsmNode osmNode, Map<String, String> tags) throws PlanItException {
        this.getZoningReaderData().getOsmData().removeUnprocessedStopPosition(osmNode.getId());
        String defaultOsmMode = OsmModeUtils.identifyPtv1DefaultMode(tags);
        Pair<Collection<String>, Collection<Mode>> modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity(osmNode.getId(), tags, defaultOsmMode);
        if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            return;
        }
        Collection<String> eligibleOsmModes = modeResult.first();
        Point osmNodeLocation = OsmNodeUtils.createPoint(osmNode);
        for (String osmMode : eligibleOsmModes) {
            Mode planitMode = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitMode(osmMode);
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getSettings().getReferenceNetwork().getLayerByMode(planitMode);
            if (!this.getNetworkToZoningData().getNetworkLayerData(networkLayer).isLocationPresentInLayer(osmNodeLocation)) {
                LOGGER.fine(String.format("DISCARD: stop_location %d is not part of any parsed link in the network, likely incorrectly tagged", osmNode.getId()));
                continue;
            }
            Collection<TransferZone> matchedTransferZones = this.getTransferZoneHelper().findTransferZonesForStopPosition(osmNode, tags, Collections.singleton(osmMode));
            if (matchedTransferZones == null || matchedTransferZones.isEmpty()) {
                this.logWarningIfNotNearBoundingBox(String.format("DISCARD: stop_position %d has no valid pole, platform, station reference, nor closeby infrastructure that qualifies as such for mode %s", osmNode.getId(), osmMode), osmNodeLocation);
                return;
            }
            for (TransferZone transferZone : matchedTransferZones) {
                this.getConnectoidHelper().extractDirectedConnectoidsForMode(osmNode, transferZone, planitMode, this.getGeoUtils());
            }
        }
    }

    private void processStopPositionsNotPartOfStopArea() throws PlanItException {
        TreeSet<Long> unprocessedStopPositions = new TreeSet<Long>(this.getZoningReaderData().getOsmData().getUnprocessedStopPositions());
        if (!unprocessedStopPositions.isEmpty()) {
            for (Long osmNodeId : unprocessedStopPositions) {
                OsmNode osmNode = this.getNetworkToZoningData().getOsmNodes().get(osmNodeId);
                this.processStopPositionNotPartOfStopArea(osmNode, OsmModelUtil.getTagsAsMap(osmNode));
            }
        }
    }

    private void processIncompleteTransferZone(TransferZone transferZone) throws PlanItException {
        boolean transferZoneOnInfrastructure;
        EntityType osmEntityType = PlanitTransferZoneUtils.extractOsmEntityType(transferZone);
        long osmEntityId = Long.valueOf(transferZone.getExternalId());
        Collection<String> accessOsmModes = OsmModeUtils.extractPublicTransportModesFrom(PlanitTransferZoneUtils.getRegisteredOsmModesForTransferZone(transferZone));
        if (!this.getNetworkToZoningData().getNetworkSettings().hasAnyMappedPlanitMode(accessOsmModes)) {
            LOGGER.warning(String.format("DISCARD: waiting area (osm id %d) has no supported public transport planit modes present", osmEntityId));
            return;
        }
        boolean bl = transferZoneOnInfrastructure = osmEntityType.equals((Object)EntityType.Node) && this.hasNetworkLayersWithActiveOsmNode(osmEntityId);
        if (transferZoneOnInfrastructure) {
            LOGGER.severe(String.format("DISCARD: waiting area (osm id %d) identified to be placed on road/rail infrastructure, this shouldn't happen", osmEntityId));
            return;
        }
        for (String osmAccessMode : accessOsmModes) {
            Mode accessMode = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitMode(osmAccessMode);
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getSettings().getReferenceNetwork().getLayerByMode(accessMode);
            Link selectedAccessLink = null;
            if (this.getSettings().hasWaitingAreaNominatedOsmWayForStopLocation(osmEntityId, osmEntityType)) {
                long osmWayId = this.getSettings().getWaitingAreaNominatedOsmWayForStopLocation(osmEntityId, osmEntityType);
                selectedAccessLink = PlanitLinkUtils.getClosestLinkWithOsmWayIdToGeometry(osmWayId, transferZone.getGeometry(), networkLayer, this.getGeoUtils());
                if (selectedAccessLink == null) {
                    LOGGER.warning(String.format("DISCARD: User nominated osm way %d not available for waiting area %s", osmWayId, transferZone.getExternalId()));
                    return;
                }
            } else {
                Envelope searchBoundingBox = this.getGeoUtils().createBoundingBox(transferZone.getEnvelope(), this.getSettings().getStopToWaitingAreaSearchRadiusMeters());
                Collection<Link> directionModeSpatiallyCompatibleLinks = this.findModeBBoxCompatibleLinksForOsmGeometry(osmEntityId, transferZone.getGeometry(), osmAccessMode, searchBoundingBox);
                if (directionModeSpatiallyCompatibleLinks == null || directionModeSpatiallyCompatibleLinks.isEmpty()) {
                    this.logWarningIfNotNearBoundingBox(String.format("DISCARD: No accessible links within maximum search distance (%.2fm) found for waiting area %s and mode %s", this.getSettings().getStopToWaitingAreaSearchRadiusMeters(), transferZone.getExternalId(), osmAccessMode), transferZone.getGeometry());
                    return;
                }
                selectedAccessLink = this.findMostAppropriateStopLocationLinkForWaitingArea(transferZone, osmAccessMode, directionModeSpatiallyCompatibleLinks);
            }
            if (selectedAccessLink == null) continue;
            this.getConnectoidHelper().extractDirectedConnectoidsForStandAloneTransferZoneByPlanitLink(Long.valueOf(transferZone.getExternalId()), transferZone.getGeometry(), selectedAccessLink, transferZone, accessMode, this.getSettings().getStopToWaitingAreaSearchRadiusMeters(), networkLayer);
        }
    }

    private void processIncompleteTransferZones(Collection<TransferZone> transferZones) throws PlanItException {
        TreeSet<TransferZone> unprocessedTransferZones = new TreeSet<TransferZone>(transferZones);
        for (TransferZone transferZone : unprocessedTransferZones) {
            if (this.getZoningReaderData().getPlanitData().hasConnectoids(transferZone)) continue;
            this.processIncompleteTransferZone(transferZone);
        }
    }

    private void processIncompleteTransferZones() throws PlanItException {
        this.processIncompleteTransferZones(this.getZoningReaderData().getPlanitData().getTransferZonesByOsmId(EntityType.Node));
        this.processIncompleteTransferZones(this.getZoningReaderData().getPlanitData().getTransferZonesByOsmId(EntityType.Way));
    }

    private void extractStandAloneStationConnectoids(OsmEntity osmStation, Map<String, String> tags, TransferZone stationTransferZone, Collection<String> osmAccessModes, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        EntityType osmStationEntityType = Osm4JUtils.getEntityType(osmStation);
        for (String osmAccessMode : osmAccessModes) {
            Mode planitMode = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitMode(osmAccessMode);
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getSettings().getReferenceNetwork().getLayerByMode(planitMode);
            Pair<Double, Integer> result = OsmZoningPostProcessingHandler.determineSearchDistanceAndMaxStopLocationMatchesForStandAloneStation(osmStation.getId(), osmAccessMode, this.getSettings());
            if (result == null) {
                LOGGER.warning(String.format("DISCARD: unable to process stand-alone station %d supported mode %s, skip", osmStation.getId(), osmAccessMode));
                continue;
            }
            double maxSearchDistance = result.first();
            int maxStopLocations = result.second();
            Collection<Link> accessLinks = null;
            if (this.getSettings().hasWaitingAreaNominatedOsmWayForStopLocation(osmStation.getId(), osmStationEntityType)) {
                long osmWayId = this.getSettings().getWaitingAreaNominatedOsmWayForStopLocation(osmStation.getId(), osmStationEntityType);
                Link nominatedLink = PlanitLinkUtils.getClosestLinkWithOsmWayIdToGeometry(osmWayId, stationTransferZone.getGeometry(), networkLayer, geoUtils);
                if (nominatedLink != null) {
                    accessLinks = Collections.singleton(nominatedLink);
                } else {
                    LOGGER.severe(String.format("User nominated osm way not available for station %d", osmWayId));
                }
            } else {
                Envelope searchBoundingBox = OsmBoundingAreaUtils.createBoundingBoxForOsmWay(osmStation, maxSearchDistance, this.getNetworkToZoningData().getOsmNodes(), geoUtils);
                accessLinks = this.findStopLocationLinksForStation(osmStation, stationTransferZone, osmAccessMode, searchBoundingBox, maxStopLocations);
            }
            if (accessLinks == null) {
                this.logWarningIfNotNearBoundingBox(String.format("DISCARD: station %d has no eligible links to qualify for pt vehicles as stop locations", osmStation.getId()), stationTransferZone.getGeometry());
                return;
            }
            for (Link accessLink : accessLinks) {
                this.getConnectoidHelper().extractDirectedConnectoidsForStandAloneTransferZoneByPlanitLink(osmStation.getId(), stationTransferZone.getGeometry(), accessLink, stationTransferZone, planitMode, this.getSettings().getStationToWaitingAreaSearchRadiusMeters(), networkLayer);
            }
        }
    }

    private void extractStandAloneStation(OsmEntity osmStation, Map<String, String> tags, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        boolean stationOnTrack;
        String defaultMode = OsmModeUtils.identifyPtv1DefaultMode(tags, "train");
        Pair<Collection<String>, Collection<Mode>> modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity(osmStation.getId(), tags, defaultMode);
        if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            return;
        }
        Collection<String> osmAccessModes = modeResult.first();
        TransferZone stationTransferZone = null;
        EntityType osmStationEntityType = Osm4JUtils.getEntityType(osmStation);
        boolean bl = stationOnTrack = osmStationEntityType.equals((Object)EntityType.Node) && this.hasNetworkLayersWithActiveOsmNode(osmStation.getId());
        if (stationOnTrack && !this.getSettings().isOverwriteStopLocationWaitingArea(osmStation.getId())) {
            OsmNode osmStationNode = this.getNetworkToZoningData().getOsmNodes().get(osmStation.getId());
            TransferZoneType ptv1TransferZoneType = PlanitTransferZoneUtils.extractTransferZoneTypeFromPtv1Tags(osmStationNode, tags);
            this.getTransferZoneHelper().createAndRegisterTransferZoneWithConnectoidsAtOsmNode(osmStationNode, tags, defaultMode, ptv1TransferZoneType, geoUtils);
        } else {
            if (this.getSettings().isOverwriteStopLocationWaitingArea(osmStation.getId())) {
                Pair<EntityType, Long> result = this.getSettings().getOverwrittenStopLocationWaitingArea(osmStation.getId());
                stationTransferZone = this.getZoningReaderData().getPlanitData().getTransferZoneByOsmId(result.first(), result.second());
                LOGGER.fine(String.format("Mapped station stop_position %d to overwritten waiting area %d", osmStation.getId(), result.second()));
            } else {
                stationTransferZone = this.getTransferZoneHelper().createAndRegisterTransferZoneWithoutConnectoidsFindAccessModes(osmStation, tags, TransferZoneType.SMALL_STATION, defaultMode, geoUtils);
            }
            if (stationTransferZone == null) {
                LOGGER.warning(String.format("DISCARD: Unable to create transfer zone for osm station %d", osmStation.getId()));
                return;
            }
            PlanitTransferZoneUtils.updateTransferZoneStationName(stationTransferZone, tags);
            if (this.getSettings().isWaitingAreaStopLocationOverwritten(osmStationEntityType, osmStation.getId())) {
                return;
            }
            this.extractStandAloneStationConnectoids(osmStation, tags, stationTransferZone, osmAccessModes, geoUtils);
        }
    }

    private void extractRemainingOsmEntitiesNotPartOfStopArea() throws PlanItException {
        this.processStationsNotPartOfStopArea();
        this.processStopPositionsNotPartOfStopArea();
        this.processIncompleteTransferZones();
    }

    private void extractKnownPtv2StopAreaStopPosition(OsmNode osmNode, Map<String, String> tags, TransferZoneGroup transferZoneGroup) throws PlanItException {
        Pair<Collection<String>, Collection<Mode>> modeResult = this.getPtModeHelper().collectPublicTransportModesFromPtEntity(osmNode.getId(), tags, null);
        if (!OsmModeUtils.hasMappedPlanitMode(modeResult)) {
            return;
        }
        Collection<TransferZone> matchedTransferZones = this.getTransferZoneHelper().findTransferZonesForStopPosition(osmNode, tags, modeResult.first(), transferZoneGroup);
        if (matchedTransferZones == null || matchedTransferZones.isEmpty()) {
            this.logWarningIfNotNearBoundingBox(String.format("DISCARD: Stop position %d in stop_area %s has no valid pole, platform, station reference, nor closeby infrastructure that qualifies", osmNode.getId(), transferZoneGroup.getExternalId()), OsmNodeUtils.createPoint(osmNode));
            return;
        }
        this.getConnectoidHelper().extractDirectedConnectoids(osmNode, tags, matchedTransferZones, modeResult.second(), transferZoneGroup);
    }

    private void extractUnknownPtv2StopAreaStopPosition(OsmNode osmNode, Map<String, String> tags, TransferZoneGroup transferZoneGroup) throws PlanItException {
        Collection<TransferZone> matchedTransferZones = this.getTransferZoneHelper().findTransferZonesForStopPosition(osmNode, tags, null, transferZoneGroup);
        if (matchedTransferZones == null || matchedTransferZones.isEmpty()) {
            this.logWarningIfNotNearBoundingBox(String.format("DISCARD: stop_position %d without proper tagging on OSM network could not be mapped to closeby transfer zone in stop_area", osmNode.getId()), OsmNodeUtils.createPoint(osmNode));
            return;
        }
        if (matchedTransferZones.size() > 1) {
            throw new PlanItException("Identified more than one spatially closest transfer zone for stop_position %d that was not tagged as such in stop_area %s, this should nto happen", osmNode.getId(), transferZoneGroup.getExternalId());
        }
        TransferZone foundZone = matchedTransferZones.iterator().next();
        Set<Mode> accessModes = this.getNetworkToZoningData().getNetworkSettings().getMappedPlanitModes(PlanitTransferZoneUtils.getRegisteredOsmModesForTransferZone(foundZone));
        if (accessModes == null) {
            LOGGER.warning(String.format("DISCARD: stop_position %d without proper tagging on OSM network, unable to identify access modes from closest transfer zone in stop_area", osmNode.getId()));
            return;
        }
        this.getConnectoidHelper().extractDirectedConnectoids(osmNode, tags, Collections.singleton(foundZone), accessModes, transferZoneGroup);
    }

    private void extractPtv2StopAreaStopPosition(OsmRelationMember member, TransferZoneGroup transferZoneGroup) throws PlanItException {
        PlanItException.throwIfNull(member, "Stop_area stop_position member null");
        this.getProfiler().incrementOsmPtv2TagCounter("stop_position");
        if (this.getZoningReaderData().getOsmData().isInvalidStopAreaStopPosition(member.getType(), member.getId())) {
            return;
        }
        if (member.getType() != EntityType.Node) {
            throw new PlanItException("Stop_position %d encountered that it not an OSM node, this is not permitted", member.getId());
        }
        OsmNode stopPositionNode = this.getNetworkToZoningData().getOsmNodes().get(member.getId());
        if (stopPositionNode == null) {
            if (!this.getSettings().hasBoundingPolygon()) {
                LOGGER.warning(String.format("DISCARD:Unable to extract ptv2 stop position %d in stop area %s, osm node missing", member.getId(), transferZoneGroup.getExternalId()));
            }
            return;
        }
        Map<String, String> tags = OsmModelUtil.getTagsAsMap(stopPositionNode);
        Boolean isKnownPtv2StopPosition = null;
        if (this.getZoningReaderData().getOsmData().hasUnprocessedStopPosition(member.getId())) {
            isKnownPtv2StopPosition = true;
        } else {
            boolean isPtv2NodeOnly = !OsmPtVersionSchemeUtils.isPtv2StopPositionPtv1Stop(stopPositionNode, tags);
            boolean alreadyProcessed = this.getZoningReaderData().getPlanitData().hasAnyDirectedConnectoidsForLocation(OsmNodeUtils.createPoint(stopPositionNode));
            if (isPtv2NodeOnly && alreadyProcessed) {
                LOGGER.fine(String.format("Stop_position %d present in multiple stop_areas, discouraged tagging behaviour, consider retagging", member.getId(), transferZoneGroup.getExternalId()));
            }
            if (alreadyProcessed) {
                return;
            }
            LOGGER.fine(String.format("Stop_position %d in stop_area not marked as such on OSM node, inferring transfer zone and access modes by geographically closest transfer zone in stop_area instead ", member.getId()));
            isKnownPtv2StopPosition = false;
        }
        if (isKnownPtv2StopPosition.booleanValue()) {
            this.extractKnownPtv2StopAreaStopPosition(stopPositionNode, tags, transferZoneGroup);
            this.getZoningReaderData().getOsmData().removeUnprocessedStopPosition(stopPositionNode.getId());
        } else {
            this.extractUnknownPtv2StopAreaStopPosition(stopPositionNode, tags, transferZoneGroup);
        }
    }

    private void extractPtv2StopAreaPostProcessingEntities(OsmRelation osmRelation, Map<String, String> tags) throws PlanItException {
        TransferZoneGroup transferZoneGroup = this.getZoningReaderData().getPlanitData().getTransferZoneGroupByOsmId(osmRelation.getId());
        if (transferZoneGroup == null) {
            LOGGER.severe(String.format("found stop_area %d in post-processing for which not PLANit transfer zone group has been created, this should not happen", osmRelation.getId()));
        }
        for (int index = 0; index < osmRelation.getNumberOfMembers(); ++index) {
            OsmRelationMember member = osmRelation.getMember(index);
            if (this.skipOsmPtEntity(member) || !member.getRole().equals("stop")) continue;
            this.extractPtv2StopAreaStopPosition(member, transferZoneGroup);
        }
    }

    public OsmZoningPostProcessingHandler(OsmPublicTransportReaderSettings transferSettings, OsmZoningReaderData handlerData, Zoning zoningToPopulate, OsmZoningHandlerProfiler profiler) {
        super(transferSettings, handlerData, zoningToPopulate, profiler);
    }

    @Override
    public void initialiseBeforeParsing() throws PlanItException {
        this.reset();
        PlanItException.throwIf(this.getSettings().getReferenceNetwork().getTransportLayers() == null || ((MacroscopicNetworkLayers)this.getSettings().getReferenceNetwork().getTransportLayers()).size() <= 0, "network is expected to be populated at start of parsing OSM zoning", new Object[0]);
        this.initialiseSpatiallyIndexedOsmNodesInternalToPlanitLinks();
    }

    @Override
    public void handle(OsmRelation osmRelation) throws IOException {
        Map<String, String> tags = OsmModelUtil.getTagsAsMap(osmRelation);
        try {
            if (this.getSettings().isParserActive() && tags.containsKey("type") && tags.get("type").equals("public_transport")) {
                if (OsmPtv2Tags.hasPublicTransportKeyTag(tags) && tags.get("public_transport").equals("stop_area")) {
                    this.extractPtv2StopAreaPostProcessingEntities(osmRelation, tags);
                } else {
                    LOGGER.info(String.format("Unknown public_transport relation %s encountered for relation %d, ignored", tags.get("public_transport"), osmRelation.getId()));
                }
            }
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe(String.format("Error during parsing of OSM relation (id:%d) for transfer infrastructure", osmRelation.getId()));
        }
    }

    @Override
    public void complete() throws IOException {
        try {
            this.extractRemainingOsmEntitiesNotPartOfStopArea();
        }
        catch (PlanItException e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("error while parsing remaining osm entities not part of a stop_area");
        }
        LOGGER.fine(" OSM (transfer) zone post-processing ...DONE");
    }

    @Override
    public void reset() {
        this.spatiallyIndexedOsmNodesInternalToPlanitLinks = new HashMap<MacroscopicNetworkLayer, Quadtree>();
    }
}

