/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.zoning;

import de.topobyte.osm4j.core.model.iface.EntityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.goplanit.osm.converter.zoning.OsmZoningReaderData;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitGraphGeoUtils;
import org.goplanit.utils.geo.PlanitJtsIntersectZoneVisitor;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.TransportLayer;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Links;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.quadtree.Quadtree;

public class OsmZoningReaderPlanitData {
    private static final Logger LOGGER = Logger.getLogger(OsmZoningReaderData.class.getCanonicalName());
    private final Map<EntityType, Map<Long, TransferZone>> transferZonesByOsmEntityId = new TreeMap<EntityType, Map<Long, TransferZone>>();
    private final Map<EntityType, Quadtree> transferZonesBySpatialIndex = new TreeMap<EntityType, Quadtree>();
    private final Map<TransportLayer, Map<Point, List<DirectedConnectoid>>> directedConnectoidsByOsmNodeId = new HashMap<TransportLayer, Map<Point, List<DirectedConnectoid>>>();
    private final Map<TransferZone, List<DirectedConnectoid>> connectoidsByTransferZone = new HashMap<TransferZone, List<DirectedConnectoid>>();
    private final Map<Long, TransferZoneGroup> transferZoneGroupsByOsmId = new HashMap<Long, TransferZoneGroup>();
    private Quadtree spatiallyIndexedPlanitLinks = null;

    protected void initialiseSpatiallyIndexedLinks(PlanitOsmNetwork osmNetwork) {
        ArrayList<Links> linksCollection = new ArrayList<Links>();
        for (MacroscopicNetworkLayer layer : (MacroscopicNetworkLayers)osmNetwork.getTransportLayers()) {
            linksCollection.add(layer.getLinks());
        }
        this.spatiallyIndexedPlanitLinks = PlanitGraphGeoUtils.createSpatiallyIndexedPlanitEdges(linksCollection);
    }

    public TransferZone getIncompleteTransferZoneByOsmId(EntityType entityType, long osmEntityId) {
        TransferZone transferZone = this.getTransferZoneByOsmId(entityType, osmEntityId);
        if (!this.hasConnectoids(transferZone)) {
            return transferZone;
        }
        return null;
    }

    public TransferZone getCompleteTransferZoneByOsmId(EntityType entityType, long osmEntityId) {
        TransferZone transferZone = this.getTransferZoneByOsmId(entityType, osmEntityId);
        if (this.hasConnectoids(transferZone)) {
            return transferZone;
        }
        return null;
    }

    public TransferZone getTransferZoneByOsmId(EntityType type, long osmId) {
        this.transferZonesByOsmEntityId.putIfAbsent(type, new TreeMap());
        return this.transferZonesByOsmEntityId.get((Object)type).get(osmId);
    }

    public Collection<TransferZone> getTransferZonesByOsmId(EntityType entityType) throws PlanItException {
        switch (entityType) {
            case Node: {
                this.transferZonesByOsmEntityId.putIfAbsent(entityType, new TreeMap());
                return Collections.unmodifiableCollection(this.transferZonesByOsmEntityId.get((Object)entityType).values());
            }
            case Way: {
                this.transferZonesByOsmEntityId.putIfAbsent(entityType, new TreeMap());
                return Collections.unmodifiableCollection(this.transferZonesByOsmEntityId.get((Object)entityType).values());
            }
        }
        throw new PlanItException("Unspported entity type encountered for transfer zone tracked in zoning reader, this shoudn't happen");
    }

    public Collection<TransferZone> getTransferZonesSpatially(Envelope boundingBox) {
        HashSet correctZones = new HashSet();
        PlanitJtsIntersectZoneVisitor spatialZoneFilterVisitor = new PlanitJtsIntersectZoneVisitor(PlanitJtsUtils.create2DPolygon(boundingBox), correctZones);
        for (Map.Entry<EntityType, Quadtree> entry : this.transferZonesBySpatialIndex.entrySet()) {
            this.transferZonesBySpatialIndex.get((Object)entry.getKey()).query(boundingBox, spatialZoneFilterVisitor);
        }
        return spatialZoneFilterVisitor.getResult();
    }

    public TransferZone addTransferZoneByOsmId(EntityType entityType, long osmEntityId, TransferZone transferZone) {
        this.transferZonesByOsmEntityId.putIfAbsent(entityType, new HashMap());
        this.transferZonesBySpatialIndex.putIfAbsent(entityType, new Quadtree());
        Envelope transferZoneBoundingBox = transferZone.getEnvelope();
        if (transferZoneBoundingBox == null) {
            LOGGER.warning(String.format("unable to track transfer zone %d while parsing, unknown spatial features, ignored", osmEntityId));
            return null;
        }
        this.transferZonesBySpatialIndex.get((Object)entityType).insert(transferZone.getEnvelope(), transferZone);
        return this.transferZonesByOsmEntityId.get((Object)entityType).put(osmEntityId, transferZone);
    }

    public Map<Point, List<DirectedConnectoid>> getDirectedConnectoidsByLocation(MacroscopicNetworkLayer networkLayer) {
        this.directedConnectoidsByOsmNodeId.putIfAbsent(networkLayer, new HashMap());
        return Collections.unmodifiableMap(this.directedConnectoidsByOsmNodeId.get(networkLayer));
    }

    public List<DirectedConnectoid> getDirectedConnectoidsByLocation(Point nodeLocation, MacroscopicNetworkLayer networkLayer) {
        return this.getDirectedConnectoidsByLocation(networkLayer).get(nodeLocation);
    }

    public boolean addDirectedConnectoidByLocation(MacroscopicNetworkLayer networkLayer, Point connectoidLocation, DirectedConnectoid connectoid) {
        this.directedConnectoidsByOsmNodeId.putIfAbsent(networkLayer, new HashMap());
        Map<Point, List<DirectedConnectoid>> connectoidsForLayer = this.directedConnectoidsByOsmNodeId.get(networkLayer);
        connectoidsForLayer.putIfAbsent(connectoidLocation, new ArrayList(1));
        List<DirectedConnectoid> connectoids = connectoidsForLayer.get(connectoidLocation);
        if (!connectoids.contains(connectoid)) {
            return connectoids.add(connectoid);
        }
        return false;
    }

    public boolean hasAnyDirectedConnectoidsForLocation(Point location) {
        for (Map.Entry<TransportLayer, Map<Point, List<DirectedConnectoid>>> entry : this.directedConnectoidsByOsmNodeId.entrySet()) {
            if (!this.hasDirectedConnectoidForLocation(entry.getKey(), location)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDirectedConnectoidForLocation(TransportLayer networkLayer, Point point) {
        Map<Point, List<DirectedConnectoid>> connectoidsForLayer = this.directedConnectoidsByOsmNodeId.get(networkLayer);
        return connectoidsForLayer != null && connectoidsForLayer.get(point) != null && !connectoidsForLayer.get(point).isEmpty();
    }

    public void addConnectoidByTransferZone(TransferZone transferZone, DirectedConnectoid connectoid) {
        this.connectoidsByTransferZone.putIfAbsent(transferZone, new ArrayList(1));
        List<DirectedConnectoid> connectoids = this.connectoidsByTransferZone.get(transferZone);
        if (!connectoids.contains(connectoid)) {
            connectoids.add(connectoid);
        }
    }

    public boolean hasConnectoids(TransferZone transferZone) {
        return this.getConnectoidsByTransferZone(transferZone) != null && !this.getConnectoidsByTransferZone(transferZone).isEmpty();
    }

    public Collection<DirectedConnectoid> getConnectoidsByTransferZone(TransferZone transferZone) {
        if (transferZone == null) {
            return null;
        }
        this.connectoidsByTransferZone.putIfAbsent(transferZone, new ArrayList(1));
        return this.connectoidsByTransferZone.get(transferZone);
    }

    public TransferZoneGroup getTransferZoneGroupByOsmId(long osmId) {
        return this.transferZoneGroupsByOsmId.get(osmId);
    }

    public TransferZoneGroup addTransferZoneGroupByOsmId(long osmId, TransferZoneGroup transferZoneGroup) {
        return this.transferZoneGroupsByOsmId.put(osmId, transferZoneGroup);
    }

    public void reset() {
        this.transferZonesByOsmEntityId.clear();
        this.directedConnectoidsByOsmNodeId.clear();
        this.connectoidsByTransferZone.clear();
        this.spatiallyIndexedPlanitLinks = new Quadtree();
    }

    public void removeLinksFromSpatialLinkIndex(Collection<Link> links) {
        if (links != null) {
            links.forEach(link -> this.spatiallyIndexedPlanitLinks.remove(link.createEnvelope(), link));
        }
    }

    public void addLinksToSpatialLinkIndex(Collection<Link> links) {
        if (links != null) {
            links.forEach(link -> this.spatiallyIndexedPlanitLinks.insert(link.createEnvelope(), link));
        }
    }

    public Collection<Link> findLinksSpatially(Envelope searchBoundingBox) {
        return PlanitGraphGeoUtils.findEdgesSpatially(searchBoundingBox, this.spatiallyIndexedPlanitLinks);
    }
}

