/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.osm.defaults.OsmInfrastructureConfiguration;
import org.goplanit.osm.defaults.OsmModeAccessDefaultsCategory;
import org.goplanit.osm.defaults.OsmSpeedLimitDefaultsCategory;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;

public abstract class OsmWaySettings {
    private static final Logger LOGGER = Logger.getLogger(OsmWaySettings.class.getCanonicalName());
    private OsmSpeedLimitDefaultsCategory speedLimitDefaults;
    private OsmModeAccessDefaultsCategory osmModeAccessDefaults;
    private final OsmInfrastructureConfiguration infrastructureTypeConfiguration;
    private final Map<String, Mode> osmMode2PlanitModeMap = new HashMap<String, Mode>();
    protected final Map<String, Pair<Double, Double>> overwriteOsmWayTypeCapacityDensityDefaults = new HashMap<String, Pair<Double, Double>>();
    private Boolean isParserActive = null;

    private static void addToModeExternalId(Mode planitMode, String osModeId) {
        if (planitMode != null) {
            if (planitMode.hasExternalId()) {
                planitMode.setExternalId(planitMode.getExternalId().concat(";").concat(osModeId));
            } else {
                planitMode.setExternalId(osModeId);
            }
        }
    }

    private static void removeFromModeExternalId(Mode planitMode, String osModeId) {
        if (planitMode != null && planitMode.hasExternalId()) {
            int startIndex = planitMode.getExternalId().indexOf(osModeId);
            if (startIndex == -1) {
                return;
            }
            if (startIndex == 0) {
                planitMode.setExternalId(planitMode.getExternalId().substring(startIndex + osModeId.length()));
            } else {
                String before = planitMode.getExternalId().substring(0, startIndex - 1);
                String after = planitMode.getExternalId().substring(startIndex + osModeId.length());
                planitMode.setExternalId(before.concat(after));
            }
        }
    }

    private void excludeOsmWayTypesWithoutModes(String osmWayValue, Collection<String> osmModes) {
        boolean hasMappedMode = false;
        if (osmModes != null) {
            for (String osmMode : osmModes) {
                if (!this.hasMappedPlanitMode(osmMode)) continue;
                hasMappedMode = true;
                break;
            }
        }
        if (!hasMappedMode) {
            this.deactivateOsmWayType(osmWayValue);
        }
    }

    protected OsmWaySettings(OsmInfrastructureConfiguration infrastructureTypeConfiguration, OsmSpeedLimitDefaultsCategory speedLimitDefaults, OsmModeAccessDefaultsCategory osmModeAccessDefaults) {
        this.infrastructureTypeConfiguration = infrastructureTypeConfiguration;
        this.speedLimitDefaults = speedLimitDefaults;
        this.osmModeAccessDefaults = osmModeAccessDefaults;
    }

    protected void setModeExternalIdsBasedOnMappedOsmModes() {
        this.osmMode2PlanitModeMap.forEach((osmMode, planitMode) -> OsmWaySettings.addToModeExternalId(planitMode, osmMode));
    }

    public void excludeOsmWayTypesWithoutActivatedModes() {
        if (this.isParserActive()) {
            Set<String> originallySupportedTypes = this.getSetOfActivatedOsmWayTypes();
            for (String supportedWayType : originallySupportedTypes) {
                Collection<String> allowedOsmModes = this.collectAllowedOsmWayModes(supportedWayType);
                this.excludeOsmWayTypesWithoutModes(supportedWayType, allowedOsmModes);
            }
        }
    }

    protected boolean isOsmWayTypeDeactivated(String osmWayValueType) {
        return this.infrastructureTypeConfiguration.isDeactivated(osmWayValueType);
    }

    protected boolean isOsmWayTypeActivated(String osmWayValue) {
        return this.infrastructureTypeConfiguration.isActivated(osmWayValue);
    }

    protected void deactivateOsmWayType(String osmWayValue) {
        this.infrastructureTypeConfiguration.deactivate(osmWayValue);
    }

    protected void activateOsmWayType(String osmWayValue) {
        this.infrastructureTypeConfiguration.activate(osmWayValue);
    }

    protected void activateOsmWayTypes(String ... osmWayValueTypes) {
        this.activateOsmWayTypes(Arrays.asList(osmWayValueTypes));
    }

    protected void activateOsmWayTypes(List<String> osmWayValueTypes) {
        this.infrastructureTypeConfiguration.activate(osmWayValueTypes);
    }

    protected void activateAllOsmWayTypes() {
        this.infrastructureTypeConfiguration.setOfDeactivatedTypes().forEach(unsupportedType -> this.activateOsmWayType((String)unsupportedType));
    }

    protected void deactivateAllOsmWayTypes() {
        this.infrastructureTypeConfiguration.deactivateAll();
    }

    protected void logUnsupportedOsmWayTypes() {
        this.infrastructureTypeConfiguration.logDeactivatedTypes();
    }

    protected void overwriteOsmWayTypeDefaultCapacityMaxDensity(String osmWayKey, String osmWayType, double capacityPerLanePerHour, double maxDensityPerLane) {
        if (!this.isOsmWayTypeActivated(osmWayType)) {
            this.activateOsmWayType(osmWayType);
        }
        this.overwriteOsmWayTypeCapacityDensityDefaults.put(osmWayType, Pair.of(capacityPerLanePerHour, maxDensityPerLane));
        LOGGER.info(String.format("overwriting defaults for osm road type %s:%s to capacity: %.2f (pcu/h/lane), max density %.2f (pcu/km)", osmWayKey, osmWayType, capacityPerLanePerHour, maxDensityPerLane));
    }

    protected boolean isDefaultCapacityOrMaxDensityOverwrittenByOsmWayType(String osmWayType) {
        return this.overwriteOsmWayTypeCapacityDensityDefaults.containsKey(osmWayType);
    }

    protected final Pair<Double, Double> getOverwrittenCapacityMaxDensityByOsmWayType(String osmWayType) {
        return this.overwriteOsmWayTypeCapacityDensityDefaults.get(osmWayType);
    }

    protected double getDefaultSpeedLimitByOsmWayType(String osmWayValue) throws PlanItException {
        return this.speedLimitDefaults.getSpeedLimit(osmWayValue);
    }

    protected Double getDefaultSpeedLimitByOsmWayType(String osmWayKey, Map<String, String> tags) throws PlanItException {
        if (tags.containsKey(osmWayKey)) {
            return this.getDefaultSpeedLimitByOsmWayType(tags.get(osmWayKey));
        }
        throw new PlanItException("no key %s contained in provided osmTags when collecting default speed limit by OsmRailwayType", osmWayKey);
    }

    protected void addOsmMode2PlanitModeMapping(String osmMode, Mode planitMode) {
        this.osmMode2PlanitModeMap.put(osmMode, planitMode);
    }

    protected void setOsmMode2PlanitModeMapping(String osmMode, Mode planitMode) {
        if (osmMode == null) {
            LOGGER.warning("osm mode is null, cannot add it to OSM to PLANit mode mapping for OSM mode, ignored");
            return;
        }
        if (planitMode == null) {
            LOGGER.warning(String.format("planit mode is null, cannot add it to OSM to PLANit mode mapping for OSM mode %s, ignored", osmMode));
            return;
        }
        this.osmMode2PlanitModeMap.put(osmMode, planitMode);
        OsmWaySettings.addToModeExternalId(planitMode, osmMode);
    }

    protected void removeOsmMode2PlanitModeMapping(String osmMode) {
        if (osmMode == null) {
            LOGGER.warning("osm mode is null, cannot add it to OSM to PLANit mode mapping for OSM mode, ignored");
            return;
        }
        LOGGER.fine(String.format("osm mode %s is deactivated", osmMode));
        Mode planitMode = this.osmMode2PlanitModeMap.remove(osmMode);
        OsmWaySettings.removeFromModeExternalId(planitMode, osmMode);
    }

    protected void deactivateOsmModes(Collection<String> osmModes) {
        for (String osmMode : osmModes) {
            this.removeOsmMode2PlanitModeMapping(osmMode);
        }
    }

    protected void deactivateAllModesExcept(Collection<String> toBeRemovedModes, List<String> remainingOsmRoadModes) {
        ArrayList remainingRoadModes = remainingOsmRoadModes == null ? new ArrayList() : remainingOsmRoadModes;
        TreeSet<String> finalToBeRemovedModes = new TreeSet<String>(toBeRemovedModes);
        finalToBeRemovedModes.removeAll(remainingRoadModes);
        this.deactivateOsmModes(finalToBeRemovedModes);
    }

    protected Mode getMappedPlanitMode(String osmMode) {
        return this.osmMode2PlanitModeMap.get(osmMode);
    }

    protected Collection<String> getMappedOsmModes(Mode planitMode) {
        HashSet<String> mappedOsmModes = new HashSet<String>();
        for (Map.Entry<String, Mode> entry : this.osmMode2PlanitModeMap.entrySet()) {
            if (!entry.getValue().idEquals(planitMode)) continue;
            mappedOsmModes.add(entry.getKey());
        }
        return mappedOsmModes;
    }

    protected boolean isModeAllowedOnOsmWay(String osmWayTypeValue, String osmMode) {
        return this.osmModeAccessDefaults.isAllowed(osmWayTypeValue, osmMode);
    }

    protected abstract Collection<String> collectAllowedOsmWayModes(String var1);

    protected Set<String> collectAllowedOsmWayModes(String osmWayValueType, Collection<String> osmModesToCheck) {
        return osmModesToCheck.stream().filter(osmMode -> this.isModeAllowedOnOsmWay(osmWayValueType, (String)osmMode)).collect(Collectors.toSet());
    }

    protected void addAllowedOsmWayModes(String osmWayTypeValue, List<String> osmModes) {
        this.osmModeAccessDefaults.addAllowedModes(osmWayTypeValue, osmModes);
    }

    public void activateParser(boolean activate) {
        this.isParserActive = activate;
    }

    public boolean isParserActive() {
        return this.isParserActive;
    }

    public boolean hasMappedPlanitMode(String osmMode) {
        return this.getMappedPlanitMode(osmMode) != null;
    }

    public boolean hasAnyMappedPlanitModeOtherThan(String osmMode) {
        return this.osmMode2PlanitModeMap.keySet().stream().filter(mode -> !mode.equals(osmMode)).findFirst().isPresent();
    }

    public final Set<String> getSetOfActivatedOsmWayTypes() {
        return this.infrastructureTypeConfiguration.setOfActivatedTypes();
    }
}

