/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.goplanit.network.layer.MacroscopicNetworkLayerImpl;
import org.goplanit.osm.converter.network.OsmNetworkLayerParser;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class OsmNetworkReaderData {
    protected final Map<Long, OsmNode> osmNodes;
    protected final Map<Long, OsmWay> osmCircularWays;
    private Envelope networkBoundingBox;
    private final Map<MacroscopicNetworkLayer, OsmNetworkLayerParser> osmLayerParsers = new HashMap<MacroscopicNetworkLayer, OsmNetworkLayerParser>();
    public static final double BOUNDINGBOX_NEARNESS_DISTANCE_METERS = 200.0;

    protected void initialiseLayerParsers(PlanitOsmNetwork network, OsmNetworkReaderSettings settings, PlanitJtsCrsUtils geoUtils) {
        for (MacroscopicNetworkLayer macroNetworkLayer : (MacroscopicNetworkLayers)network.getTransportLayers()) {
            OsmNetworkLayerParser layerHandler = new OsmNetworkLayerParser(macroNetworkLayer, this, settings, geoUtils);
            this.osmLayerParsers.put(macroNetworkLayer, layerHandler);
        }
    }

    public OsmNetworkReaderData() {
        this.osmNodes = new HashMap<Long, OsmNode>();
        this.osmCircularWays = new HashMap<Long, OsmWay>();
    }

    public void reset() {
        this.clearOsmCircularWays();
        this.osmNodes.clear();
        this.osmLayerParsers.forEach((layer, handler) -> handler.reset());
        this.osmLayerParsers.clear();
    }

    public void updateBoundingBox(OsmNode osmNode) {
        Coordinate coorinate = OsmNodeUtils.createCoordinate(osmNode);
        if (this.networkBoundingBox == null) {
            this.networkBoundingBox = new Envelope(coorinate);
        } else {
            this.networkBoundingBox.expandToInclude(coorinate);
        }
    }

    public Envelope getBoundingBox() {
        return this.networkBoundingBox;
    }

    public Map<Long, OsmNode> getOsmNodes() {
        return Collections.unmodifiableMap(this.osmNodes);
    }

    public void addOsmNode(OsmNode osmNode) {
        this.osmNodes.put(osmNode.getId(), osmNode);
    }

    public OsmNode getOsmNode(long osmNodeId) {
        return this.osmNodes.get(osmNodeId);
    }

    public boolean hasOsmNode(long osmNodeId) {
        return this.getOsmNode(osmNodeId) != null;
    }

    public Map<Long, OsmWay> getOsmCircularWays() {
        return Collections.unmodifiableMap(this.osmCircularWays);
    }

    public void addOsmCircularWay(OsmWay osmWay) {
        this.osmCircularWays.put(osmWay.getId(), osmWay);
    }

    public void clearOsmCircularWays() {
        this.osmCircularWays.clear();
    }

    public final OsmNetworkLayerParser getLayerParser(MacroscopicNetworkLayerImpl networkLayer) {
        return this.osmLayerParsers.get(networkLayer);
    }

    public final Map<MacroscopicNetworkLayer, OsmNetworkLayerParser> getLayerParsers() {
        return this.osmLayerParsers;
    }
}

