/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.access.DefaultOsmHandler;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import java.io.IOException;
import java.util.logging.Logger;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;

public class OsmNetworkPreProcessingHandler
extends DefaultOsmHandler {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkPreProcessingHandler.class.getCanonicalName());
    private final OsmNetworkReaderSettings settings;

    public OsmNetworkPreProcessingHandler(OsmNetworkReaderSettings settings) {
        this.settings = settings;
    }

    @Override
    public void handle(OsmWay osmWay) throws IOException {
        if (this.settings.hasBoundingPolygon() && this.settings.isKeepOsmWayOutsideBoundingPolygon(osmWay.getId())) {
            if (this.settings.isOsmWayExcluded(osmWay.getId())) {
                LOGGER.warning("OSM way %d is marked for exclusion as well as keeping it, this is conficting, OSM way exclusion takes precedence");
                return;
            }
            for (int index = 0; index < osmWay.getNumberOfNodes(); ++index) {
                this.settings.setKeepOsmNodeOutsideBoundingPolygon(osmWay.getNodeId(index));
            }
        }
    }

    @Override
    public void complete() throws IOException {
        if (this.settings.hasBoundingPolygon() && (this.settings.hasKeepOsmWaysOutsideBoundingPolygon() || this.settings.hasKeepOsmNodesOutsideBoundingPolygon())) {
            LOGGER.info(String.format("Identified %d OSM ways and %d nodes to keep even if (partially) outside bounding polygon", this.settings.getNumberOfKeepOsmWaysOutsideBoundingPolygon(), this.settings.getNumberOfKeepOsmNodesOutsideBoundingPolygon()));
            LOGGER.info("OSM preprocessing network ...DONE");
        }
    }

    public void reset() {
    }
}

