/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.model.iface.OsmNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.physical.Link;
import org.goplanit.utils.network.layer.physical.Node;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OsmNetworkHandlerHelper {
    public static final Logger LOGGER = Logger.getLogger(OsmNetworkHandlerHelper.class.getCanonicalName());
    protected static final String LINK_OSMWAY_TYPE_PROPERTY_KEY = "osmwaytype";

    public static void setLinkOsmWayType(Link link, String osmWayType) {
        link.addInputProperty(LINK_OSMWAY_TYPE_PROPERTY_KEY, osmWayType);
    }

    public static String getLinkOsmWayType(Link link) {
        Object value = link.getInputProperty(LINK_OSMWAY_TYPE_PROPERTY_KEY);
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    public static Map<Long, Set<Link>> breakLinksWithInternalNode(Node theNode, List<Link> linksToBreak, MacroscopicNetworkLayer networkLayer, CoordinateReferenceSystem crs) throws PlanItException {
        HashMap<Long, Set<Link>> newOsmWaysWithMultiplePlanitLinks = new HashMap<Long, Set<Link>>();
        if (linksToBreak != null) {
            try {
                Map<Long, Set<Link>> localBrokenLinks = networkLayer.getLayerModifier().breakAt(linksToBreak, theNode, crs);
                if (localBrokenLinks != null) {
                    localBrokenLinks.forEach((id, links) -> links.forEach(brokenLink -> {
                        Long brokenLinkOsmId = Long.parseLong(brokenLink.getExternalId());
                        newOsmWaysWithMultiplePlanitLinks.putIfAbsent(brokenLinkOsmId, new HashSet());
                        ((Set)newOsmWaysWithMultiplePlanitLinks.get(brokenLinkOsmId)).add(brokenLink);
                    }));
                }
            }
            catch (PlanItException e) {
                LOGGER.severe(e.getMessage());
                LOGGER.severe(String.format("unable to break links %s for node %s, something unexpected went wrong", linksToBreak.stream().map(link -> link.getExternalId()).collect(Collectors.toSet()).toString(), theNode.getExternalId()));
            }
        }
        return newOsmWaysWithMultiplePlanitLinks;
    }

    public static Node createAndPopulateNode(OsmNode osmNode, MacroscopicNetworkLayer networkLayer) {
        if (osmNode == null || networkLayer == null) {
            LOGGER.severe("no OSM node or network layer provided when creating new PLANit node, ignore");
            return null;
        }
        Point geometry = OsmNodeUtils.createPoint(osmNode);
        Node node = OsmNetworkHandlerHelper.createAndPopulateNode(geometry, networkLayer);
        node.setExternalId(String.valueOf(osmNode.getId()));
        return node;
    }

    public static Node createAndPopulateNode(Point geometry, MacroscopicNetworkLayer networkLayer) {
        Node node = networkLayer.getNodes().getFactory().registerNew();
        node.setXmlId(Long.toString(node.getId()));
        node.setPosition(geometry);
        return node;
    }

    public static Node createPopulateAndRegisterNode(OsmNode osmNode, MacroscopicNetworkLayer networkLayer, OsmNetworkReaderLayerData layerData) throws PlanItException {
        Node node = OsmNetworkHandlerHelper.createAndPopulateNode(osmNode, networkLayer);
        if (node != null) {
            layerData.registerPlanitNodeByOsmNode(osmNode, node);
            layerData.getProfiler().logNodeStatus(networkLayer.getNumberOfNodes());
        }
        return node;
    }

    public static Node createPopulateAndRegisterNode(Point osmNodeLocation, MacroscopicNetworkLayer networkLayer, OsmNetworkReaderLayerData layerData) throws PlanItException {
        Node node = OsmNetworkHandlerHelper.createAndPopulateNode(osmNodeLocation, networkLayer);
        if (node != null) {
            layerData.registerPlanitNodeByLocation(osmNodeLocation, node);
            layerData.getProfiler().logNodeStatus(networkLayer.getNumberOfNodes());
        }
        return node;
    }

    public static void addAllTo(Map<Long, Set<Link>> addition, Map<Long, Set<Link>> destination) {
        addition.forEach((osmWayId, links) -> {
            destination.putIfAbsent((Long)osmWayId, new HashSet());
            ((Set)destination.get(osmWayId)).addAll(links);
        });
    }
}

