/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.network;

import de.topobyte.osm4j.core.access.DefaultOsmHandler;
import de.topobyte.osm4j.core.model.iface.OsmNode;
import de.topobyte.osm4j.core.model.iface.OsmWay;
import de.topobyte.osm4j.core.model.util.OsmModelUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.goplanit.network.layer.MacroscopicNetworkLayerImpl;
import org.goplanit.osm.converter.network.OsmNetworkLayerParser;
import org.goplanit.osm.converter.network.OsmNetworkReaderData;
import org.goplanit.osm.converter.network.OsmNetworkReaderLayerData;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.tags.OsmHighwayTags;
import org.goplanit.osm.tags.OsmRailwayTags;
import org.goplanit.osm.tags.OsmTags;
import org.goplanit.osm.util.OsmNodeUtils;
import org.goplanit.osm.util.OsmWayUtils;
import org.goplanit.osm.util.PlanitNetworkLayerUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.TransportLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.Link;

public class OsmNetworkHandler
extends DefaultOsmHandler {
    private static final Logger LOGGER = Logger.getLogger(OsmNetworkHandler.class.getCanonicalName());
    private final OsmNetworkReaderData networkData;
    private final OsmNetworkReaderSettings settings;

    private boolean hasNetworkLayersWithActiveOsmNode(long osmNodeId) throws PlanItException {
        return PlanitNetworkLayerUtils.hasNetworkLayersWithActiveOsmNode(osmNodeId, this.settings.getOsmNetworkToPopulate(), this.networkData);
    }

    private boolean isActivatedRoadOrRailwayBasedInfrastructure(Map<String, String> tags) {
        if (!OsmTags.isArea(tags)) {
            if (this.settings.isHighwayParserActive() && OsmHighwayTags.hasHighwayKeyTag(tags)) {
                return this.settings.getHighwaySettings().isOsmHighwayTypeActivated(tags.get("highway"));
            }
            if (this.settings.isRailwayParserActive() && OsmRailwayTags.hasRailwayKeyTag(tags)) {
                return this.settings.getRailwaySettings().isOsmRailwayTypeActivated(tags.get("railway"));
            }
        }
        return false;
    }

    private void handleRawCircularWay(OsmWay circularOsmWay) throws PlanItException {
        Map<TransportLayer, Set<Link>> createdLinksByLayer = null;
        Map<String, String> tags = OsmModelUtil.getTagsAsMap(circularOsmWay);
        if (this.isActivatedRoadOrRailwayBasedInfrastructure(tags)) {
            if (!OsmWayUtils.isAllOsmWayNodesAvailable(circularOsmWay, this.networkData.getOsmNodes())) {
                return;
            }
            createdLinksByLayer = this.handleRawCircularWay(circularOsmWay, tags, 0);
            if (createdLinksByLayer != null) {
                for (Map.Entry<TransportLayer, Set<Link>> entry : createdLinksByLayer.entrySet()) {
                    OsmNetworkReaderLayerData layerData = this.networkData.getLayerParsers().get(entry.getKey()).getLayerData();
                    layerData.updateOsmWaysWithMultiplePlanitLinks(circularOsmWay.getId(), entry.getValue());
                }
            }
        }
    }

    private Map<TransportLayer, Set<Link>> handleRawCircularWay(OsmWay circularOsmWay, Map<String, String> osmWayTags, int initialNodeIndex) throws PlanItException {
        Map<TransportLayer, Link> newLinksByLayer;
        HashMap<TransportLayer, Set<Link>> createdLinksByLayer = new HashMap<TransportLayer, Set<Link>>();
        int finalNodeIndex = circularOsmWay.getNumberOfNodes() - 1;
        Pair<Integer, Integer> firstCircularIndices = OsmWayUtils.findIndicesOfFirstLoop(circularOsmWay, initialNodeIndex);
        if (firstCircularIndices != null) {
            Map<TransportLayer, Set<Link>> newLinksByLayer2;
            if (firstCircularIndices.first() > initialNodeIndex) {
                Map<TransportLayer, Link> newLinkByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, initialNodeIndex, firstCircularIndices.first(), false);
                if (newLinkByLayer != null) {
                    newLinkByLayer.forEach((layer, link) -> {
                        createdLinksByLayer.putIfAbsent((TransportLayer)layer, new HashSet());
                        ((Set)createdLinksByLayer.get(layer)).add(link);
                    });
                }
                initialNodeIndex = firstCircularIndices.first();
            }
            if (firstCircularIndices.second() < finalNodeIndex && (newLinksByLayer2 = this.handleRawCircularWay(circularOsmWay, osmWayTags, firstCircularIndices.second())) != null) {
                newLinksByLayer2.forEach((layer, links) -> {
                    createdLinksByLayer.putIfAbsent((TransportLayer)layer, new HashSet());
                    ((Set)createdLinksByLayer.get(layer)).addAll(links);
                });
            }
            if ((newLinksByLayer2 = this.handlePerfectCircularWay(circularOsmWay, osmWayTags, firstCircularIndices.first(), firstCircularIndices.second())) != null) {
                newLinksByLayer2.forEach((layer, link) -> {
                    createdLinksByLayer.putIfAbsent((TransportLayer)layer, new HashSet());
                    ((Set)createdLinksByLayer.get(layer)).addAll(link);
                });
            }
        } else if (initialNodeIndex < finalNodeIndex && (newLinksByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, initialNodeIndex, finalNodeIndex, false)) != null) {
            newLinksByLayer.forEach((layer, link) -> {
                createdLinksByLayer.putIfAbsent((TransportLayer)layer, new HashSet());
                ((Set)createdLinksByLayer.get(layer)).add(link);
            });
        }
        return createdLinksByLayer;
    }

    private Map<TransportLayer, Set<Link>> handlePerfectCircularWay(OsmWay circularOsmWay, Map<String, String> osmWayTags, int initialNodeIndex, int finalNodeIndex) throws PlanItException {
        Map<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>> linkSegmentTypesByLayer;
        HashMap<TransportLayer, Set<Link>> createdLinksByLayer = new HashMap<TransportLayer, Set<Link>>();
        int firstPartialLinkStartNodeIndex = -1;
        int partialLinkStartNodeIndex = -1;
        int partialLinkEndNodeIndex = -1;
        int numberOfConsideredNodes = finalNodeIndex - initialNodeIndex;
        boolean partialLinksPartOfCircularWay = true;
        for (int index = initialNodeIndex; index <= finalNodeIndex; ++index) {
            Map<TransportLayer, Link> createdLinkByLayer;
            long osmNodeId = circularOsmWay.getNodeId(index);
            if (!this.hasNetworkLayersWithActiveOsmNode(osmNodeId)) continue;
            if (partialLinkStartNodeIndex < 0) {
                firstPartialLinkStartNodeIndex = partialLinkStartNodeIndex = index;
                continue;
            }
            if (index == finalNodeIndex && partialLinkStartNodeIndex == firstPartialLinkStartNodeIndex || (createdLinkByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, partialLinkStartNodeIndex, index, partialLinksPartOfCircularWay)) == null) continue;
            createdLinkByLayer.forEach((layer, link) -> {
                createdLinksByLayer.putIfAbsent((TransportLayer)layer, new HashSet());
                ((Set)createdLinksByLayer.get(layer)).add(link);
            });
            partialLinkStartNodeIndex = partialLinkEndNodeIndex = index;
        }
        if (partialLinkStartNodeIndex < 0 && (linkSegmentTypesByLayer = this.extractLinkSegmentTypes(circularOsmWay, osmWayTags)) != null && !linkSegmentTypesByLayer.isEmpty() && linkSegmentTypesByLayer.values().stream().findAny().get().anyIsNotNull()) {
            LOGGER.fine(String.format("circular way %d appears to have no connections to activated OSM way types ", circularOsmWay.getId()));
            partialLinkStartNodeIndex = 0;
        }
        Map<TransportLayer, Link> createdLinkByLayer = null;
        if (partialLinkStartNodeIndex >= 0) {
            if (partialLinkEndNodeIndex < 0) {
                if (partialLinkStartNodeIndex == initialNodeIndex) {
                    partialLinkEndNodeIndex = partialLinkStartNodeIndex + numberOfConsideredNodes / 2;
                } else {
                    partialLinkEndNodeIndex = partialLinkStartNodeIndex;
                    partialLinkStartNodeIndex = initialNodeIndex;
                }
                createdLinkByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, partialLinkStartNodeIndex, partialLinkEndNodeIndex, partialLinksPartOfCircularWay);
                if (createdLinkByLayer != null) {
                    createdLinkByLayer.forEach((layer, link) -> {
                        createdLinksByLayer.putIfAbsent((TransportLayer)layer, new HashSet());
                        ((Set)createdLinksByLayer.get(layer)).add(link);
                    });
                }
                partialLinkStartNodeIndex = partialLinkEndNodeIndex;
                partialLinkEndNodeIndex = finalNodeIndex;
                createdLinkByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, partialLinkStartNodeIndex, partialLinkEndNodeIndex, partialLinksPartOfCircularWay);
            } else if (partialLinkEndNodeIndex != finalNodeIndex) {
                partialLinkEndNodeIndex = firstPartialLinkStartNodeIndex;
                createdLinkByLayer = this.extractPartialOsmWay(circularOsmWay, osmWayTags, partialLinkStartNodeIndex, partialLinkEndNodeIndex, partialLinksPartOfCircularWay);
            }
            if (createdLinkByLayer != null) {
                createdLinkByLayer.forEach((layer, link) -> ((Set)createdLinksByLayer.get(layer)).add(link));
            }
        }
        return createdLinksByLayer;
    }

    protected Map<TransportLayer, MacroscopicLinkSegmentType> getDefaultLinkSegmentTypeByOsmWayType(OsmWay osmWay, Map<String, String> tags) {
        String osmTypeKeyToUse = null;
        boolean isExplicitArea = OsmTags.isArea(tags);
        boolean isHighway = true;
        if (isExplicitArea) {
            return null;
        }
        if (OsmHighwayTags.hasHighwayKeyTag(tags) && this.settings.isHighwayParserActive()) {
            osmTypeKeyToUse = "highway";
        } else if (OsmRailwayTags.hasRailwayKeyTag(tags) && this.settings.isRailwayParserActive()) {
            osmTypeKeyToUse = "railway";
            isHighway = false;
        }
        if (osmTypeKeyToUse == null) {
            return null;
        }
        String osmTypeValueToUse = tags.get(osmTypeKeyToUse);
        Map<TransportLayer, MacroscopicLinkSegmentType> linkSegmentTypes = this.settings.getOsmNetworkToPopulate().getDefaultLinkSegmentTypeByOsmTag(osmTypeValueToUse);
        if (linkSegmentTypes != null) {
            linkSegmentTypes.forEach((layer, linkSegmentType) -> {
                if (linkSegmentType != null) {
                    this.networkData.getLayerParser((MacroscopicNetworkLayerImpl)layer).getLayerData().getProfiler().incrementOsmTagCounter(osmTypeValueToUse);
                }
            });
        } else {
            boolean isWayTypeDeactived;
            boolean bl = isHighway ? this.settings.getHighwaySettings().isOsmHighWayTypeDeactivated(osmTypeValueToUse) : (isWayTypeDeactived = !this.settings.isRailwayParserActive() || this.settings.getRailwaySettings().isOsmRailwayTypeDeactivated(osmTypeValueToUse));
            if (!isWayTypeDeactived) {
                boolean typeConfigurationMissing;
                boolean bl2 = typeConfigurationMissing = isHighway ? OsmHighwayTags.isNonRoadBasedHighwayValueTag(osmTypeValueToUse) : OsmRailwayTags.isNonRailBasedRailway(osmTypeValueToUse);
                if (typeConfigurationMissing) {
                    LOGGER.warning(String.format("no link segment type available for OSM way: %s:%s (id:%d) --> ignored. Consider explicitly supporting or unsupporting this type", osmTypeKeyToUse, osmTypeValueToUse, osmWay.getId()));
                }
            }
        }
        return linkSegmentTypes;
    }

    protected void processCircularWays() {
        LOGGER.info("Converting OSM circular ways into multiple link topologies...");
        for (Map.Entry<Long, OsmWay> entry : this.networkData.getOsmCircularWays().entrySet()) {
            try {
                this.handleRawCircularWay(entry.getValue());
            }
            catch (PlanItException e) {
                LOGGER.severe(e.getMessage());
                LOGGER.severe(String.format("unable to process circular way OSM id: %d", entry.getKey()));
            }
        }
        LOGGER.info(String.format("Processed %d circular ways...DONE", this.networkData.getOsmCircularWays().size()));
        this.networkData.clearOsmCircularWays();
    }

    protected void extractOsmWay(OsmWay osmWay, Map<String, String> tags) throws PlanItException {
        this.extractPartialOsmWay(osmWay, tags, 0, osmWay.getNumberOfNodes() - 1, false);
    }

    protected Map<TransportLayer, Link> extractPartialOsmWay(OsmWay osmWay, Map<String, String> tags, int startNodeIndex, int endNodeIndex, boolean isPartOfCircularWay) throws PlanItException {
        HashMap<MacroscopicNetworkLayerImpl, Link> linksByLayer = null;
        Map<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>> linkSegmentTypesByLayer = this.extractLinkSegmentTypes(osmWay, tags);
        for (Map.Entry<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>> entry : linkSegmentTypesByLayer.entrySet()) {
            MacroscopicNetworkLayerImpl networkLayer = entry.getKey();
            Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> linkSegmentTypes = entry.getValue();
            if (linkSegmentTypes == null || !linkSegmentTypes.anyIsNotNull()) continue;
            OsmNetworkLayerParser layerHandler = this.networkData.getLayerParser(networkLayer);
            if (layerHandler == null) {
                throw new PlanItException("Layer handler not available, should have been instantiated in PlanitOsmHandler constructor");
            }
            Link link = layerHandler.extractPartialOsmWay(osmWay, tags, startNodeIndex, endNodeIndex, isPartOfCircularWay, linkSegmentTypes);
            if (link == null) continue;
            if (linksByLayer == null) {
                linksByLayer = new HashMap<MacroscopicNetworkLayerImpl, Link>();
            }
            linksByLayer.put(networkLayer, link);
        }
        return linksByLayer;
    }

    public OsmNetworkHandler(OsmNetworkReaderData networkData, OsmNetworkReaderSettings settings) {
        this.networkData = networkData;
        this.settings = settings;
    }

    @Override
    public void handle(OsmNode osmNode) throws IOException {
        boolean keepOutsideBoundingPolygon = this.settings.isKeepOsmNodeOutsideBoundingPolygon(osmNode.getId());
        if (!this.settings.hasBoundingPolygon() || keepOutsideBoundingPolygon || OsmNodeUtils.createPoint(osmNode).within(this.settings.getBoundingPolygon())) {
            this.networkData.addOsmNode(osmNode);
            if (!keepOutsideBoundingPolygon) {
                this.networkData.updateBoundingBox(osmNode);
            }
        }
    }

    @Override
    public void handle(OsmWay osmWay) throws IOException {
        if (!this.settings.isOsmWayExcluded(osmWay.getId())) {
            Map<String, String> tags = OsmModelUtil.getTagsAsMap(osmWay);
            try {
                if (this.isActivatedRoadOrRailwayBasedInfrastructure(tags)) {
                    if (OsmWayUtils.isCircularOsmWay(osmWay, tags, false)) {
                        this.networkData.addOsmCircularWay(osmWay);
                    } else {
                        this.extractOsmWay(osmWay, tags);
                    }
                }
            }
            catch (PlanItException e) {
                LOGGER.severe(e.getMessage());
                LOGGER.severe(String.format("Error during parsing of OSM way (id:%d)", osmWay.getId()));
            }
        }
    }

    protected Map<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>> extractLinkSegmentTypes(OsmWay osmWay, Map<String, String> tags) throws PlanItException {
        HashMap<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>> linkSegmentTypesByLayerByDirection = new HashMap<MacroscopicNetworkLayerImpl, Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType>>();
        Map<TransportLayer, MacroscopicLinkSegmentType> linkSegmentTypesByLayer = this.getDefaultLinkSegmentTypeByOsmWayType(osmWay, tags);
        if (linkSegmentTypesByLayer != null) {
            for (Map.Entry<TransportLayer, MacroscopicLinkSegmentType> entry : linkSegmentTypesByLayer.entrySet()) {
                MacroscopicNetworkLayerImpl networkLayer = (MacroscopicNetworkLayerImpl)entry.getKey();
                MacroscopicLinkSegmentType linkSegmentType = entry.getValue();
                Pair<MacroscopicLinkSegmentType, MacroscopicLinkSegmentType> typesPerdirectionPair = this.networkData.getLayerParser(networkLayer).updatedLinkSegmentTypeBasedOnOsmWay(osmWay, tags, linkSegmentType);
                if (typesPerdirectionPair == null) continue;
                linkSegmentTypesByLayerByDirection.put(networkLayer, typesPerdirectionPair);
            }
        }
        return linkSegmentTypesByLayerByDirection;
    }

    @Override
    public void complete() throws IOException {
        this.processCircularWays();
        for (Map.Entry<MacroscopicNetworkLayer, OsmNetworkLayerParser> entry : this.networkData.getLayerParsers().entrySet()) {
            OsmNetworkLayerParser networkLayerHandler = entry.getValue();
            networkLayerHandler.complete();
        }
        LOGGER.info(" OSM basic network parsing...DONE");
    }

    public void reset() {
        this.networkData.reset();
    }
}

