/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.intermodal;

import java.net.URL;
import org.goplanit.converter.ConverterReaderSettings;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.converter.zoning.OsmPublicTransportReaderSettings;
import org.goplanit.osm.physical.network.macroscopic.PlanitOsmNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.misc.UrlUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Polygon;

public class OsmIntermodalReaderSettings
implements ConverterReaderSettings {
    protected final OsmNetworkReaderSettings networkSettings;
    protected final OsmPublicTransportReaderSettings zoningPtSettings;

    public OsmIntermodalReaderSettings(String countryName) {
        this(countryName, new PlanitOsmNetwork());
    }

    public OsmIntermodalReaderSettings(String countryName, PlanitOsmNetwork networkToPopulate) {
        this(null, countryName, networkToPopulate);
    }

    public OsmIntermodalReaderSettings(URL inputSource, String countryName, PlanitOsmNetwork networkToPopulate) {
        this(new OsmNetworkReaderSettings(inputSource, countryName, networkToPopulate), new OsmPublicTransportReaderSettings(inputSource, countryName, networkToPopulate));
    }

    public OsmIntermodalReaderSettings(OsmNetworkReaderSettings networkSettings, OsmPublicTransportReaderSettings zoningPtSettings) {
        this.networkSettings = networkSettings;
        this.zoningPtSettings = zoningPtSettings;
    }

    @Override
    public void reset() {
        this.networkSettings.reset();
        this.zoningPtSettings.reset();
    }

    public OsmNetworkReaderSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public OsmPublicTransportReaderSettings getPublicTransportSettings() {
        return this.zoningPtSettings;
    }

    public void setInputSource(URL inputSource) {
        this.getNetworkSettings().setInputSource(inputSource);
        this.getPublicTransportSettings().setInputSource(inputSource);
    }

    public void setInputFile(String inputFile) throws PlanItException {
        try {
            this.setInputSource(UrlUtils.createFromPath(inputFile));
        }
        catch (Exception e) {
            throw new PlanItException("Unable to extract URL from input file location %s", inputFile);
        }
    }

    public final void setBoundingBox(Number x1, Number x2, Number y1, Number y2) throws PlanItException {
        this.setBoundingBox(new Envelope(PlanitJtsUtils.createPoint(x1, y1).getCoordinate(), PlanitJtsUtils.createPoint(x2, y2).getCoordinate()));
    }

    public final void setBoundingBox(Envelope boundingBox) {
        this.setBoundingPolygon(PlanitJtsUtils.create2DPolygon(boundingBox));
    }

    public final void setBoundingPolygon(Polygon boundingPolygon) {
        this.getNetworkSettings().setBoundingPolygon(boundingPolygon);
        this.getPublicTransportSettings().setBoundingPolygon(boundingPolygon);
    }
}

