/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.goplanit.osm.converter.helper.OsmLaneTaggingSchemeHelper;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.osm.util.OsmTagUtils;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;

public class OsmLanesModeTaggingSchemeHelper
extends OsmLaneTaggingSchemeHelper {
    protected Map<String, String> lanesModeKeyTags = new HashMap<String, String>();
    protected final Map<String, String> lanesModeForwardKeyTags = new HashMap<String, String>();
    protected final Map<String, String> lanesModeBackwardKeyTags = new HashMap<String, String>();

    private void initialise() {
        if (this.hasEligibleModes()) {
            this.eligibleOsmModes.forEach(osmMode -> this.lanesModeKeyTags.put((String)osmMode, OsmTagUtils.createCompositeOsmKey("lanes", osmMode)));
            this.lanesModeKeyTags.forEach((osmMode, lanesModeTag) -> this.lanesModeForwardKeyTags.put((String)osmMode, OsmTagUtils.createCompositeOsmKey(lanesModeTag, "forward")));
            this.lanesModeKeyTags.forEach((osmMode, lanesModeTag) -> this.lanesModeBackwardKeyTags.put((String)osmMode, OsmTagUtils.createCompositeOsmKey(lanesModeTag, "backward")));
        }
    }

    public static boolean requireLanesModeSchemeHelper(OsmNetworkReaderSettings settings, MacroscopicNetworkLayer networkLayer) {
        return OsmLaneTaggingSchemeHelper.requireTaggingSchemeHelper(settings, networkLayer);
    }

    public static Set<String> getEligibleLanesModeSchemeHelperModes(OsmNetworkReaderSettings settings, MacroscopicNetworkLayer networkLayer) {
        return OsmLaneTaggingSchemeHelper.getEligibleTaggingSchemeHelperModes(settings, networkLayer);
    }

    public OsmLanesModeTaggingSchemeHelper(Set<String> theEligibleOsmModes) {
        super(theEligibleOsmModes);
        this.initialise();
    }

    public Set<String> getModesWithLanesWithoutDirection(Map<String, String> tags) {
        return this.getMappedModesForAvailableKeys(tags, this.lanesModeKeyTags);
    }

    public Set<String> getModesWithLanesInDirection(Map<String, String> tags, boolean isForwardDirection) {
        Map<String, String> directionalKeyTags = isForwardDirection ? this.lanesModeForwardKeyTags : this.lanesModeBackwardKeyTags;
        return this.getMappedModesForAvailableKeys(tags, directionalKeyTags);
    }
}

