/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.osm.converter.helper;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.goplanit.osm.converter.network.OsmNetworkReaderSettings;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;

public class OsmLaneTaggingSchemeHelper {
    protected static final Set<String> publicServiceVehicleModes = new HashSet<String>();
    protected final Set<String> eligibleOsmModes;
    protected final Set<String> eligiblePublicServiceVehicleModes;

    protected static boolean requireTaggingSchemeHelper(OsmNetworkReaderSettings settings, MacroscopicNetworkLayer networkLayer) {
        if (settings.hasAnyMappedPlanitMode("bus", "bicycle", "hgv")) {
            List<String> modesRequiringTaggingScheme = Arrays.asList("bus", "bicycle", "hgv");
            for (String osmMode : modesRequiringTaggingScheme) {
                Mode planitMode = settings.getMappedPlanitMode(osmMode);
                if (planitMode == null || !networkLayer.supports(planitMode)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set<String> getEligibleTaggingSchemeHelperModes(OsmNetworkReaderSettings settings, MacroscopicNetworkLayer networkLayer) {
        HashSet<String> eligibleModes = new HashSet<String>();
        if (settings.hasAnyMappedPlanitMode("bus") && networkLayer.supports(settings.getMappedPlanitMode("bus"))) {
            eligibleModes.add("bus");
            eligibleModes.add("psv");
        } else if (settings.hasAnyMappedPlanitMode("bicycle") && networkLayer.supports(settings.getMappedPlanitMode("bicycle"))) {
            eligibleModes.add("bicycle");
        } else if (settings.hasAnyMappedPlanitMode("hgv") && networkLayer.supports(settings.getMappedPlanitMode("hgv"))) {
            eligibleModes.add("hgv");
        }
        return eligibleModes;
    }

    protected Set<String> getMappedModesForAvailableKeys(Map<String, String> tags, Map<String, String> osmModeKeyMap) {
        HashSet<String> eligibleModes = new HashSet<String>();
        for (Map.Entry<String, String> entry : osmModeKeyMap.entrySet()) {
            if (!tags.containsKey(entry.getValue())) continue;
            if (!this.eligiblePublicServiceVehicleModes.isEmpty() && entry.getKey().equals("psv")) {
                eligibleModes.addAll(this.eligiblePublicServiceVehicleModes);
                continue;
            }
            eligibleModes.add(entry.getKey());
        }
        return eligibleModes;
    }

    public OsmLaneTaggingSchemeHelper(Set<String> theEligibleOsmModes) {
        this.eligibleOsmModes = new HashSet<String>(theEligibleOsmModes);
        this.eligiblePublicServiceVehicleModes = new HashSet<String>(publicServiceVehicleModes);
        this.eligiblePublicServiceVehicleModes.retainAll(this.eligibleOsmModes);
    }

    public boolean hasEligibleModes() {
        return !this.eligibleOsmModes.isEmpty();
    }

    static {
        publicServiceVehicleModes.add("bus");
    }
}

