/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.goplanit.graph.GraphEntityFactoryImpl;
import org.goplanit.network.virtual.ConnectoidEdgeImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.GraphEntities;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.virtual.ConnectoidEdge;
import org.goplanit.utils.network.virtual.ConnectoidEdgeFactory;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.UndirectedConnectoid;
import org.goplanit.utils.zoning.Zone;

public class ConnectoidEdgeFactoryImpl
extends GraphEntityFactoryImpl<ConnectoidEdge>
implements ConnectoidEdgeFactory {
    protected ConnectoidEdgeFactoryImpl(IdGroupingToken groupId, GraphEntities<ConnectoidEdge> connectoidEdges) {
        super(groupId, connectoidEdges);
    }

    @Override
    public Collection<ConnectoidEdge> registerNew(Connectoid connectoid) throws PlanItException {
        ArrayList<ConnectoidEdge> connectoidEdges = new ArrayList<ConnectoidEdge>();
        for (Zone accessZone : connectoid) {
            DirectedVertex accessVertex = null;
            if (connectoid instanceof UndirectedConnectoid) {
                accessVertex = ((UndirectedConnectoid)UndirectedConnectoid.class.cast(connectoid)).getAccessVertex();
            } else if (connectoid instanceof DirectedConnectoid) {
                LinkSegment accessEdgeSegment = ((DirectedConnectoid)DirectedConnectoid.class.cast(connectoid)).getAccessLinkSegment();
                accessVertex = (Node)(accessEdgeSegment != null ? accessEdgeSegment.getDownstreamVertex() : null);
            } else {
                throw new PlanItException(String.format("connectoid %s is of unrecognised type and access node could not be retrieved", connectoid.getXmlId()));
            }
            Optional<Double> connectoidLength = connectoid.getLengthKm(accessZone);
            connectoidLength.orElseThrow(() -> new PlanItException("unable to retrieve lenght for connectoid %s (id:%d)", connectoid.getXmlId(), connectoid.getId()));
            ConnectoidEdgeImpl newConnectoidEdge = new ConnectoidEdgeImpl(this.getIdGroupingToken(), accessZone.getCentroid(), accessVertex, (double)connectoidLength.get());
            this.getGraphEntities().register(newConnectoidEdge);
            connectoidEdges.add(newConnectoidEdge);
        }
        return connectoidEdges;
    }
}

