/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.transport;

import java.util.Collection;
import java.util.logging.Logger;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.network.layer.MacroscopicNetworkLayerImpl;
import org.goplanit.network.virtual.VirtualNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.virtual.ConnectoidEdge;
import org.goplanit.utils.network.virtual.ConnectoidEdgeFactory;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.network.virtual.ConnectoidSegmentFactory;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.UndirectedConnectoid;
import org.goplanit.zoning.Zoning;

public class TransportModelNetwork {
    private static final Logger LOGGER = Logger.getLogger(TransportModelNetwork.class.getCanonicalName());
    protected final TransportLayerNetwork<?, ?> infrastructureNetwork;
    protected final Zoning zoning;

    private void logInfo() {
        LOGGER.info(String.format("#od connectoid edges: %d", this.getVirtualNetwork().getConnectoidEdges().size()));
        LOGGER.info(String.format("#od connectoid segments: %d", this.getVirtualNetwork().getConnectoidSegments().size()));
    }

    protected void connectVerticesToEdgeSegment(EdgeSegment edgeSegment) throws PlanItException {
        edgeSegment.getUpstreamVertex().addEdgeSegment(edgeSegment);
        edgeSegment.getDownstreamVertex().addEdgeSegment(edgeSegment);
    }

    protected void disconnectVerticesFromEdgeSegment(EdgeSegment edgeSegment) throws PlanItException {
        edgeSegment.getUpstreamVertex().removeEdgeSegment(edgeSegment);
        edgeSegment.getDownstreamVertex().removeEdgeSegment(edgeSegment);
    }

    protected void connectVerticesToEdge(Edge edge) throws PlanItException {
        edge.getVertexA().addEdge(edge);
        edge.getVertexB().addEdge(edge);
    }

    protected void disconnectVerticesFromEdge(Edge edge) throws PlanItException {
        edge.getVertexA().removeEdge(edge);
        edge.getVertexB().removeEdge(edge);
    }

    protected void createAndRegisterConectoidEdgeSegments(VirtualNetwork virtualNetwork, Collection<ConnectoidEdge> connectoidEdges) throws PlanItException {
        ConnectoidSegmentFactory connectoidSegmentFactory = virtualNetwork.getConnectoidSegments().getFactory();
        for (ConnectoidEdge connectoidEdge : connectoidEdges) {
            connectoidSegmentFactory.registerNew(connectoidEdge, true);
            connectoidSegmentFactory.registerNew(connectoidEdge, false);
            this.connectVerticesToEdge(connectoidEdge);
        }
    }

    public TransportModelNetwork(TransportLayerNetwork<?, ?> infrastructureNetwork, Zoning zoning) {
        this.infrastructureNetwork = infrastructureNetwork;
        this.zoning = zoning;
    }

    public void integrateTransportNetworkViaConnectoids() throws PlanItException {
        Collection<ConnectoidEdge> connectoidEdges;
        LOGGER.info(String.format("Integrating physical network %d (xml id %s) with zoning %d (XML id %s)", this.infrastructureNetwork.getId(), this.infrastructureNetwork.getXmlId() != null ? this.infrastructureNetwork.getXmlId() : "N/A", this.zoning.getId(), this.zoning.getXmlId() != null ? this.zoning.getXmlId() : "N/A"));
        VirtualNetwork virtualNetwork = this.zoning.getVirtualNetwork();
        ConnectoidEdgeFactory connectoidEdgeFactory = virtualNetwork.getConnectoidEdges().getFactory();
        for (UndirectedConnectoid undirectedConnectoid : this.zoning.odConnectoids) {
            connectoidEdges = connectoidEdgeFactory.registerNew(undirectedConnectoid);
            this.createAndRegisterConectoidEdgeSegments(virtualNetwork, connectoidEdges);
        }
        for (DirectedConnectoid directedConnectoid : this.zoning.transferConnectoids) {
            connectoidEdges = connectoidEdgeFactory.registerNew(directedConnectoid);
            this.createAndRegisterConectoidEdgeSegments(virtualNetwork, connectoidEdges);
        }
        for (ConnectoidSegment connectoidSegment : virtualNetwork.getConnectoidSegments()) {
            this.connectVerticesToEdgeSegment(connectoidSegment);
        }
        this.logInfo();
    }

    public int getNumberOfEdgeSegmentsAllLayers() {
        return this.getNumberOfPhysicalLinkSegmentsAllLayers() + this.getNumberOfConnectoidSegments();
    }

    public int getNumberOfPhysicalLinkSegmentsAllLayers() {
        int totalPhysicalLinkSegments = 0;
        Collection networkLayers = this.getInfrastructureNetwork().getTransportLayers().getLayersOfType();
        for (MacroscopicNetworkLayerImpl layer : networkLayers) {
            totalPhysicalLinkSegments = (int)((long)totalPhysicalLinkSegments + layer.getNumberOfLinkSegments());
        }
        return totalPhysicalLinkSegments;
    }

    public int getNumberOfConnectoidSegments() {
        return this.zoning.getVirtualNetwork().getConnectoidSegments().size();
    }

    public int getNumberOfVerticesAllLayers() {
        return this.zoning.odZones.getNumberOfCentroids() + this.zoning.transferZones.getNumberOfCentroids() + this.getNumberOfPhysicalNodesAllLayers();
    }

    public int getNumberOfPhysicalNodesAllLayers() {
        int totalPhysicalNodes = 0;
        Collection networkLayers = this.getInfrastructureNetwork().getTransportLayers().getLayersOfType();
        for (UntypedPhysicalLayer layer : networkLayers) {
            totalPhysicalNodes = (int)((long)totalPhysicalNodes + layer.getNumberOfNodes());
        }
        return totalPhysicalNodes;
    }

    public void removeVirtualNetworkFromPhysicalNetwork() throws PlanItException {
        for (ConnectoidEdge connectoidEdge : this.zoning.getVirtualNetwork().getConnectoidEdges()) {
            this.disconnectVerticesFromEdge(connectoidEdge);
        }
        for (ConnectoidSegment connectoidSegment : this.zoning.getVirtualNetwork().getConnectoidSegments()) {
            this.disconnectVerticesFromEdgeSegment(connectoidSegment);
        }
        this.zoning.getVirtualNetwork().clear();
    }

    public TransportLayerNetwork<?, ?> getInfrastructureNetwork() {
        return this.infrastructureNetwork;
    }

    public VirtualNetwork getVirtualNetwork() {
        return this.zoning.getVirtualNetwork();
    }

    public Zoning getZoning() {
        return this.zoning;
    }
}

