/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer.service;

import java.util.logging.Logger;
import org.goplanit.graph.directed.DirectedVertexImpl;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layer.service.ServiceNode;
import org.locationtech.jts.geom.Point;

public class ServiceNodeImpl
extends DirectedVertexImpl
implements ServiceNode {
    private static final long serialVersionUID = 3704157577170156850L;
    private static final Logger LOGGER = Logger.getLogger(ServiceNodeImpl.class.getCanonicalName());
    protected Node networkNode;

    protected void setNetworkLayerNode(Node networkNode) {
        this.networkNode = networkNode;
    }

    protected ServiceNodeImpl(IdGroupingToken tokenId, Node networkNode) {
        super(tokenId);
        this.networkNode = networkNode;
    }

    protected ServiceNodeImpl(ServiceNodeImpl serviceNode) {
        super(serviceNode);
        this.networkNode = serviceNode.getParentNode();
        this.edges.putAll(serviceNode.edges);
        this.entryEdgeSegments.addAll(serviceNode.entryEdgeSegments);
        this.exitEdgeSegments.addAll(serviceNode.exitEdgeSegments);
    }

    @Override
    public boolean addEdgeSegment(EdgeSegment serviceLegSegment) {
        if (!(serviceLegSegment instanceof ServiceLegSegment)) {
            LOGGER.warning("Unable to add, provided EdgeSegment no instance of ServiceLegSegment");
            return false;
        }
        return super.addEdgeSegment(serviceLegSegment);
    }

    @Override
    public final Point getPosition() {
        return this.networkNode.getPosition();
    }

    @Override
    public void setPosition(Point position) {
        LOGGER.warning("Unable to modify position, network node determines position of service node indirectly");
    }

    @Override
    public final Node getParentNode() {
        return this.networkNode;
    }

    @Override
    public ServiceNodeImpl clone() {
        return new ServiceNodeImpl(this);
    }
}

