/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network.layer;

import java.util.logging.Logger;
import org.goplanit.graph.directed.UntypedDirectedGraphImpl;
import org.goplanit.network.layer.TopologicalLayerImpl;
import org.goplanit.network.layer.modifier.UntypedNetworkLayerModifierImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.ManagedGraphEntities;
import org.goplanit.utils.graph.UntypedDirectedGraph;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.id.ManagedIdEntities;
import org.goplanit.utils.network.layer.TransportLayer;
import org.goplanit.utils.network.layer.UntypedDirectedGraphLayer;
import org.goplanit.utils.network.layer.modifier.UntypedDirectedGraphLayerModifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class UntypedNetworkLayerImpl<V extends DirectedVertex, E extends DirectedEdge, S extends EdgeSegment>
extends TopologicalLayerImpl
implements UntypedDirectedGraphLayer<V, E, S> {
    private static final Logger LOGGER = Logger.getLogger(UntypedNetworkLayerImpl.class.getCanonicalName());
    private final UntypedDirectedGraphImpl<V, E, S> graph;
    protected UntypedDirectedGraphLayerModifier<V, E, S> layerModifier;

    protected UntypedDirectedGraph<V, E, S> getGraph() {
        return this.graph;
    }

    public <Vx extends ManagedGraphEntities<V>, Ex extends ManagedGraphEntities<E>, Sx extends ManagedGraphEntities<S>> UntypedNetworkLayerImpl(IdGroupingToken tokenId, Vx vertices, Ex edges, Sx edgeSegments) {
        super(tokenId);
        this.graph = new UntypedDirectedGraphImpl(tokenId, vertices, edges, edgeSegments);
        this.layerModifier = new UntypedNetworkLayerModifierImpl<V, E, S>(this.graph);
    }

    public <Vx extends ManagedGraphEntities<V>, Ex extends ManagedGraphEntities<E>, Sx extends ManagedGraphEntities<S>> UntypedNetworkLayerImpl(IdGroupingToken tokenId, Vx vertices, Ex edges, Sx edgeSegments, UntypedDirectedGraphLayerModifier<V, E, S> layerModifier) {
        super(tokenId);
        this.graph = new UntypedDirectedGraphImpl(tokenId, vertices, edges, edgeSegments);
        this.layerModifier = layerModifier;
    }

    public UntypedNetworkLayerImpl(UntypedNetworkLayerImpl<V, E, S> untypedDirectedGraphLayerImpl) {
        super(untypedDirectedGraphLayerImpl);
        this.graph = untypedDirectedGraphLayerImpl.graph.clone();
        this.layerModifier = new UntypedNetworkLayerModifierImpl<V, E, S>(this.graph);
    }

    @Override
    public IdGroupingToken getLayerIdGroupingToken() {
        return this.graph.getGraphIdGroupingToken();
    }

    @Override
    public void transform(CoordinateReferenceSystem fromCoordinateReferenceSystem, CoordinateReferenceSystem toCoordinateReferenceSystem) throws PlanItException {
        try {
            this.getGraph().transformGeometries(PlanitJtsUtils.findMathTransform(fromCoordinateReferenceSystem, toCoordinateReferenceSystem));
        }
        catch (Exception e) {
            PlanitJtsUtils.findMathTransform(fromCoordinateReferenceSystem, toCoordinateReferenceSystem);
            throw new PlanItException(String.format("%s error during transformation of physical network %s CRS", TransportLayer.createLayerLogPrefix(this), this.getXmlId()), e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.graph.isEmpty();
    }

    @Override
    public boolean validate() {
        return this.graph.validate();
    }

    @Override
    public UntypedDirectedGraphLayerModifier<V, E, S> getLayerModifier() {
        return this.layerModifier;
    }

    @Override
    public abstract UntypedNetworkLayerImpl<V, E, S> clone();

    @Override
    public void reset() {
        super.reset();
        ((ManagedIdEntities)((Object)this.graph.getVertices())).reset();
        ((ManagedIdEntities)((Object)this.graph.getEdges())).reset();
        ((ManagedIdEntities)((Object)this.graph.getEdgeSegments())).reset();
    }
}

