/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.network;

import java.util.logging.Logger;
import org.goplanit.mode.ModesImpl;
import org.goplanit.network.Network;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.network.layer.TransportLayer;
import org.goplanit.utils.network.layers.TransportLayers;

public abstract class TransportLayerNetwork<U extends TransportLayer, T extends TransportLayers<U>>
extends Network {
    private static final long serialVersionUID = 2402806336978560448L;
    private static final Logger LOGGER = Logger.getLogger(TransportLayerNetwork.class.getCanonicalName());
    private final Modes modes;
    private T transportLayers;

    protected abstract T createLayersContainer(IdGroupingToken var1);

    public TransportLayerNetwork(IdGroupingToken tokenId) {
        super(tokenId);
        this.modes = new ModesImpl(tokenId);
        this.transportLayers = null;
    }

    public U getLayerByMode(Mode mode) {
        return (U)this.transportLayers.get(mode);
    }

    public Modes getModes() {
        return this.modes;
    }

    public T getTransportLayers() {
        if (this.transportLayers == null) {
            this.transportLayers = this.createLayersContainer(this.getNetworkGroupingTokenId());
        }
        return this.transportLayers;
    }

    @Override
    public void reset() {
        super.reset();
        this.modes.reset();
        this.transportLayers.reset();
    }
}

