/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.matsim.converter;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.goplanit.matsim.util.PlanitMatsimWriterSettings;
import org.goplanit.network.MacroscopicNetwork;

public class MatsimZoningWriterSettings
extends PlanitMatsimWriterSettings {
    private static final Logger LOGGER = Logger.getLogger(MatsimZoningWriterSettings.class.getCanonicalName());
    protected MacroscopicNetwork referenceNetwork;
    protected String transitScheduleFileName = "transitschedule";
    public static final String DEFAULT_TRANSIT_SCHEDULE_FILE_NAME = "transitschedule";

    protected void logSettings() {
        Path matsimZoningPath = Paths.get(this.getOutputDirectory(), this.getOutputFileName().concat(".xml"));
        LOGGER.info(String.format("Persisting MATSIM pt to: %s", matsimZoningPath.toString()));
    }

    protected MacroscopicNetwork getReferenceNetwork() {
        return this.referenceNetwork;
    }

    public MatsimZoningWriterSettings() {
        this("global");
    }

    public MatsimZoningWriterSettings(String countryName) {
        this(null, DEFAULT_TRANSIT_SCHEDULE_FILE_NAME, countryName);
    }

    public MatsimZoningWriterSettings(String outputDirectory, String countryName) {
        super(outputDirectory, DEFAULT_TRANSIT_SCHEDULE_FILE_NAME, countryName);
    }

    public MatsimZoningWriterSettings(String outputDirectory, String outputFileName, String countryName) {
        this(outputDirectory, outputFileName, countryName, null);
    }

    public MatsimZoningWriterSettings(String outputDirectory, String outputFileName, String countryName, MacroscopicNetwork referenceNetwork) {
        super(outputDirectory, outputFileName, countryName);
        this.setReferenceNetwork(referenceNetwork);
    }

    public void setReferenceNetwork(MacroscopicNetwork referenceNetwork) {
        this.referenceNetwork = referenceNetwork;
    }

    @Override
    public void reset() {
    }
}

