/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.matsim.converter;

import org.goplanit.converter.ConverterWriterSettings;
import org.goplanit.matsim.converter.MatsimNetworkWriterSettings;
import org.goplanit.matsim.converter.MatsimZoningWriterSettings;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MatsimIntermodalWriterSettings
implements ConverterWriterSettings {
    protected final MatsimNetworkWriterSettings networkSettings;
    protected final MatsimZoningWriterSettings zoningSettings;

    public MatsimIntermodalWriterSettings() {
        this(null, "global");
    }

    public MatsimIntermodalWriterSettings(String outputDirectory, String countryName) {
        this(new MatsimNetworkWriterSettings(outputDirectory, countryName), new MatsimZoningWriterSettings(outputDirectory, countryName));
    }

    public MatsimIntermodalWriterSettings(String outputDirectory, String countryName, String networkOutputFileName, String ptOutputFileName) {
        this(new MatsimNetworkWriterSettings(outputDirectory, networkOutputFileName, countryName), new MatsimZoningWriterSettings(outputDirectory, ptOutputFileName, countryName));
    }

    public MatsimIntermodalWriterSettings(MatsimNetworkWriterSettings networkWriterSettings, MatsimZoningWriterSettings zoningWriterSettings) {
        this.networkSettings = networkWriterSettings;
        this.zoningSettings = zoningWriterSettings;
    }

    @Override
    public void reset() {
        this.getNetworkSettings().reset();
        this.getZoningSettings().reset();
    }

    public MatsimZoningWriterSettings getZoningSettings() {
        return this.zoningSettings;
    }

    public MatsimNetworkWriterSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.getNetworkSettings().setOutputDirectory(outputDirectory);
        this.getZoningSettings().setOutputDirectory(outputDirectory);
    }

    public void setCountry(String countryName) {
        this.getNetworkSettings().setCountry(countryName);
        this.getZoningSettings().setCountry(countryName);
    }

    public void setDestinationCoordinateReferenceSystem(CoordinateReferenceSystem destinationCoordinateReferenceSystem) {
        this.getNetworkSettings().setDestinationCoordinateReferenceSystem(destinationCoordinateReferenceSystem);
        this.getZoningSettings().setDestinationCoordinateReferenceSystem(destinationCoordinateReferenceSystem);
    }
}

