/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.xml.util;

import java.io.File;
import java.util.logging.Logger;
import org.goplanit.io.xml.util.JAXBUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitCrsUtils;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.misc.FileUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.xml.generated.XMLElementPLANit;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitXmlJaxbParser<T> {
    private static final Logger LOGGER = Logger.getLogger(PlanitXmlJaxbParser.class.getCanonicalName());
    private Class<T> clazz;
    private T xmlRootElement;
    public static final String DEFAULT_XML_FILE_EXTENSION = ".xml";

    private T getSubEntityRootElementFromCombinedXmlRootElement(XMLElementPLANit xmlRawPLANitAll) {
        if (xmlRawPLANitAll.getMacroscopicnetwork() != null && xmlRawPLANitAll.getMacroscopicnetwork().getClass().equals(this.clazz)) {
            return (T)xmlRawPLANitAll.getMacroscopicnetwork();
        }
        if (xmlRawPLANitAll.getMacroscopiczoning() != null && xmlRawPLANitAll.getMacroscopiczoning().getClass().equals(this.clazz)) {
            return (T)xmlRawPLANitAll.getMacroscopiczoning();
        }
        if (xmlRawPLANitAll.getMacroscopicdemand() != null && xmlRawPLANitAll.getMacroscopicdemand().getClass().equals(this.clazz)) {
            return (T)xmlRawPLANitAll.getMacroscopicdemand();
        }
        if (xmlRawPLANitAll.getServicenetwork() != null && xmlRawPLANitAll.getServicenetwork().getClass().equals(this.clazz)) {
            return (T)xmlRawPLANitAll.getServicenetwork();
        }
        if (xmlRawPLANitAll.getRoutedservices() != null && xmlRawPLANitAll.getRoutedservices().getClass().equals(this.clazz)) {
            return (T)xmlRawPLANitAll.getRoutedservices();
        }
        return null;
    }

    public PlanitXmlJaxbParser(Class<T> clazz) {
        this.clazz = clazz;
        this.xmlRootElement = null;
    }

    public PlanitXmlJaxbParser(T xmlRootElement) {
        this.clazz = null;
        this.xmlRootElement = xmlRootElement;
    }

    public boolean initialiseAndParseXmlRootElement(String inputPathDirectory, String xmlFileExtension) throws PlanItException {
        if (this.xmlRootElement == null) {
            PlanItException.throwIfNull(inputPathDirectory, "Input path directory for XML reader is not provided, unable to parse");
            PlanItException.throwIfNull(xmlFileExtension, "No XML file extension provided, unable to parse files if extension is unknown");
            File[] xmlFileNames = FileUtils.getFilesWithExtensionFromDir(inputPathDirectory, xmlFileExtension);
            PlanItException.throwIf(xmlFileNames.length == 0, String.format("Directory %s contains no files with extension %s", inputPathDirectory, xmlFileExtension), new Object[0]);
            T rootElement = JAXBUtils.generateInstanceFromXml(this.clazz, xmlFileNames);
            if (rootElement == null) {
                XMLElementPLANit xmlRawPLANitAll = JAXBUtils.generateInstanceFromXml(XMLElementPLANit.class, xmlFileNames);
                if (xmlRawPLANitAll == null) {
                    LOGGER.severe(String.format("Unable to parse any appropriate XML input file from %s with extension %s, either no file is present, or file is not conforming to underlying XSD", inputPathDirectory, xmlFileExtension));
                    return false;
                }
                rootElement = this.getSubEntityRootElementFromCombinedXmlRootElement(xmlRawPLANitAll);
                if (rootElement == null) {
                    LOGGER.severe("Unable to identify which sub element of PLANit XML root element is to be chosen as (sub) root element for this parser");
                    return false;
                }
            }
            this.setXmlRootElement(rootElement);
        }
        return true;
    }

    public static CoordinateReferenceSystem createPlanitCrs(String srsName) throws PlanItException {
        CoordinateReferenceSystem crs = null;
        if (StringUtils.isNullOrBlank(srsName)) {
            crs = PlanitJtsCrsUtils.DEFAULT_GEOGRAPHIC_CRS;
            LOGGER.warning(String.format("coordinate reference system not set, applying default %s", crs.getName().getCode()));
        } else {
            crs = PlanitCrsUtils.createCoordinateReferenceSystem(srsName);
            if (crs == null) {
                throw new PlanItException("Srs name provided (%s) but it could not be converted into a coordinate reference system", srsName);
            }
        }
        return crs;
    }

    public T getXmlRootElement() {
        return this.xmlRootElement;
    }

    public void setXmlRootElement(T xmlRootElement) {
        this.xmlRootElement = xmlRootElement;
    }

    public void clearXmlContent() {
        this.xmlRootElement = null;
    }
}

