/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.xml.util;

import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.mode.MotorisationModeType;
import org.goplanit.utils.mode.TrackModeType;
import org.goplanit.utils.mode.UseOfModeType;
import org.goplanit.utils.mode.VehicularModeType;
import org.goplanit.utils.unit.TimeUnit;
import org.goplanit.utils.unit.Unit;
import org.goplanit.xml.generated.MotorisationType;
import org.goplanit.xml.generated.TrackType;
import org.goplanit.xml.generated.UsedToType;
import org.goplanit.xml.generated.VehicularType;

public class EnumConversionUtil {
    public static MotorisationModeType xmlToPlanit(MotorisationType xmlMotorisationType) throws PlanItException {
        switch (xmlMotorisationType) {
            case MOTORISED: {
                return MotorisationModeType.MOTORISED;
            }
            case NON_MOTORISED: {
                return MotorisationModeType.NON_MOTORISED;
            }
        }
        throw new PlanItException(String.format("mapping from xml motorisation type %s to PLANit motorisation type unavailable", xmlMotorisationType.toString()));
    }

    public static MotorisationType planitToXml(MotorisationModeType planitMotorisationType) throws PlanItException {
        switch (planitMotorisationType) {
            case MOTORISED: {
                return MotorisationType.MOTORISED;
            }
            case NON_MOTORISED: {
                return MotorisationType.NON_MOTORISED;
            }
        }
        throw new PlanItException(String.format("mapping from planit motorisation type %s to xml motorisation type unavailable", planitMotorisationType.toString()));
    }

    public static VehicularModeType xmlToPlanit(VehicularType xmlVehicularType) throws PlanItException {
        switch (xmlVehicularType) {
            case VEHICLE: {
                return VehicularModeType.VEHICLE;
            }
            case NO_VEHICLE: {
                return VehicularModeType.NO_VEHICLE;
            }
        }
        throw new PlanItException(String.format("mapping from xml vehicular type %s to PLANit vehicular type unavailable", xmlVehicularType.toString()));
    }

    public static VehicularType planitToXml(VehicularModeType planitVehicularType) throws PlanItException {
        switch (planitVehicularType) {
            case VEHICLE: {
                return VehicularType.VEHICLE;
            }
            case NO_VEHICLE: {
                return VehicularType.NO_VEHICLE;
            }
        }
        throw new PlanItException(String.format("mapping from planit vehicular type %s to xml vehicular type unavailable", planitVehicularType.toString()));
    }

    public static TrackModeType xmlToPlanit(TrackType xmlTrackType) throws PlanItException {
        switch (xmlTrackType) {
            case RAIL: {
                return TrackModeType.RAIL;
            }
            case ROAD: {
                return TrackModeType.ROAD;
            }
        }
        throw new PlanItException(String.format("mapping from xml track type %s to PLANit track type unavailable", xmlTrackType.toString()));
    }

    public static TrackType planitToXml(TrackModeType xmlTrackType) throws PlanItException {
        switch (xmlTrackType) {
            case RAIL: {
                return TrackType.RAIL;
            }
            case ROAD: {
                return TrackType.ROAD;
            }
        }
        throw new PlanItException(String.format("mapping from planit track type %s to xml track type unavailable", xmlTrackType.toString()));
    }

    public static UseOfModeType xmlToPlanit(UsedToType xmlUseOfType) throws PlanItException {
        switch (xmlUseOfType) {
            case GOODS: {
                return UseOfModeType.GOODS;
            }
            case HIGH_OCCUPANCY: {
                return UseOfModeType.HIGH_OCCUPANCY;
            }
            case PRIVATE: {
                return UseOfModeType.PRIVATE;
            }
            case PUBLIC: {
                return UseOfModeType.PUBLIC;
            }
            case RIDE_SHARE: {
                return UseOfModeType.RIDE_SHARE;
            }
        }
        throw new PlanItException(String.format("mapping from xml track type %s to PLANit track type unavailable", xmlUseOfType.toString()));
    }

    public static UsedToType planitToXml(UseOfModeType useOfType) throws PlanItException {
        switch (useOfType) {
            case GOODS: {
                return UsedToType.GOODS;
            }
            case HIGH_OCCUPANCY: {
                return UsedToType.HIGH_OCCUPANCY;
            }
            case PRIVATE: {
                return UsedToType.PRIVATE;
            }
            case PUBLIC: {
                return UsedToType.PUBLIC;
            }
            case RIDE_SHARE: {
                return UsedToType.RIDE_SHARE;
            }
        }
        throw new PlanItException(String.format("mapping from planit used-to type %s to xml used-to type unavailable", useOfType.toString()));
    }

    public static TimeUnit xmlToPlanit(org.goplanit.xml.generated.TimeUnit xmlTimeUnitType) throws PlanItException {
        switch (xmlTimeUnitType) {
            case H: {
                return Unit.HOUR;
            }
            case MIN: {
                return Unit.MINUTE;
            }
            case S: {
                return Unit.SECOND;
            }
        }
        throw new PlanItException(String.format("mapping from XML TimeUnit %s to PLANit Units type unavailable", xmlTimeUnitType.toString()));
    }

    public static org.goplanit.xml.generated.TimeUnit planitToXml(Unit planitTimeUnit) throws PlanItException {
        if (planitTimeUnit.equals(Unit.HOUR)) {
            return org.goplanit.xml.generated.TimeUnit.H;
        }
        if (planitTimeUnit.equals(Unit.MINUTE)) {
            return org.goplanit.xml.generated.TimeUnit.MIN;
        }
        if (planitTimeUnit.equals(Unit.SECOND)) {
            return org.goplanit.xml.generated.TimeUnit.S;
        }
        throw new PlanItException(String.format("mapping from PLANit time unit (Units) %s to XML TimeUnit unavailable", planitTimeUnit.toString()));
    }
}

