/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.input;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.goplanit.component.event.PlanitComponentEvent;
import org.goplanit.component.event.PopulateDemandsEvent;
import org.goplanit.component.event.PopulateInitialLinkSegmentCostEvent;
import org.goplanit.component.event.PopulateNetworkEvent;
import org.goplanit.component.event.PopulateRoutedServicesEvent;
import org.goplanit.component.event.PopulateServiceNetworkEvent;
import org.goplanit.component.event.PopulateZoningEvent;
import org.goplanit.cost.physical.initial.InitialLinkSegmentCost;
import org.goplanit.demands.Demands;
import org.goplanit.input.InputBuilderListener;
import org.goplanit.io.converter.demands.PlanitDemandsReader;
import org.goplanit.io.converter.network.PlanitNetworkReader;
import org.goplanit.io.converter.network.PlanitNetworkReaderFactory;
import org.goplanit.io.converter.service.PlanitRoutedServicesReader;
import org.goplanit.io.converter.service.PlanitRoutedServicesReaderFactory;
import org.goplanit.io.converter.service.PlanitServiceNetworkReader;
import org.goplanit.io.converter.service.PlanitServiceNetworkReaderFactory;
import org.goplanit.io.converter.zoning.PlanitZoningReader;
import org.goplanit.io.converter.zoning.PlanitZoningReaderFactory;
import org.goplanit.io.xml.util.JAXBUtils;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.output.property.OutputProperty;
import org.goplanit.output.property.OutputPropertyType;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.misc.FileUtils;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.wrapper.MapWrapperImpl;
import org.goplanit.xml.generated.XMLElementMacroscopicDemand;
import org.goplanit.xml.generated.XMLElementMacroscopicNetwork;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.xml.generated.XMLElementPLANit;
import org.goplanit.xml.generated.XMLElementRoutedServices;
import org.goplanit.xml.generated.XMLElementServiceNetwork;
import org.goplanit.zoning.Zoning;

public class PlanItInputBuilder
extends InputBuilderListener {
    private static final Logger LOGGER = Logger.getLogger(PlanItInputBuilder.class.getCanonicalName());
    private XMLElementMacroscopicDemand xmlRawDemand;
    private XMLElementMacroscopicZoning xmlRawZoning;
    private XMLElementMacroscopicNetwork xmlRawNetwork;
    private XMLElementServiceNetwork xmlRawServiceNetwork = null;
    private XMLElementRoutedServices xmlRawRoutedServices = null;
    private final String projectPath;
    private final String xmlFileExtension;
    public static final String DEFAULT_SEPARATOR = ",";

    private void createGeneratedClassesFromXmlLocations(File zoningXmlFileLocation, File demandXmlFileLocation, File networkXmlFileLocation) throws PlanItException {
        try {
            this.xmlRawZoning = (XMLElementMacroscopicZoning)JAXBUtils.generateObjectFromXml(XMLElementMacroscopicZoning.class, zoningXmlFileLocation);
            this.xmlRawDemand = (XMLElementMacroscopicDemand)JAXBUtils.generateObjectFromXml(XMLElementMacroscopicDemand.class, demandXmlFileLocation);
            this.xmlRawNetwork = (XMLElementMacroscopicNetwork)JAXBUtils.generateObjectFromXml(XMLElementMacroscopicNetwork.class, networkXmlFileLocation);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error while generating classes from XML locations in PLANitIO", e);
        }
    }

    private void parseXmlRawInputs() throws PlanItException {
        File[] xmlFileNames = FileUtils.getFilesWithExtensionFromDir(this.projectPath, this.xmlFileExtension);
        boolean success = this.parseXmlRawInputsFromSingleFile(xmlFileNames);
        if (!success) {
            success = this.parseXmlRawInputSeparateFiles(xmlFileNames);
        }
        PlanItException.throwIf(!success, String.format("The directory %s does not contain either one file with all the macroscopic inputs or a separate file for each of zoning, demand and network", this.projectPath), new Object[0]);
    }

    private boolean parseXmlRawInputsFromSingleFile(File[] xmlFileNames) {
        XMLElementPLANit xmlRawPLANitAll = JAXBUtils.generateInstanceFromXml(XMLElementPLANit.class, xmlFileNames);
        if (xmlRawPLANitAll != null) {
            this.xmlRawZoning = xmlRawPLANitAll.getMacroscopiczoning();
            this.xmlRawNetwork = xmlRawPLANitAll.getMacroscopicnetwork();
            this.xmlRawDemand = xmlRawPLANitAll.getMacroscopicdemand();
            if (xmlRawPLANitAll.getServicenetwork() != null) {
                this.xmlRawServiceNetwork = xmlRawPLANitAll.getServicenetwork();
            }
            if (xmlRawPLANitAll.getRoutedservices() != null) {
                this.xmlRawRoutedServices = xmlRawPLANitAll.getRoutedservices();
            }
            return true;
        }
        return false;
    }

    private boolean parseXmlRawInputSeparateFiles(File[] xmlFileNames) {
        this.xmlRawZoning = JAXBUtils.generateInstanceFromXml(XMLElementMacroscopicZoning.class, xmlFileNames);
        this.xmlRawNetwork = JAXBUtils.generateInstanceFromXml(XMLElementMacroscopicNetwork.class, xmlFileNames);
        this.xmlRawDemand = JAXBUtils.generateInstanceFromXml(XMLElementMacroscopicDemand.class, xmlFileNames);
        return this.xmlRawZoning != null && this.xmlRawNetwork != null && this.xmlRawDemand != null;
    }

    private void setInputFilesSeparateFilesWithValidation(String projectPath, File[] xmlFileNames) throws PlanItException {
        File zoningFileName = null;
        File networkFileName = null;
        File demandFileName = null;
        boolean serviceNetworkFileDone = false;
        boolean routedServicesFileDone = false;
        for (int i = 0; i < xmlFileNames.length; ++i) {
            if (zoningFileName == null && PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], "https://trafficplanit.github.io/PLANitManual/xsd/macroscopiczoninginput.xsd")) {
                zoningFileName = xmlFileNames[i];
                LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + zoningFileName + " provides the zoning input data.");
                continue;
            }
            if (networkFileName == null && PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], "https://trafficplanit.github.io/PLANitManual/xsd/macroscopicnetworkinput.xsd")) {
                networkFileName = xmlFileNames[i];
                LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + networkFileName + " provides the network input data.");
                continue;
            }
            if (demandFileName == null && PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], "https://trafficplanit.github.io/PLANitManual/xsd/macroscopicdemandinput.xsd")) {
                demandFileName = xmlFileNames[i];
                LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + demandFileName + " provides the demand input data.");
                continue;
            }
            if (!serviceNetworkFileDone && PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], "https://trafficplanit.github.io/PLANitManual/xsd/servicenetworkinput.xsd")) {
                serviceNetworkFileDone = true;
                LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + xmlFileNames[i] + " provides the service network input data.");
                continue;
            }
            if (routedServicesFileDone || !PlanItInputBuilder.validateXmlInputFile(xmlFileNames[i], "https://trafficplanit.github.io/PLANitManual/xsd/routedservicesinput.xsd")) continue;
            routedServicesFileDone = true;
            LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "file " + xmlFileNames[i] + " provides the routed services input data.");
        }
        PlanItException.throwIfNull(zoningFileName, "Failed to find a valid zoning input file in directory %s", projectPath);
        PlanItException.throwIfNull(networkFileName, "Failed to find a valid network input file in directory %s", projectPath);
        PlanItException.throwIfNull(demandFileName, "Failed to find a valid demand input file in directory %s", projectPath);
        this.createGeneratedClassesFromXmlLocations(zoningFileName, demandFileName, networkFileName);
    }

    private OutputPropertyType getInitialCostLinkIdentificationMethod(Set<String> headers) throws PlanItException {
        boolean linkSegmentXmlIdPresent = false;
        boolean linkSegmentExternalIdPresent = false;
        boolean upstreamNodeXmlIdPresent = false;
        boolean downstreamNodeXmlIdPresent = false;
        boolean modeXmlIdPresent = false;
        boolean costPresent = false;
        for (String header : headers) {
            OutputPropertyType outputProperty = OutputPropertyType.fromHeaderName(header);
            switch (outputProperty) {
                case LINK_SEGMENT_XML_ID: {
                    linkSegmentXmlIdPresent = true;
                    break;
                }
                case LINK_SEGMENT_EXTERNAL_ID: {
                    linkSegmentExternalIdPresent = true;
                    break;
                }
                case MODE_XML_ID: {
                    modeXmlIdPresent = true;
                    break;
                }
                case UPSTREAM_NODE_XML_ID: {
                    upstreamNodeXmlIdPresent = true;
                    break;
                }
                case DOWNSTREAM_NODE_XML_ID: {
                    downstreamNodeXmlIdPresent = true;
                    break;
                }
                case LINK_SEGMENT_COST: {
                    costPresent = true;
                }
            }
        }
        PlanItException.throwIf(!costPresent, "Cost column not present in initial link segment costs file", new Object[0]);
        PlanItException.throwIf(!modeXmlIdPresent, "Mode xml Id not present in initial link segment costs file", new Object[0]);
        if (linkSegmentXmlIdPresent) {
            return OutputPropertyType.LINK_SEGMENT_XML_ID;
        }
        if (linkSegmentExternalIdPresent) {
            return OutputPropertyType.LINK_SEGMENT_EXTERNAL_ID;
        }
        if (upstreamNodeXmlIdPresent && downstreamNodeXmlIdPresent) {
            return OutputPropertyType.UPSTREAM_NODE_XML_ID;
        }
        throw new PlanItException("Links not correctly identified in initial link segment costs file");
    }

    private void setInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost, CSVRecord record, MacroscopicLinkSegment linkSegment, TimePeriod timePeriod) throws PlanItException {
        String modeXmlId = record.get("Mode Xml Id");
        Mode matchMode = null;
        for (Mode mode : linkSegment.getAllowedModes()) {
            if (!mode.getXmlId().equals(modeXmlId)) continue;
            matchMode = mode;
            break;
        }
        if (matchMode == null) {
            throw new PlanItException("mode xml id not suported by link segment used for initial link segment cost");
        }
        double cost = Double.parseDouble(record.get("Cost"));
        if (timePeriod == null) {
            initialLinkSegmentCost.setSegmentCost(matchMode, linkSegment, cost);
        } else {
            initialLinkSegmentCost.setSegmentCost(timePeriod, matchMode, linkSegment, cost);
        }
    }

    protected void populateMacroscopicNetwork(MacroscopicNetwork network) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating network");
        if (this.xmlRawNetwork == null) {
            this.parseXmlRawInputs();
        }
        PlanitNetworkReader networkReader = PlanitNetworkReaderFactory.create(this.xmlRawNetwork, network);
        networkReader.getSettings().setInputDirectory(this.projectPath);
        networkReader.read();
        this.xmlRawNetwork = null;
    }

    protected void populateZoning(Zoning zoning, MacroscopicNetwork network) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating Zoning");
        PlanitZoningReader zoningReader = PlanitZoningReaderFactory.create(this.xmlRawZoning, network, zoning);
        zoningReader.getSettings().setInputDirectory(this.projectPath);
        zoningReader.read();
        this.xmlRawZoning = null;
    }

    protected void populateDemands(Demands demands, Zoning zoning, MacroscopicNetwork network) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating Demands");
        PlanitDemandsReader demandsReader = new PlanitDemandsReader(this.xmlRawDemand, network, zoning, demands);
        demandsReader.getSettings().setInputDirectory(this.projectPath);
        demandsReader.read();
        this.xmlRawDemand = null;
    }

    protected void populateRoutedServices(RoutedServices routedServicesToPopulate) throws PlanItException {
        if (this.xmlRawRoutedServices == null) {
            this.xmlRawRoutedServices = JAXBUtils.generateInstanceFromXml(XMLElementRoutedServices.class, FileUtils.getFilesWithExtensionFromDir(this.projectPath, this.xmlFileExtension));
        }
        if (this.xmlRawRoutedServices == null) {
            LOGGER.severe("Unable to locate routed services XML input");
            return;
        }
        PlanitRoutedServicesReader routedServicesReader = PlanitRoutedServicesReaderFactory.create(this.xmlRawRoutedServices, routedServicesToPopulate);
        routedServicesReader.read();
        this.xmlRawRoutedServices = null;
    }

    protected void populateServiceNetwork(ServiceNetwork serviceNetworkToPopulate) throws PlanItException {
        if (this.xmlRawServiceNetwork == null) {
            this.xmlRawServiceNetwork = JAXBUtils.generateInstanceFromXml(XMLElementServiceNetwork.class, FileUtils.getFilesWithExtensionFromDir(this.projectPath, this.xmlFileExtension));
        }
        if (this.xmlRawServiceNetwork == null) {
            LOGGER.severe("Unable to locate service network XML input");
            return;
        }
        PlanitServiceNetworkReader serviceNetworkReader = PlanitServiceNetworkReaderFactory.create(this.xmlRawServiceNetwork, serviceNetworkToPopulate);
        serviceNetworkReader.getSettings().setInputDirectory(this.projectPath);
        serviceNetworkReader.read();
        this.xmlRawServiceNetwork = null;
    }

    protected void populateInitialLinkSegmentCost(PopulateInitialLinkSegmentCostEvent initialCostEvent) throws PlanItException {
        LOGGER.fine(LoggingUtils.getClassNameWithBrackets(this) + "populating Initial Link Segment Costs");
        MacroscopicNetwork network = initialCostEvent.getParentNetwork();
        String fileName = initialCostEvent.getFileName();
        PlanItException.throwIfNull(network, "parent network for initial link segment cost is null");
        PlanItException.throwIfNull(fileName, "file location for initial link segment cost is null");
        try {
            FileReader in = new FileReader(fileName);
            CSVParser parser = CSVParser.parse(in, CSVFormat.DEFAULT.withFirstRecordAsHeader().withIgnoreSurroundingSpaces());
            Set<String> headers = parser.getHeaderMap().keySet();
            InitialLinkSegmentCost initialLinkSegmentCost = initialCostEvent.getInitialLinkSegmentCostToPopulate();
            OutputPropertyType linkIdentificationMethod = this.getInitialCostLinkIdentificationMethod(headers);
            if (linkIdentificationMethod.equals((Object)OutputPropertyType.UPSTREAM_NODE_XML_ID)) {
                HashMap indexByIdentificationMethod = new HashMap();
                for (MacroscopicNetworkLayer layer : (MacroscopicNetworkLayers)network.getTransportLayers()) {
                    for (MacroscopicLinkSegment linkSegment : layer.getLinkSegments()) {
                        Node upstreamNode = linkSegment.getUpstreamVertex();
                        indexByIdentificationMethod.putIfAbsent(upstreamNode.getXmlId(), new HashMap());
                        ((Map)indexByIdentificationMethod.get(upstreamNode.getXmlId())).put(linkSegment.getDownstreamVertex().getXmlId(), linkSegment);
                    }
                }
                for (CSVRecord record : parser) {
                    MacroscopicLinkSegment linkSegment = (MacroscopicLinkSegment)((Map)indexByIdentificationMethod.get(record.get("Upstream Node Xml Id"))).get(record.get("Downstream Node Xml Id"));
                    PlanItException.throwIfNull(linkSegment, "failed to find link segment for record %d", record.getRecordNumber());
                    this.setInitialLinkSegmentCost(initialLinkSegmentCost, record, linkSegment, initialCostEvent.getTimePeriod());
                }
            } else {
                MapWrapperImpl<Object, MacroscopicLinkSegment> indexByIdentificationMethod = null;
                String identificationColumnName = null;
                switch (linkIdentificationMethod) {
                    case LINK_SEGMENT_EXTERNAL_ID: {
                        indexByIdentificationMethod = new MapWrapperImpl<Object, MacroscopicLinkSegment>(new HashMap(), ExternalIdAble::getExternalId);
                        identificationColumnName = "Link Segment External Id";
                        break;
                    }
                    case LINK_SEGMENT_XML_ID: {
                        indexByIdentificationMethod = new MapWrapperImpl<Object, MacroscopicLinkSegment>(new HashMap(), ExternalIdAble::getXmlId);
                        identificationColumnName = "Link Segment Xml Id";
                        break;
                    }
                    default: {
                        throw new PlanItException("Invalid Output Property " + OutputProperty.of(linkIdentificationMethod).getName() + " found in header of Initial Link Segment Cost CSV file");
                    }
                }
                for (MacroscopicNetworkLayer layer : (MacroscopicNetworkLayers)network.getTransportLayers()) {
                    indexByIdentificationMethod.addAll(layer.getLinkSegments());
                }
                for (CSVRecord record : parser) {
                    MacroscopicLinkSegment linkSegment = (MacroscopicLinkSegment)indexByIdentificationMethod.get(record.get(identificationColumnName));
                    PlanItException.throwIfNull(linkSegment, "failed to find link segment for record %d", record.getRecordNumber());
                    this.setInitialLinkSegmentCost(initialLinkSegmentCost, record, linkSegment, initialCostEvent.getTimePeriod());
                }
            }
            ((Reader)in).close();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when initialising link segment costs in PLANitIO", e);
        }
    }

    public PlanItInputBuilder(String projectPath) throws PlanItException {
        this(projectPath, ".xml");
    }

    public PlanItInputBuilder(String projectPath, String xmlFileExtension) throws PlanItException {
        LOGGER.info(LoggingUtils.getClassNameWithBrackets(this) + "project path is set to: " + projectPath);
        this.projectPath = projectPath;
        this.xmlFileExtension = xmlFileExtension;
    }

    public static boolean validateXmlInputFile(File xmlFileLocation, String schemaFileLocation) {
        try {
            JAXBUtils.validateXml(xmlFileLocation, schemaFileLocation);
            return true;
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
            return false;
        }
    }

    @Override
    public void onPlanitComponentEvent(PlanitComponentEvent event) throws PlanItException {
        if (event.getType().equals(PopulateNetworkEvent.EVENT_TYPE)) {
            this.populateMacroscopicNetwork(((PopulateNetworkEvent)event).getNetworkToPopulate());
        } else if (event.getType().equals(PopulateZoningEvent.EVENT_TYPE)) {
            PopulateZoningEvent zoningEvent = (PopulateZoningEvent)event;
            this.populateZoning(zoningEvent.getZoningToPopulate(), zoningEvent.getParentNetwork());
        } else if (event.getType().equals(PopulateDemandsEvent.EVENT_TYPE)) {
            PopulateDemandsEvent demandsEvent = (PopulateDemandsEvent)event;
            this.populateDemands(demandsEvent.getDemandsToPopulate(), demandsEvent.getParentZoning(), demandsEvent.getParentNetwork());
        } else if (event.getType().equals(PopulateInitialLinkSegmentCostEvent.EVENT_TYPE)) {
            PopulateInitialLinkSegmentCostEvent initialCostEvent = (PopulateInitialLinkSegmentCostEvent)event;
            this.populateInitialLinkSegmentCost(initialCostEvent);
        } else if (event.getType().equals(PopulateServiceNetworkEvent.EVENT_TYPE)) {
            PopulateServiceNetworkEvent serviceNetworkEvent = (PopulateServiceNetworkEvent)event;
            this.populateServiceNetwork(serviceNetworkEvent.getServiceNetworkToPopulate());
        } else if (event.getType().equals(PopulateRoutedServicesEvent.EVENT_TYPE)) {
            PopulateRoutedServicesEvent routedServicesEvent = (PopulateRoutedServicesEvent)event;
            this.populateRoutedServices(routedServicesEvent.getRoutedServicesToPopulate());
        } else {
            LOGGER.fine("Event component " + event.getClass().getCanonicalName() + " ignored by PlanItInputBuilder");
        }
    }
}

