/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.zoning;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import net.opengis.gml.CoordinatesType;
import net.opengis.gml.LineStringType;
import net.opengis.gml.LinearRingType;
import net.opengis.gml.PolygonType;
import org.goplanit.converter.BaseReaderImpl;
import org.goplanit.converter.zoning.ZoningReader;
import org.goplanit.io.converter.zoning.PlanitZoningReaderSettings;
import org.goplanit.io.xml.util.PlanitXmlJaxbParser;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.mode.Modes;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.Node;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.Connectoid;
import org.goplanit.utils.zoning.ConnectoidType;
import org.goplanit.utils.zoning.DirectedConnectoid;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.utils.zoning.TransferZone;
import org.goplanit.utils.zoning.TransferZoneGroup;
import org.goplanit.utils.zoning.TransferZoneType;
import org.goplanit.utils.zoning.UndirectedConnectoid;
import org.goplanit.utils.zoning.Zone;
import org.goplanit.xml.generated.Connectoidnodelocationtype;
import org.goplanit.xml.generated.Connectoidtype;
import org.goplanit.xml.generated.Connectoidtypetype;
import org.goplanit.xml.generated.Intermodaltype;
import org.goplanit.xml.generated.Odconnectoid;
import org.goplanit.xml.generated.Transferzonetype;
import org.goplanit.xml.generated.XMLElementCentroid;
import org.goplanit.xml.generated.XMLElementConnectoid;
import org.goplanit.xml.generated.XMLElementMacroscopicZoning;
import org.goplanit.xml.generated.XMLElementTransferGroup;
import org.goplanit.xml.generated.XMLElementTransferZoneAccess;
import org.goplanit.xml.generated.XMLElementTransferZoneGroups;
import org.goplanit.xml.generated.XMLElementTransferZones;
import org.goplanit.xml.generated.XMLElementZones;
import org.goplanit.zoning.Zoning;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PlanitZoningReader
extends BaseReaderImpl<Zoning>
implements ZoningReader {
    private static final Logger LOGGER = Logger.getLogger(PlanitZoningReader.class.getCanonicalName());
    private final PlanitXmlJaxbParser<XMLElementMacroscopicZoning> xmlParser;
    private PlanitJtsCrsUtils jtsUtils = null;
    protected final PlanitZoningReaderSettings settings;
    protected Zoning zoning;
    protected TransportLayerNetwork<?, ?> network;
    public static final String ZONING_XSD_FILE = "https://trafficplanit.github.io/PLANitManual/xsd/macroscopiczoninginput.xsd";

    private void initialiseParentNetworkXmlIdTrackers(MacroscopicNetwork network) {
        this.initialiseSourceIdMap(Node.class, ExternalIdAble::getXmlId);
        ((MacroscopicNetworkLayers)network.getTransportLayers()).forEach(layer -> this.getSourceIdContainer(Node.class).addAll(layer.getNodes()));
        this.initialiseSourceIdMap(MacroscopicLinkSegment.class, ExternalIdAble::getXmlId);
        ((MacroscopicNetworkLayers)network.getTransportLayers()).forEach(layer -> this.getSourceIdContainer(MacroscopicLinkSegment.class).addAll(layer.getLinkSegments()));
    }

    private void initialiseXmlIdTrackers() {
        this.initialiseSourceIdMap(Zone.class, ExternalIdAble::getXmlId);
        this.initialiseSourceIdMap(Connectoid.class, ExternalIdAble::getXmlId);
    }

    private static TransferZoneType parseTransferZoneType(Transferzonetype xmlTransferZone) {
        if (xmlTransferZone == null) {
            return TransferZoneType.NONE;
        }
        switch (xmlTransferZone) {
            case PLATFORM: {
                return TransferZoneType.PLATFORM;
            }
            case STOP_POLE: {
                return TransferZoneType.POLE;
            }
            case UNKNOWN: {
                return TransferZoneType.UNKNOWN;
            }
            case NONE: {
                return TransferZoneType.NONE;
            }
        }
        LOGGER.warning(String.format("Unsupported transfer stop type %s found, changed to `unknown`", xmlTransferZone.value()));
        return TransferZoneType.UNKNOWN;
    }

    private static ConnectoidType parseConnectoidType(Connectoidtypetype xmlConnectoidType) {
        if (xmlConnectoidType == null) {
            return ConnectoidType.NONE;
        }
        switch (xmlConnectoidType) {
            case PT_VEH_STOP: {
                return ConnectoidType.PT_VEHICLE_STOP;
            }
            case TRAVELLER_ACCESS: {
                return ConnectoidType.TRAVELLER_ACCESS;
            }
            case NONE: {
                return ConnectoidType.NONE;
            }
        }
        LOGGER.warning(String.format("unknown connectoid type %s found, changed to `unknown`", xmlConnectoidType.value()));
        return ConnectoidType.UNKNOWN;
    }

    private static void populateZoneGeometry(Zone zone, PolygonType xmlPolygon, LineStringType xmlLineString) throws PlanItException {
        Geometry geometry = null;
        if (xmlPolygon != null) {
            if (xmlPolygon.getExterior() == null) {
                LOGGER.warning(String.format("zones only support polygon geometries with an outer exterior, however this is missing for zone %s", zone.getXmlId()));
            } else if (xmlPolygon.getExterior().getValue().getRing() == null) {
                LOGGER.warning(String.format("expected ring element missing within polygon exterior element for zone %s", zone.getXmlId()));
            } else if (xmlPolygon.getExterior().getValue().getRing().getValue() instanceof LinearRingType) {
                LinearRingType xmlLinearRing = (LinearRingType)xmlPolygon.getExterior().getValue().getRing().getValue();
                geometry = PlanitJtsUtils.create2DPolygon(xmlLinearRing.getPosList().getValue());
            } else {
                LOGGER.warning(String.format("expected linear ring within polygon exterior element for zone %s, but different ring type was encountered", zone.getXmlId()));
            }
        } else if (xmlLineString != null) {
            if (xmlLineString.getCoordinates() != null) {
                CoordinatesType ct = xmlLineString.getCoordinates();
                geometry = PlanitJtsUtils.createLineStringFromCsvString(ct.getValue(), ct.getTs(), ct.getCs());
            } else if (xmlLineString.getPosList() != null) {
                geometry = PlanitJtsUtils.createLineString(xmlLineString.getPosList().getValue());
            }
        }
        zone.setGeometry(geometry);
    }

    private static void populateZoneGeometry(Zone zone, PolygonType xmlPolygon) throws PlanItException {
        PlanitZoningReader.populateZoneGeometry(zone, xmlPolygon, null);
    }

    private static void populateConnectoidToZoneLengths(Connectoid connectoid, Connectoidtype xmlConnectoid, Point position, PlanitJtsCrsUtils jtsUtils) throws PlanItException {
        block5: {
            Double connectoidLength;
            block4: {
                connectoidLength = null;
                if (xmlConnectoid.getLength() == null) break block4;
                connectoidLength = (double)xmlConnectoid.getLength();
                if (connectoid.getNumberOfAccessZones() > 1L) {
                    LOGGER.fine(String.format("connectoid %s has explicitly set length, yet has multiple access zones that now all receive equal lengths", connectoid.getXmlId()));
                }
                for (Zone accessZone : connectoid) {
                    connectoid.setLength(accessZone, connectoidLength);
                }
                break block5;
            }
            if (position == null) break block5;
            for (Zone accessZone : connectoid) {
                if (accessZone.getCentroid() == null || accessZone.getCentroid().getPosition() != null) {
                    LOGGER.warning(String.format("access zone of connectoid %s is null", connectoid.getXmlId()));
                    continue;
                }
                if (accessZone.getCentroid().getPosition() == null) continue;
                connectoidLength = jtsUtils.getDistanceInKilometres(accessZone.getCentroid().getPosition(), position);
                connectoid.setLength(accessZone, connectoidLength);
            }
        }
    }

    private void parseBaseZone(Zone zone, String xmlId, String externalId, String name, XMLElementCentroid xmlCentroid) throws PlanItException {
        if (StringUtils.isNullOrBlank(xmlId)) {
            throw new PlanItException("Zone cannot be parsed, its (XML) id is not set");
        }
        zone.setXmlId(xmlId);
        this.registerBySourceId(Zone.class, zone);
        if (externalId != null && !externalId.isBlank()) {
            zone.setExternalId(externalId);
        }
        if (!StringUtils.isNullOrBlank(name)) {
            zone.setName(name);
        }
        Centroid centroid = zone.getCentroid();
        if (xmlCentroid != null) {
            if (xmlCentroid.getName() != null) {
                centroid.setName(xmlCentroid.getName());
            }
            if (xmlCentroid.getPoint() != null) {
                List<Double> value = xmlCentroid.getPoint().getPos().getValue();
                centroid.setPosition(PlanitJtsUtils.createPoint(value.get(0), value.get(1)));
            }
        }
    }

    private Connectoid parseBaseConnectoid(Connectoidtype xmlConnectoid) throws PlanItException {
        ExternalIdAble theConnectoid = null;
        String xmlId = null;
        if (StringUtils.isNullOrBlank(xmlConnectoid.getId())) {
            LOGGER.severe("DISCARd: Parsed connectoid has no (XML) id");
            return null;
        }
        xmlId = xmlConnectoid.getId();
        Node accessNode = null;
        if (xmlConnectoid instanceof Odconnectoid) {
            accessNode = this.getBySourceId(Node.class, ((Odconnectoid)xmlConnectoid).getNoderef());
            if (accessNode == null) {
                throw new PlanItException(String.format("provided accessNode XML id %s is invalid given available nodes in network when parsing transfer connectoid %s", ((Odconnectoid)xmlConnectoid).getNoderef(), xmlConnectoid.getId()));
            }
            theConnectoid = this.zoning.odConnectoids.getFactory().registerNew(accessNode);
        } else if (xmlConnectoid instanceof XMLElementTransferZoneAccess.XMLElementTransferConnectoid) {
            XMLElementTransferZoneAccess.XMLElementTransferConnectoid xmlTransferConnectoid = (XMLElementTransferZoneAccess.XMLElementTransferConnectoid)xmlConnectoid;
            String xmlLinkSegmentRef = xmlTransferConnectoid.getLsref();
            MacroscopicLinkSegment linkSegment = this.getBySourceId(MacroscopicLinkSegment.class, xmlLinkSegmentRef);
            if (linkSegment == null) {
                throw new PlanItException(String.format("provided link segment XML id %s is invalid given available link segments in network when parsing transfer connectoid %s", xmlLinkSegmentRef, xmlConnectoid.getId()));
            }
            theConnectoid = this.zoning.transferConnectoids.getFactory().registerNew(linkSegment);
            if (xmlTransferConnectoid.getLoc() != null && xmlTransferConnectoid.getLoc() == Connectoidnodelocationtype.UPSTREAM) {
                ((DirectedConnectoid)theConnectoid).setNodeAccessDownstream(false);
            }
        }
        theConnectoid.setXmlId(xmlId);
        if (xmlConnectoid.getExternalid() != null && !xmlConnectoid.getExternalid().isBlank()) {
            theConnectoid.setExternalId(xmlConnectoid.getExternalid());
        }
        if (xmlConnectoid.getName() != null && !xmlConnectoid.getName().isBlank()) {
            theConnectoid.setName(xmlConnectoid.getName());
        }
        theConnectoid.setType(PlanitZoningReader.parseConnectoidType(xmlConnectoid.getType()));
        return theConnectoid;
    }

    private TransferZoneGroup parseTransferGroup(XMLElementTransferGroup xmlTransferGroup) {
        TransferZoneGroup transferGroup = this.zoning.transferZoneGroups.getFactory().registerNew();
        transferGroup.setXmlId(xmlTransferGroup.getId());
        if (xmlTransferGroup.getExternalid() != null && !xmlTransferGroup.getExternalid().isBlank()) {
            transferGroup.setExternalId(xmlTransferGroup.getExternalid());
        }
        if (xmlTransferGroup.getName() != null && !xmlTransferGroup.getName().isBlank()) {
            transferGroup.setName(xmlTransferGroup.getName());
        }
        String[] transferZoneRefsByXmlId = StringUtils.splitByAnythingExceptAlphaNumeric(xmlTransferGroup.getTzrefs());
        for (int index = 0; index < transferZoneRefsByXmlId.length; ++index) {
            String transferZoneXmlId = transferZoneRefsByXmlId[index];
            TransferZone transferZone = (TransferZone)this.getBySourceId(Zone.class, transferZoneXmlId);
            if (transferZone == null) {
                LOGGER.warning(String.format("Transfer zone group %s (id:%d) references transfer zone %s that is not available in the parser, transfer zone ignored", transferGroup.getXmlId(), transferGroup.getId(), transferZoneRefsByXmlId));
            }
            transferGroup.addTransferZone(transferZone);
        }
        return transferGroup;
    }

    private void populateTransferZones(XMLElementMacroscopicZoning.XMLElementIntermodal xmlInterModal) throws PlanItException {
        if (((Intermodaltype)xmlInterModal.getValue()).getTransferzones() == null) {
            return;
        }
        XMLElementTransferZones xmlTransferZones = ((Intermodaltype)xmlInterModal.getValue()).getTransferzones();
        List<XMLElementTransferZones.XMLElementTransferZone> xmlTransferZonesList = xmlTransferZones.getZone();
        for (XMLElementTransferZones.XMLElementTransferZone xmlTransferzone : xmlTransferZonesList) {
            TransferZone transferZone = this.zoning.transferZones.getFactory().registerNew();
            this.parseBaseZone(transferZone, xmlTransferzone.getId(), xmlTransferzone.getExternalid(), xmlTransferzone.getName(), xmlTransferzone.getCentroid());
            if (xmlTransferzone.getType() != null) {
                transferZone.setType(PlanitZoningReader.parseTransferZoneType(xmlTransferzone.getType()));
            }
            PlanitZoningReader.populateZoneGeometry(transferZone, xmlTransferzone.getPolygon(), xmlTransferzone.getLineString());
        }
    }

    private void populateTransferZoneAccess(Modes modes, XMLElementMacroscopicZoning.XMLElementIntermodal xmlInterModal) throws PlanItException {
        if (((Intermodaltype)xmlInterModal.getValue()).getTransferzoneaccess() == null) {
            return;
        }
        XMLElementTransferZoneAccess xmlTransferZoneAccess = ((Intermodaltype)xmlInterModal.getValue()).getTransferzoneaccess();
        HashMap modesByXmlId = new HashMap();
        modes.forEach(mode -> modesByXmlId.put(mode.getXmlId(), mode));
        List<XMLElementTransferZoneAccess.XMLElementTransferConnectoid> xmlTransferConnectoids = xmlTransferZoneAccess.getConnectoid();
        for (XMLElementTransferZoneAccess.XMLElementTransferConnectoid xmlTransferConnectoid : xmlTransferConnectoids) {
            DirectedConnectoid connectoid = (DirectedConnectoid)this.parseBaseConnectoid(xmlTransferConnectoid);
            String modesRef = xmlTransferConnectoid.getModes();
            HashSet<Mode> allowedModes = null;
            boolean implicitAllModesAllowed = true;
            if (!StringUtils.isNullOrBlank(modesRef)) {
                implicitAllModesAllowed = false;
                allowedModes = new HashSet<Mode>();
                for (String xmlModeRef : List.of(modesRef.split(","))) {
                    Mode mode2 = (Mode)modesByXmlId.get(xmlModeRef);
                    if (mode2 == null) {
                        LOGGER.warning(String.format("invalid mode %s referenced by transfer connectoid %s", xmlModeRef, connectoid.getXmlId()));
                        continue;
                    }
                    allowedModes.add(mode2);
                }
            }
            String TransferZoneRefs = xmlTransferConnectoid.getTzrefs();
            for (String xmlAccessZoneRef : List.of(TransferZoneRefs.split(","))) {
                Zone accessZone = this.getBySourceId(Zone.class, xmlAccessZoneRef);
                if (accessZone == null) {
                    LOGGER.warning(String.format("invalid transfer zone %s referenced by transfer connectoid %s", xmlAccessZoneRef, connectoid.getXmlId()));
                    continue;
                }
                connectoid.addAccessZone(accessZone);
                if (implicitAllModesAllowed) continue;
                allowedModes.forEach(allowedMode -> connectoid.addAllowedMode(accessZone, (Mode)allowedMode));
            }
            PlanitZoningReader.populateConnectoidToZoneLengths(connectoid, xmlTransferConnectoid, connectoid.getAccessNode().getPosition(), this.jtsUtils);
            this.registerBySourceId(Connectoid.class, connectoid);
        }
    }

    private void populateTransferZoneGroups(XMLElementMacroscopicZoning.XMLElementIntermodal xmlInterModal) {
        if (((Intermodaltype)xmlInterModal.getValue()).getTransferzonegroups() == null) {
            return;
        }
        XMLElementTransferZoneGroups xmlTransferZoneGroups = ((Intermodaltype)xmlInterModal.getValue()).getTransferzonegroups();
        if (xmlTransferZoneGroups.getTransfergroup().isEmpty()) {
            LOGGER.warning("Dangling transfer zone groups element, no transfer zone groups can be parsed");
            return;
        }
        List<XMLElementTransferGroup> xmlTransferGroups = xmlTransferZoneGroups.getTransfergroup();
        for (XMLElementTransferGroup xmlTransferGroup : xmlTransferGroups) {
            this.parseTransferGroup(xmlTransferGroup);
        }
    }

    protected void populateIntermodal(Modes modes) throws PlanItException {
        if (this.xmlParser.getXmlRootElement().getIntermodal() == null) {
            return;
        }
        XMLElementMacroscopicZoning.XMLElementIntermodal xmlInterModal = this.xmlParser.getXmlRootElement().getIntermodal();
        this.populateTransferZones(xmlInterModal);
        this.populateTransferZoneAccess(modes, xmlInterModal);
        this.populateTransferZoneGroups(xmlInterModal);
    }

    private void parseCoordinateReferenceSystem(MacroscopicNetwork macroscopicNetwork) throws PlanItException {
        CoordinateReferenceSystem crs = macroscopicNetwork.getCoordinateReferenceSystem();
        if (this.xmlParser.getXmlRootElement().getSrsname() != null && !this.xmlParser.getXmlRootElement().getSrsname().isBlank()) {
            crs = PlanitXmlJaxbParser.createPlanitCrs(this.xmlParser.getXmlRootElement().getSrsname());
        }
        if (!crs.equals(macroscopicNetwork.getCoordinateReferenceSystem())) {
            LOGGER.severe(String.format("Zoning crs (%s) and network crs (%s) are not compatible", crs.getName(), macroscopicNetwork.getCoordinateReferenceSystem().getName()));
        }
        this.jtsUtils = new PlanitJtsCrsUtils(crs);
    }

    protected void setZoning(Zoning zoning) {
        this.zoning = zoning;
    }

    protected void setNetwork(TransportLayerNetwork<?, ?> network) {
        this.network = network;
    }

    protected void populateODZones() throws PlanItException {
        if (this.xmlParser.getXmlRootElement().getZones() == null) {
            LOGGER.info("No Od zones found in zoning, skip");
            return;
        }
        for (XMLElementZones.Zone xmlZone : this.xmlParser.getXmlRootElement().getZones().getZone()) {
            OdZone zone = this.zoning.odZones.getFactory().registerNew();
            this.parseBaseZone(zone, xmlZone.getId(), xmlZone.getExternalid(), xmlZone.getId(), xmlZone.getCentroid());
            PlanitZoningReader.populateZoneGeometry(zone, xmlZone.getPolygon());
            List<XMLElementConnectoid> xmlConnectoids = xmlZone.getConnectoids().getConnectoid();
            for (XMLElementConnectoid xmlConnectoid : xmlConnectoids) {
                Odconnectoid xmlOdConnectoid = (Odconnectoid)xmlConnectoid.getValue();
                UndirectedConnectoid connectoid = (UndirectedConnectoid)this.parseBaseConnectoid(xmlOdConnectoid);
                connectoid.addAccessZone(zone);
                PlanitZoningReader.populateConnectoidToZoneLengths(connectoid, xmlOdConnectoid, connectoid.getAccessVertex().getPosition(), this.jtsUtils);
            }
        }
    }

    protected PlanitZoningReader(PlanitZoningReaderSettings settings, TransportLayerNetwork<?, ?> network, Zoning zoning) {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicZoning>>(XMLElementMacroscopicZoning.class);
        this.settings = settings;
        this.setZoning(zoning);
        this.setNetwork(network);
    }

    protected PlanitZoningReader(String pathDirectory, String xmlFileExtension, TransportLayerNetwork<?, ?> network, Zoning zoning) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementMacroscopicZoning>>(XMLElementMacroscopicZoning.class);
        this.settings = new PlanitZoningReaderSettings(pathDirectory, xmlFileExtension);
        this.setZoning(zoning);
        this.setNetwork(network);
    }

    protected PlanitZoningReader(XMLElementMacroscopicZoning xmlMacroscopicZoning, TransportLayerNetwork<?, ?> network, Zoning zoning) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<XMLElementMacroscopicZoning>(xmlMacroscopicZoning);
        this.settings = new PlanitZoningReaderSettings();
        this.setZoning(zoning);
        this.setNetwork(network);
    }

    @Override
    public Zoning read() throws PlanItException {
        if (!(this.network instanceof MacroscopicNetwork)) {
            throw new PlanItException("unable to read zoning, network is not compatible with Macroscopic network");
        }
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)this.network;
        this.initialiseXmlIdTrackers();
        this.initialiseParentNetworkXmlIdTrackers(macroscopicNetwork);
        try {
            this.xmlParser.initialiseAndParseXmlRootElement(this.getSettings().getInputDirectory(), this.getSettings().getXmlFileExtension());
            PlanItException.throwIfNull(this.xmlParser.getXmlRootElement(), "No valid PLANit XML zoning could be parsed into memory, abort");
            String zoningXmlId = this.xmlParser.getXmlRootElement().getId();
            if (StringUtils.isNullOrBlank(zoningXmlId)) {
                LOGGER.warning(String.format("Zoning has no XML id defined, adopting internally generated id %d instead", this.zoning.getId()));
                zoningXmlId = String.valueOf(this.zoning.getId());
            }
            this.zoning.setXmlId(zoningXmlId);
            this.parseCoordinateReferenceSystem(macroscopicNetwork);
            this.populateODZones();
            this.populateIntermodal(macroscopicNetwork.getModes());
            this.xmlParser.clearXmlContent();
        }
        catch (PlanItException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException("Error when populating zoning in PLANitIO", e);
        }
        return this.zoning;
    }

    @Override
    public PlanitZoningReaderSettings getSettings() {
        return this.settings;
    }

    @Override
    public void reset() {
        this.getSettings().reset();
    }
}

