/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.io.converter.service;

import java.time.LocalTime;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.datatype.XMLGregorianCalendar;
import org.goplanit.converter.BaseReaderImpl;
import org.goplanit.converter.service.RoutedServicesReader;
import org.goplanit.io.converter.service.PlanitRoutedServicesReaderSettings;
import org.goplanit.io.xml.util.EnumConversionUtil;
import org.goplanit.io.xml.util.PlanitXmlJaxbParser;
import org.goplanit.network.ServiceNetwork;
import org.goplanit.service.routed.RoutedModeServices;
import org.goplanit.service.routed.RoutedService;
import org.goplanit.service.routed.RoutedServiceTripInfo;
import org.goplanit.service.routed.RoutedServices;
import org.goplanit.service.routed.RoutedServicesLayer;
import org.goplanit.service.routed.RoutedTripDeparture;
import org.goplanit.service.routed.RoutedTripDepartures;
import org.goplanit.service.routed.RoutedTripFrequency;
import org.goplanit.service.routed.RoutedTripSchedule;
import org.goplanit.service.routed.RoutedTripScheduleImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.ExternalIdAble;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.CharacterUtils;
import org.goplanit.utils.misc.StringUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.ServiceNetworkLayer;
import org.goplanit.utils.network.layer.service.ServiceLegSegment;
import org.goplanit.utils.network.layers.ServiceNetworkLayers;
import org.goplanit.utils.unit.Unit;
import org.goplanit.xml.generated.TimeUnit;
import org.goplanit.xml.generated.XMLElementDepartures;
import org.goplanit.xml.generated.XMLElementRelativeTimings;
import org.goplanit.xml.generated.XMLElementRoutedServices;
import org.goplanit.xml.generated.XMLElementRoutedServicesLayer;
import org.goplanit.xml.generated.XMLElementRoutedTrip;
import org.goplanit.xml.generated.XMLElementRoutedTrips;
import org.goplanit.xml.generated.XMLElementService;
import org.goplanit.xml.generated.XMLElementServices;

public class PlanitRoutedServicesReader
extends BaseReaderImpl<RoutedServices>
implements RoutedServicesReader {
    private static final Logger LOGGER = Logger.getLogger(PlanitRoutedServicesReader.class.getCanonicalName());
    private final PlanitRoutedServicesReaderSettings settings;
    private final PlanitXmlJaxbParser<XMLElementRoutedServices> xmlParser;
    private final RoutedServices routedServices;
    public static final String ROUTED_SERVICES_XSD_FILE = "https://trafficplanit.github.io/PLANitManual/xsd/routedservicesinput.xsd";

    private void initialiseParentXmlIdTrackers(ServiceNetwork network) {
        this.initialiseSourceIdMap(ServiceLegSegment.class, ExternalIdAble::getXmlId);
        ((ServiceNetworkLayers)network.getTransportLayers()).forEach(layer -> this.getSourceIdContainer(ServiceLegSegment.class).addAll(layer.getLegSegments()));
    }

    private void parseScheduleBasedTrip(XMLElementRoutedTrip.Schedule xmlSchedule, RoutedTripSchedule routedTrip, RoutedServicesLayer routedServicesLayer) throws PlanItException {
        XMLElementDepartures xmlDepartures = xmlSchedule.getDepartures();
        if (xmlDepartures == null || xmlDepartures.getDeparture() == null || xmlDepartures.getDeparture().isEmpty()) {
            LOGGER.warning(String.format("IGNORE: Schedule based trip %s has no departures defined", routedTrip.getXmlId()));
            return;
        }
        RoutedTripDepartures routedTripDepartures = routedTrip.getDepartures();
        for (XMLElementDepartures.Departure xmlDeparture : xmlDepartures.getDeparture()) {
            String xmlId = xmlDeparture.getId();
            if (StringUtils.isNullOrBlank(xmlId)) {
                LOGGER.warning(String.format("IGNORE: A routed trip %s has no XML id defined for a departure, departure removed", routedTrip.getXmlId()));
                continue;
            }
            XMLGregorianCalendar xmlDepartureTime = xmlDeparture.getTime();
            if (xmlDepartureTime == null) {
                LOGGER.warning(String.format("IGNORE: A routed trip %s has no departure time defined for its departure element, departure removed", routedTrip.getXmlId()));
                continue;
            }
            LocalTime departureTime = xmlDepartureTime.toGregorianCalendar().toZonedDateTime().toLocalTime();
            RoutedTripDeparture departure = routedTripDepartures.getFactory().registerNew(departureTime);
            departure.setXmlId(xmlId);
            if (StringUtils.isNullOrBlank(xmlDeparture.getExternalid())) continue;
            departure.setExternalId(xmlDeparture.getExternalid());
        }
        XMLElementRelativeTimings xmlRelativeLegTimings = xmlSchedule.getReltimings();
        if (xmlRelativeLegTimings == null || xmlRelativeLegTimings.getLeg() == null || xmlRelativeLegTimings.getLeg().isEmpty()) {
            LOGGER.warning(String.format("IGNORE: Schedule based trip %s has no relative timings (reltimings=) for its legs defined", routedTrip.getXmlId()));
            return;
        }
        LocalTime defaultDwellTime = LocalTime.MIN;
        if (xmlRelativeLegTimings.getDwelltime() != null) {
            defaultDwellTime = xmlRelativeLegTimings.getDwelltime().toGregorianCalendar().toZonedDateTime().toLocalTime();
        }
        ((RoutedTripScheduleImpl)routedTrip).setDefaultDwellTime(defaultDwellTime);
        boolean validTimings = true;
        for (XMLElementRelativeTimings.Leg xmlRelativeTimingLeg : xmlRelativeLegTimings.getLeg()) {
            String xmlLegSegmentRef = xmlRelativeTimingLeg.getLsref();
            if (StringUtils.isNullOrBlank(xmlLegSegmentRef)) {
                LOGGER.warning(String.format("IGNORE: Schedule based trip %s has relative timing for leg (segment) without reference to service leg segment, attribute lsref= missing", routedTrip.getXmlId()));
                validTimings = false;
                break;
            }
            ServiceLegSegment parentLegSegment = this.getBySourceId(ServiceLegSegment.class, xmlLegSegmentRef);
            if (parentLegSegment == null) {
                LOGGER.warning(String.format("IGNORE: Unavailable leg segment referenced lsref=%s in scheduled trip %s leg timing ", xmlLegSegmentRef, routedTrip.getXmlId()));
                validTimings = false;
                break;
            }
            xmlRelativeTimingLeg.getDuration();
            XMLGregorianCalendar xmlScheduledLegDuration = xmlRelativeTimingLeg.getDuration();
            if (xmlScheduledLegDuration == null) {
                LOGGER.warning(String.format("IGNORE: A scheduled trip %s its directional leg timing %s has no valid duration", routedTrip.getXmlId(), parentLegSegment.getXmlId()));
                validTimings = false;
                break;
            }
            LocalTime duration = xmlScheduledLegDuration.toGregorianCalendar().toZonedDateTime().toLocalTime();
            XMLGregorianCalendar xmlScheduledDwellTime = xmlRelativeTimingLeg.getDwelltime();
            LocalTime localDwellTime = ((RoutedTripScheduleImpl)routedTrip).getDefaultDwellTime();
            if (xmlScheduledDwellTime != null) {
                localDwellTime = xmlScheduledDwellTime.toGregorianCalendar().toZonedDateTime().toLocalTime();
            }
            routedTrip.addRelativeLegSegmentTiming(parentLegSegment, duration, localDwellTime);
        }
        if (!validTimings) {
            routedTrip.clearRelativeLegTimings();
        }
    }

    private void parseFrequencyBasedTrip(XMLElementRoutedTrip.Frequency xmlFrequency, RoutedTripFrequency routedTrip, RoutedServicesLayer routedServicesLayer) throws PlanItException {
        String xmlLegRefs = xmlFrequency.getLsrefs();
        if (StringUtils.isNullOrBlank(xmlLegRefs)) {
            LOGGER.warning(String.format("IGNORE: Frequency based trip %s has no references to underlying service leg segments", routedTrip.getXmlId()));
            return;
        }
        String[] xmlLegRefsArray = xmlLegRefs.split(CharacterUtils.COMMA.toString());
        for (int index = 0; index < xmlLegRefsArray.length; ++index) {
            ServiceLegSegment parentLegSegment = this.getBySourceId(ServiceLegSegment.class, xmlLegRefsArray[index]);
            if (parentLegSegment == null) {
                LOGGER.warning(String.format("IGNORE: Unavailable directed leg referenced %s in trip %s", xmlLegRefsArray[index], routedTrip.getXmlId()));
                routedTrip.clearLegs();
            }
            routedTrip.addLegSegment(parentLegSegment);
        }
        TimeUnit xmlTimeUnit = xmlFrequency.getUnit();
        PlanItException.throwIfNull((Object)xmlTimeUnit, "Unavailable time unit for frequency in trip %s", routedTrip.getXmlId());
        org.goplanit.utils.unit.TimeUnit planitFrequencyTimeUnit = EnumConversionUtil.xmlToPlanit(xmlTimeUnit);
        double xmlNonNormalisedFrequency = xmlFrequency.getValue();
        if (xmlNonNormalisedFrequency <= 0.0) {
            LOGGER.warning(String.format("IGNORE: Invalid or absent frequency for trip %s, please specify a valid frequency (>0)", routedTrip.getXmlId()));
            return;
        }
        double frequencyPerHour = Unit.HOUR.convertTo(planitFrequencyTimeUnit, xmlNonNormalisedFrequency);
        routedTrip.setFrequencyPerHour(frequencyPerHour);
    }

    private void parseRoutedTripInfo(XMLElementRoutedTrip xmlTrip, RoutedService routedService, RoutedServicesLayer routedServicesLayer) throws PlanItException {
        RoutedServiceTripInfo tripInfo = routedService.getTripInfo();
        String xmlId = xmlTrip.getId();
        if (StringUtils.isNullOrBlank(xmlId)) {
            LOGGER.warning(String.format("IGNORE: A trip on routed service (%s) has no XML id defined", routedService.getXmlId()));
            return;
        }
        ExternalIdAble routedTrip = null;
        if (xmlTrip.getFrequency() != null) {
            routedTrip = (ExternalIdAble)tripInfo.getFrequencyBasedTrips().getFactory().registerNew();
            routedTrip.setXmlId(xmlId);
            this.parseFrequencyBasedTrip(xmlTrip.getFrequency(), (RoutedTripFrequency)routedTrip, routedServicesLayer);
        } else if (xmlTrip.getSchedule() != null) {
            routedTrip = tripInfo.getScheduleBasedTrips().getFactory().registerNew();
            routedTrip.setXmlId(xmlId);
            this.parseScheduleBasedTrip(xmlTrip.getSchedule(), (RoutedTripSchedule)routedTrip, routedServicesLayer);
        } else {
            LOGGER.warning(String.format("IGNORE: Trip (%s) on routed service (%s) has neither schedule nor frequency defined", xmlId, routedService.getXmlId()));
            return;
        }
        if (!StringUtils.isNullOrBlank(xmlTrip.getExternalid())) {
            routedTrip.setExternalId(xmlTrip.getExternalid());
        }
    }

    private void parseRoutedModeServicesWithinLayer(XMLElementServices xmlServices, RoutedModeServices servicesByMode, RoutedServicesLayer routedServicesLayer) throws PlanItException {
        List<XMLElementService> xmlServicesList = xmlServices.getService();
        if (xmlServicesList == null || xmlServicesList.isEmpty()) {
            LOGGER.severe(String.format("IGNORE: No routed services within mode (%s) specific services defined", servicesByMode.getMode().getXmlId()));
            return;
        }
        for (XMLElementService xmlRoutedService : xmlServicesList) {
            XMLElementRoutedTrips xmlTripsList;
            String xmlId = xmlRoutedService.getId();
            if (StringUtils.isNullOrBlank(xmlId)) {
                LOGGER.warning(String.format("IGNORE: A routed Service for mode %s has no XML id defined", servicesByMode.getMode().getXmlId()));
                continue;
            }
            RoutedService routedService = servicesByMode.getFactory().registerNew();
            routedService.setXmlId(xmlId);
            if (!StringUtils.isNullOrBlank(xmlRoutedService.getExternalid())) {
                routedService.setExternalId(xmlRoutedService.getExternalid());
            }
            if (!StringUtils.isNullOrBlank(xmlRoutedService.getName())) {
                routedService.setName(xmlRoutedService.getName());
            }
            if (!StringUtils.isNullOrBlank(xmlRoutedService.getNamedescription())) {
                routedService.setNameDescription(xmlRoutedService.getNamedescription());
            }
            if (!StringUtils.isNullOrBlank(xmlRoutedService.getServicedescription())) {
                routedService.setServiceDescription(xmlRoutedService.getServicedescription());
            }
            if ((xmlTripsList = xmlRoutedService.getTrips()) == null) {
                LOGGER.warning(String.format("Routed service %s has no trips defined", routedService.getXmlId()));
                return;
            }
            for (XMLElementRoutedTrip xmlTrip : xmlTripsList.getTrip()) {
                this.parseRoutedTripInfo(xmlTrip, routedService, routedServicesLayer);
            }
        }
    }

    private void parseRoutedServicesWithinLayer(XMLElementRoutedServicesLayer xmlRoutedServicesLayer, RoutedServicesLayer routedServicesLayer) throws PlanItException {
        List<XMLElementServices> xmlModeServicesList = xmlRoutedServicesLayer.getServices();
        if (xmlModeServicesList == null || xmlModeServicesList.isEmpty()) {
            LOGGER.severe(String.format("IGNORE: Routed services layer has no services defined", new Object[0]));
            return;
        }
        for (XMLElementServices xmlModeServices : xmlModeServicesList) {
            String modeXmlRef = xmlModeServices.getModeref();
            if (StringUtils.isNullOrBlank(modeXmlRef)) {
                if (routedServicesLayer.getParentLayer().getSupportedModes().size() != 1) {
                    LOGGER.severe(String.format("IGNORE: routed services layer %s services element has no supported mode specified", routedServicesLayer.getXmlId()));
                    return;
                }
                modeXmlRef = routedServicesLayer.getParentLayer().getFirstSupportedMode().getXmlId();
                LOGGER.info(String.format("routed services layer %s has no explicit supported mode specified, using only available mode %s instead", routedServicesLayer.getXmlId(), modeXmlRef));
            }
            String finalModeXmlRef = modeXmlRef;
            Mode supportedMode = routedServicesLayer.getParentLayer().getParentNetworkLayer().getSupportedModes().stream().filter(mode -> finalModeXmlRef.equals(mode.getXmlId())).findFirst().orElseThrow(() -> new PlanItException("Invalid mode %s referenced by routed service layer %s", finalModeXmlRef, routedServicesLayer.getXmlId()));
            if (!routedServicesLayer.getParentLayer().supports(supportedMode)) {
                LOGGER.severe(String.format("DISCARD: routed services defines a mode %s that is not supported on the parent service layer %s of the routed services", finalModeXmlRef, routedServicesLayer.getParentLayer().getXmlId()));
                return;
            }
            RoutedModeServices servicesByMode = routedServicesLayer.getServicesByMode(supportedMode);
            this.parseRoutedModeServicesWithinLayer(xmlModeServices, servicesByMode, routedServicesLayer);
        }
    }

    private void parseRoutedServicesLayer(XMLElementRoutedServicesLayer xmlRoutedServicesLayer) throws PlanItException {
        String layerXmlId = xmlRoutedServicesLayer.getId();
        if (StringUtils.isNullOrBlank(layerXmlId)) {
            LOGGER.severe(String.format("IGNORE: Routed services service layer has no XML id", new Object[0]));
            return;
        }
        String xmlParentServiceNetworkLayerRef = xmlRoutedServicesLayer.getServicelayerref();
        if (StringUtils.isNullOrBlank(xmlParentServiceNetworkLayerRef)) {
            LOGGER.severe(String.format("IGNORE: routed services service layer %s has no reference to parent service network layer", layerXmlId));
            return;
        }
        ServiceNetworkLayer networkLayer = (ServiceNetworkLayer)((ServiceNetworkLayers)this.routedServices.getParentNetwork().getTransportLayers()).getByXmlId(xmlParentServiceNetworkLayerRef);
        if (networkLayer == null) {
            LOGGER.severe(String.format("IGNORE: routed services layer %s references parent service network layer %s that is not available (yet)", layerXmlId, xmlParentServiceNetworkLayerRef));
            return;
        }
        RoutedServicesLayer routedServicesLayer = this.routedServices.getLayers().getFactory().registerNew(networkLayer);
        routedServicesLayer.setXmlId(layerXmlId);
        if (!StringUtils.isNullOrBlank(xmlRoutedServicesLayer.getExternalid())) {
            routedServicesLayer.setExternalId(xmlRoutedServicesLayer.getExternalid());
        }
        this.parseRoutedServicesWithinLayer(xmlRoutedServicesLayer, routedServicesLayer);
    }

    private void parseRoutedServiceLayers() throws PlanItException {
        XMLElementRoutedServices.Servicelayers xmlServiceLayers = this.xmlParser.getXmlRootElement().getServicelayers();
        if (xmlServiceLayers == null) {
            LOGGER.warning(String.format("IGNORE: No service layers present in routed services file", new Object[0]));
            return;
        }
        String parentNetworkXmlId = xmlServiceLayers.getServicenetworkref();
        PlanItException.throwIfNull(this.routedServices.getParentNetwork(), "No parent service network available on routed services %s memory model", this.routedServices.getXmlId());
        if (StringUtils.isNullOrBlank(parentNetworkXmlId) || !parentNetworkXmlId.equals(this.routedServices.getParentNetwork().getXmlId())) {
            LOGGER.severe(String.format("IGNORE: routed services service layers different (or no) reference to parent service network than memory model (%s vs %s)", parentNetworkXmlId, this.routedServices.getParentNetwork().getXmlId()));
        }
        List<XMLElementRoutedServicesLayer> xmlServiceLayersList = xmlServiceLayers.getServicelayer();
        for (XMLElementRoutedServicesLayer xmlServiceLayer : xmlServiceLayersList) {
            this.parseRoutedServicesLayer(xmlServiceLayer);
        }
    }

    protected PlanitRoutedServicesReader(IdGroupingToken idToken, PlanitRoutedServicesReaderSettings settings) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementRoutedServices>>(XMLElementRoutedServices.class);
        this.settings = settings;
        this.routedServices = new RoutedServices(idToken, settings.getParentNetwork());
    }

    protected PlanitRoutedServicesReader(PlanitRoutedServicesReaderSettings settings, RoutedServices routedServices) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementRoutedServices>>(XMLElementRoutedServices.class);
        this.settings = settings;
        this.routedServices = routedServices;
        if (!settings.getParentNetwork().equals(routedServices.getParentNetwork())) {
            LOGGER.severe("parent network in settings instance does not match the parent network in the provided routed services instance for the PLANit routed services reader");
        }
    }

    protected PlanitRoutedServicesReader(XMLElementRoutedServices populatedXmlRawRoutedServices, RoutedServices routedServices) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<XMLElementRoutedServices>(populatedXmlRawRoutedServices);
        this.settings = new PlanitRoutedServicesReaderSettings(routedServices.getParentNetwork());
        this.routedServices = routedServices;
    }

    protected PlanitRoutedServicesReader(String inputPathDirectory, String xmlFileExtension, RoutedServices routedServices) throws PlanItException {
        this.xmlParser = new PlanitXmlJaxbParser<Class<XMLElementRoutedServices>>(XMLElementRoutedServices.class);
        this.settings = new PlanitRoutedServicesReaderSettings(routedServices.getParentNetwork(), inputPathDirectory, xmlFileExtension);
        this.routedServices = routedServices;
    }

    @Override
    public RoutedServices read() throws PlanItException {
        this.xmlParser.initialiseAndParseXmlRootElement(this.getSettings().getInputDirectory(), this.getSettings().getXmlFileExtension());
        PlanItException.throwIfNull(this.xmlParser.getXmlRootElement(), "No valid PLANit XML routed services could be parsed into memory, abort");
        String xmlId = this.xmlParser.getXmlRootElement().getId();
        if (StringUtils.isNullOrBlank(xmlId)) {
            LOGGER.warning(String.format("Routed services has no XML id defined, adopting internally generated id %d instead", this.routedServices.getId()));
            xmlId = String.valueOf(this.routedServices.getId());
        }
        this.routedServices.setXmlId(xmlId);
        try {
            this.initialiseParentXmlIdTrackers(this.getSettings().getParentNetwork());
            this.parseRoutedServiceLayers();
            this.xmlParser.clearXmlContent();
        }
        catch (PlanItException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new PlanItException(String.format("Error while populating routed services %s in PLANitIO", this.routedServices.getXmlId()), e);
        }
        return this.routedServices;
    }

    @Override
    public PlanitRoutedServicesReaderSettings getSettings() {
        return this.settings;
    }

    @Override
    public void reset() {
        this.settings.reset();
    }
}

