/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.directed;

import java.util.logging.Logger;
import org.goplanit.graph.GraphEntityImpl;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedEdge;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;

public class EdgeSegmentImpl
extends GraphEntityImpl
implements EdgeSegment {
    private static final long serialVersionUID = -6521489123632246969L;
    private static final Logger LOGGER = Logger.getLogger(EdgeSegmentImpl.class.getCanonicalName());
    private DirectedVertex upstreamVertex;
    private DirectedVertex downstreamVertex;
    private DirectedEdge parentEdge;

    protected EdgeSegmentImpl(IdGroupingToken groupId, DirectedEdge parentEdge, boolean directionAB) {
        this(groupId, directionAB);
        this.setParent(parentEdge);
        if (directionAB) {
            this.setUpstreamVertex(parentEdge.getVertexA());
            this.setDownstreamVertex(parentEdge.getVertexB());
        } else {
            this.setUpstreamVertex(parentEdge.getVertexB());
            this.setDownstreamVertex(parentEdge.getVertexA());
        }
    }

    protected EdgeSegmentImpl(IdGroupingToken groupId, boolean directionAB) {
        super(groupId, EDGE_SEGMENT_ID_CLASS);
    }

    protected EdgeSegmentImpl(EdgeSegmentImpl edgeSegmentImpl) {
        super(edgeSegmentImpl);
        this.setParent(edgeSegmentImpl.getParentEdge());
        this.setUpstreamVertex(edgeSegmentImpl.getUpstreamVertex());
        this.setDownstreamVertex(edgeSegmentImpl.getDownstreamVertex());
    }

    @Override
    public boolean remove(DirectedVertex vertex) {
        if (vertex != null) {
            if (this.getUpstreamVertex() != null && this.getUpstreamVertex().getId() == vertex.getId()) {
                this.upstreamVertex = null;
                return true;
            }
            if (this.getDownstreamVertex() != null && this.getDownstreamVertex().getId() == vertex.getId()) {
                this.downstreamVertex = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setDownstreamVertex(DirectedVertex downstreamVertex) {
        this.downstreamVertex = downstreamVertex;
    }

    @Override
    public void setUpstreamVertex(DirectedVertex upstreamVertex) {
        this.upstreamVertex = upstreamVertex;
    }

    @Override
    public DirectedVertex getUpstreamVertex() {
        return this.upstreamVertex;
    }

    @Override
    public DirectedVertex getDownstreamVertex() {
        return this.downstreamVertex;
    }

    @Override
    public boolean isDirectionAb() {
        return this.getParentEdge().hasEdgeSegmentAb() && this.getParentEdge().getEdgeSegmentAb().getId() == this.getId();
    }

    @Override
    public DirectedEdge getParentEdge() {
        return this.parentEdge;
    }

    @Override
    public void setParent(DirectedEdge parentEdge) {
        if (parentEdge == null) {
            LOGGER.warning(String.format("Parent edge is null, unable to set on edge segment (id: %d)", this.getId()));
            return;
        }
        this.parentEdge = parentEdge;
    }

    @Override
    public void removeParentEdge() {
        this.parentEdge = null;
    }

    @Override
    public EdgeSegmentImpl clone() {
        return new EdgeSegmentImpl(this);
    }

    @Override
    public boolean validate() {
        if (this.parentEdge == null) {
            LOGGER.warning(String.format("parent edge missing on edge segment (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getUpstreamVertex() == null) {
            LOGGER.warning(String.format("upstream vertex missing on edge segment (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getDownstreamVertex() == null) {
            LOGGER.warning(String.format("downstream vertex missing on edge segment (id:%d externalId:%s)", this.getId(), this.getExternalId()));
            return false;
        }
        if (this.getParentEdge().getVertexA() == this.getUpstreamVertex()) {
            if (this.getParentEdge().getEdgeSegmentAb() == null) {
                LOGGER.warning(String.format("edge segment A->B on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is null", this.getId(), this.getExternalId()));
                return false;
            }
            if (!this.getParentEdge().getEdgeSegmentAb().equals(this)) {
                LOGGER.warning(String.format("edge segment A->B on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is not", this.getId(), this.getExternalId()));
                return false;
            }
        }
        if (this.getParentEdge().getVertexB() == this.getUpstreamVertex()) {
            if (this.getParentEdge().getEdgeSegmentBa() == null) {
                LOGGER.warning(String.format("edge segment A->B on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is null", this.getId(), this.getExternalId()));
                return false;
            }
            if (!this.getParentEdge().getEdgeSegmentBa().equals(this)) {
                LOGGER.warning(String.format("edge segment B->A on parent edge of this edge segment (id:%d externalId:%s) should be the same but it is not", this.getId(), this.getExternalId()));
                return false;
            }
        }
        if (this.getParentEdge().getVertexA().equals(this.getUpstreamVertex())) {
            if (!this.getParentEdge().getVertexB().equals(this.getDownstreamVertex())) {
                LOGGER.warning(String.format("edge segment (id:%d externalId:%s) vertices do not match with parent edge vertices", this.getId(), this.getExternalId()));
                return false;
            }
        } else if (!this.getParentEdge().getVertexB().equals(this.getUpstreamVertex()) || !this.getParentEdge().getVertexA().equals(this.getDownstreamVertex())) {
            LOGGER.warning(String.format("edge segment (id:%d externalId:%s) vertices do not match with parent edge vertices", this.getId(), this.getExternalId()));
            return false;
        }
        return true;
    }
}

