/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.directed;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.graph.VertexImpl;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;

public class DirectedVertexImpl
extends VertexImpl
implements DirectedVertex {
    private static final long serialVersionUID = 2165199386965239623L;
    private static final Logger LOGGER = Logger.getLogger(DirectedVertexImpl.class.getCanonicalName());
    protected final Set<EdgeSegment> entryEdgeSegments = new TreeSet<EdgeSegment>();
    protected final Set<EdgeSegment> exitEdgeSegments = new TreeSet<EdgeSegment>();

    protected DirectedVertexImpl(IdGroupingToken groupId) {
        super(groupId);
    }

    protected DirectedVertexImpl(DirectedVertexImpl directedVertexImpl) {
        super(directedVertexImpl);
        this.entryEdgeSegments.addAll(directedVertexImpl.getEntryEdgeSegments());
        this.exitEdgeSegments.addAll(directedVertexImpl.getExitEdgeSegments());
    }

    @Override
    public Set<EdgeSegment> getEntryEdgeSegments() {
        return Collections.unmodifiableSet(this.entryEdgeSegments);
    }

    @Override
    public Set<EdgeSegment> getExitEdgeSegments() {
        return Collections.unmodifiableSet(this.exitEdgeSegments);
    }

    @Override
    public boolean addEdgeSegment(EdgeSegment edgeSegment) {
        if (edgeSegment.getUpstreamVertex().getId() == this.getId()) {
            return this.exitEdgeSegments.add(edgeSegment);
        }
        if (edgeSegment.getDownstreamVertex().getId() == this.getId()) {
            return this.entryEdgeSegments.add(edgeSegment);
        }
        LOGGER.warning(String.format("Edge segment %s (id:%d) does not have this vertex %s (%d) on either end", edgeSegment.getExternalId(), edgeSegment.getId(), this.getExternalId(), this.getId()));
        return false;
    }

    @Override
    public boolean removeEdgeSegment(EdgeSegment edgeSegment) {
        boolean removed = false;
        removed = this.exitEdgeSegments.remove(edgeSegment);
        if (!removed) {
            removed = this.entryEdgeSegments.remove(edgeSegment);
        }
        return removed;
    }

    @Override
    public boolean removeEntryEdgeSegment(EdgeSegment edgeSegment) {
        return this.entryEdgeSegments.remove(edgeSegment);
    }

    @Override
    public boolean removeExitEdgeSegment(EdgeSegment edgeSegment) {
        return this.exitEdgeSegments.remove(edgeSegment);
    }

    @Override
    public DirectedVertexImpl clone() {
        return new DirectedVertexImpl(this);
    }
}

