/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.goplanit.graph.GraphEntityImpl;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.CloneUtils;
import org.locationtech.jts.geom.Point;

public class VertexImpl
extends GraphEntityImpl
implements Vertex {
    private static final long serialVersionUID = -2877566769607366608L;
    protected Map<String, Object> inputProperties = null;
    protected Point position;
    protected final Map<Long, Edge> edges = new HashMap<Long, Edge>();

    protected VertexImpl(IdGroupingToken groupId) {
        super(groupId, VERTEX_ID_CLASS);
    }

    protected VertexImpl(VertexImpl vertexImpl) {
        super(vertexImpl);
        this.setPosition((Point)vertexImpl.getPosition().copy());
        this.edges.putAll(vertexImpl.edges);
        if (vertexImpl.inputProperties != null && !vertexImpl.inputProperties.isEmpty()) {
            for (Map.Entry<String, Object> entry : vertexImpl.inputProperties.entrySet()) {
                this.addInputProperty(new String(entry.getKey()), CloneUtils.clone(entry.getValue()));
            }
        }
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Point position) {
        this.position = position;
    }

    @Override
    public void addInputProperty(String key, Object value) {
        if (this.inputProperties == null) {
            this.inputProperties = new HashMap<String, Object>();
        }
        this.inputProperties.put(key, value);
    }

    @Override
    public Object getInputProperty(String key) {
        return this.inputProperties.get(key);
    }

    @Override
    public boolean addEdge(Edge edge) {
        return this.edges.put(edge.getId(), edge) != null;
    }

    @Override
    public boolean removeEdge(long edgeId) {
        return this.edges.remove(edgeId) != null;
    }

    @Override
    public Collection<Edge> getEdges() {
        return Collections.unmodifiableCollection(this.edges.values());
    }

    @Override
    public VertexImpl clone() {
        return new VertexImpl(this);
    }
}

