/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.gap;

import org.goplanit.gap.GapFunction;
import org.goplanit.gap.GapFunctionConfigurator;
import org.goplanit.gap.LinkBasedRelativeGapConfigurator;
import org.goplanit.gap.NormBasedGapConfigurator;
import org.goplanit.utils.exceptions.PlanItException;

public class GapFunctionConfiguratorFactory {
    public static GapFunctionConfigurator<? extends GapFunction> createConfigurator(String gapFunctionType) throws PlanItException {
        if (gapFunctionType.equals(GapFunction.LINK_BASED_RELATIVE_GAP)) {
            return new LinkBasedRelativeGapConfigurator();
        }
        if (gapFunctionType.equals(GapFunction.NORM_BASED_GAP)) {
            return new NormBasedGapConfigurator();
        }
        throw new PlanItException(String.format("unable to construct configurator for given gapFunctionType %s", gapFunctionType));
    }
}

