/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.demands;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.goplanit.component.PlanitComponent;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.time.TimePeriodImpl;
import org.goplanit.userclass.TravelerType;
import org.goplanit.userclass.UserClass;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdAble;
import org.goplanit.utils.id.IdAbleImpl;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.time.TimePeriodUtils;
import org.goplanit.utils.wrapper.LongMapWrapperImpl;

public class Demands
extends PlanitComponent<Demands>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(Demands.class.getCanonicalName());
    private static final long serialVersionUID = 144798248371260732L;
    protected final TreeMap<Long, TreeMap<Mode, OdDemands>> odDemandsByTimePeriodAndMode;
    public final TimePeriods timePeriods;
    public final UserClasses userClasses;
    public final TravelerTypes travelerTypes;

    public Demands(IdGroupingToken groupId) {
        super(groupId, Demands.class);
        this.travelerTypes = new TravelerTypes();
        this.userClasses = new UserClasses();
        this.timePeriods = new TimePeriods();
        this.odDemandsByTimePeriodAndMode = new TreeMap();
    }

    public Demands(Demands other) {
        super(other);
        this.travelerTypes = other.travelerTypes.clone();
        this.userClasses = other.userClasses.clone();
        this.timePeriods = other.timePeriods.clone();
        this.odDemandsByTimePeriodAndMode = new TreeMap();
        for (TimePeriod timePeriod : this.timePeriods) {
            Set<Mode> modes = this.getRegisteredModesForTimePeriod(timePeriod);
            for (Mode mode : modes) {
                OdDemands odDemandMatrix = this.get(mode, timePeriod);
                this.registerOdDemandPcuHour(timePeriod, mode, odDemandMatrix);
            }
        }
    }

    public OdDemands registerOdDemandPcuHour(TimePeriod timePeriod, Mode mode, OdDemands odDemandsPcuHour) {
        if (!this.odDemandsByTimePeriodAndMode.containsKey(timePeriod.getId())) {
            this.odDemandsByTimePeriodAndMode.put(timePeriod.getId(), new TreeMap());
        }
        return this.odDemandsByTimePeriodAndMode.get(timePeriod.getId()).put(mode, odDemandsPcuHour);
    }

    public OdDemands get(Mode mode, TimePeriod timePeriod) {
        if (this.odDemandsByTimePeriodAndMode.containsKey(timePeriod.getId()) && this.odDemandsByTimePeriodAndMode.get(timePeriod.getId()).containsKey(mode)) {
            return this.odDemandsByTimePeriodAndMode.get(timePeriod.getId()).get(mode);
        }
        return null;
    }

    public Set<Mode> getRegisteredModesForTimePeriod(TimePeriod timePeriod) {
        if (this.odDemandsByTimePeriodAndMode.containsKey(timePeriod.getId())) {
            return this.odDemandsByTimePeriodAndMode.get(timePeriod.getId()).keySet();
        }
        return null;
    }

    @Override
    public Demands clone() {
        return new Demands(this);
    }

    @Override
    public void reset() {
        this.travelerTypes.clear();
        this.userClasses.clear();
        this.timePeriods.clear();
        this.odDemandsByTimePeriodAndMode.clear();
    }

    public class TimePeriods
    extends LongMapWrapperImpl<TimePeriod> {
        public TimePeriods() {
            super(new HashMap(), IdAble::getId);
        }

        public TimePeriods(TimePeriods other) {
            super(other);
        }

        public TimePeriod createAndRegisterNewTimePeriod(String description, long startTimeSeconds, long durationSeconds) throws PlanItException {
            TimePeriodImpl newTimePeriod = new TimePeriodImpl(Demands.this.getIdGroupingToken(), description, startTimeSeconds, durationSeconds);
            this.register(newTimePeriod);
            return newTimePeriod;
        }

        public SortedSet<TimePeriod> asSortedSetByStartTime() {
            TreeSet<TimePeriod> timePeriodSet = new TreeSet<TimePeriod>(TimePeriodUtils.comparatorByStartTime());
            timePeriodSet.addAll(this.getMap().values());
            return timePeriodSet;
        }

        public TimePeriod getByXmlId(String xmlId) {
            return this.findFirst(timePeriod -> xmlId.equals(timePeriod.getXmlId()));
        }

        @Override
        public TimePeriods clone() {
            return new TimePeriods(this);
        }

        @Override
        public void clear() {
            super.clear();
            IdGenerator.reset(Demands.this.getIdGroupingToken(), TimePeriod.class);
        }
    }

    public class UserClasses
    extends LongMapWrapperImpl<UserClass> {
        public UserClasses() {
            super(new HashMap(), IdAbleImpl::getId);
        }

        public UserClasses(UserClasses other) {
            super(other);
        }

        public UserClass createAndRegisterNewUserClass(String name, Mode mode, TravelerType travellerType) {
            UserClass newUserClass = new UserClass(Demands.this.getIdGroupingToken(), name, mode, travellerType);
            this.register(newUserClass);
            return newUserClass;
        }

        public UserClass getUserClassByXmlId(String xmlId) {
            return this.findFirst(userClass -> xmlId.equals(userClass.getXmlId()));
        }

        @Override
        public UserClasses clone() {
            return new UserClasses(this);
        }

        @Override
        public void clear() {
            super.clear();
            IdGenerator.reset(Demands.this.getIdGroupingToken(), UserClass.class);
        }
    }

    public class TravelerTypes
    extends LongMapWrapperImpl<TravelerType> {
        public TravelerTypes() {
            super(new HashMap(), IdAbleImpl::getId);
        }

        public TravelerTypes(TravelerTypes other) {
            super(other);
        }

        public TravelerType createAndRegisterNew(String name) {
            TravelerType newTravelerType = new TravelerType(Demands.this.getIdGroupingToken(), name);
            this.register(newTravelerType);
            return newTravelerType;
        }

        public TravelerType getByXmlId(String xmlId) {
            return this.findFirst(travelerType -> xmlId.equals(travelerType.getXmlId()));
        }

        @Override
        public TravelerTypes clone() {
            return new TravelerTypes(this);
        }

        @Override
        public void clear() {
            super.clear();
            IdGenerator.reset(Demands.this.getIdGroupingToken(), TravelerType.class);
        }
    }
}

