/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.data;

import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.goplanit.data.MultiKeyPlanItDataIterator;

public class MultiKeyPlanItDataIteratorImpl
implements MultiKeyPlanItDataIterator {
    private boolean isSingleKey;
    private Object[] keys;
    private Object[] values;
    private final MapIterator<MultiKey<? extends Object>, Object[]> multiKeyMapIterator;
    private final MapIterator<Object, Object[]> singleKeyMapIterator;

    public MultiKeyPlanItDataIteratorImpl(boolean isSingleKey, IterableMap<Object, Object[]> singleKeyMap, MultiKeyMap<Object, Object[]> multiKeyMap) {
        this.isSingleKey = isSingleKey;
        if (isSingleKey) {
            this.singleKeyMapIterator = singleKeyMap.mapIterator();
            this.multiKeyMapIterator = null;
        } else {
            this.singleKeyMapIterator = null;
            this.multiKeyMapIterator = multiKeyMap.mapIterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.isSingleKey ? this.singleKeyMapIterator.hasNext() : this.multiKeyMapIterator.hasNext();
    }

    @Override
    public Object[] next() {
        if (this.isSingleKey) {
            Object singleKey = this.singleKeyMapIterator.next();
            this.keys = new Object[]{singleKey};
            this.values = this.singleKeyMapIterator.getValue();
        } else {
            MultiKey<? extends Object> multiKey = this.multiKeyMapIterator.next();
            this.keys = multiKey.getKeys();
            this.values = this.multiKeyMapIterator.getValue();
        }
        return this.keys;
    }

    @Override
    public Object[] getKeys() {
        return this.keys;
    }

    @Override
    public Object[] getValues() {
        return this.values;
    }
}

