/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.physical;

import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.interactor.LinkInflowOutflowAccessee;
import org.goplanit.interactor.LinkInflowOutflowAccessor;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagram;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramComponent;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegments;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.unit.Unit;

public class SteadyStateTravelTimeCost
extends AbstractPhysicalCost
implements LinkInflowOutflowAccessor {
    private static final long serialVersionUID = 1270540193146782352L;
    private LinkInflowOutflowAccessee accessee;
    private double currentTimePeriodHours;
    private double[] freeFlowTravelTimePerLinkSegment = null;
    private FundamentalDiagram[] linkSegmentFundamentalDiagrams = null;

    private FundamentalDiagramComponent getFundamentalDiagramComponent() {
        return this.accessee.getTrafficAssignmentComponent(FundamentalDiagramComponent.class);
    }

    private void initialiseFreeFlowTravelTimesPerLinkSegment(Mode mode, MacroscopicLinkSegments linkSegments) {
        this.freeFlowTravelTimePerLinkSegment = linkSegments.getFreeFlowTravelTimeHourPerLinkSegment(mode);
    }

    private void initialiseFundamentalDiagramsPerLinkSegment(MacroscopicLinkSegments linkSegments) {
        this.linkSegmentFundamentalDiagrams = this.getFundamentalDiagramComponent().asLinkSegmentIndexedArray(linkSegments);
    }

    private double computeTravelTime(LinkSegment linkSegment, FundamentalDiagram fd, double inflowRatePcuHour, double outflowRatePcuHour) {
        double freeFlowTravelTime = this.freeFlowTravelTimePerLinkSegment[(int)linkSegment.getLinkSegmentId()];
        double hypoCriticalDelay = 0.0;
        double hyperCriticalDelay = 0.0;
        if (Precision.isPositive(inflowRatePcuHour)) {
            if (!fd.getFreeFlowBranch().isLinear()) {
                hypoCriticalDelay = linkSegment.getParentLink().getLengthKm() / fd.getFreeFlowBranch().getSpeedKmHourByFlow(inflowRatePcuHour) - freeFlowTravelTime;
            }
            if (Precision.isSmaller(outflowRatePcuHour, inflowRatePcuHour)) {
                hyperCriticalDelay = (inflowRatePcuHour - outflowRatePcuHour) * 0.5 * this.currentTimePeriodHours / outflowRatePcuHour;
            }
        }
        return freeFlowTravelTime + hypoCriticalDelay + hyperCriticalDelay;
    }

    public SteadyStateTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
        this.accessee = null;
    }

    public SteadyStateTravelTimeCost(SteadyStateTravelTimeCost other) {
        super(other);
        this.accessee = other.accessee;
    }

    @Override
    public void initialiseBeforeSimulation(TransportLayerNetwork<?, ?> network) throws PlanItException {
        PlanItException.throwIf(!(network instanceof MacroscopicNetwork), "Steady state travel time cost is only compatible with macroscopic networks", new Object[0]);
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)network;
        PlanItException.throwIf(((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).size() != 1, "Steady state travel time cost is currently only compatible with networks using a single infrastructure layer", new Object[0]);
        PlanItException.throwIf(((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).size() != 1, "Steady state travel time cost is currently only compatible with a single mode, found %d", network.getModes().size());
        Mode mode = (Mode)network.getModes().getFirst();
        MacroscopicLinkSegments linkSegments = ((MacroscopicNetworkLayer)((MacroscopicNetwork)network).getLayerByMode(mode)).getLinkSegments();
        this.initialiseFreeFlowTravelTimesPerLinkSegment(mode, linkSegments);
        this.initialiseFundamentalDiagramsPerLinkSegment(linkSegments);
    }

    @Override
    public void updateTimePeriod(TimePeriod timePeriod) {
        try {
            this.currentTimePeriodHours = Unit.SECOND.convertTo(Unit.HOUR, timePeriod.getDurationSeconds());
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Unable to convert seconds to hours for time period %s in steady-state travel time cost", timePeriod.getXmlId()));
        }
    }

    @Override
    public double getGeneralisedCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        double inflow = this.accessee.getLinkSegmentInflowPcuHour(linkSegment);
        double outflow = this.accessee.getLinkSegmentOutflowPcuHour(linkSegment);
        int linkSegmentId = (int)linkSegment.getLinkSegmentId();
        return this.computeTravelTime(linkSegment, this.linkSegmentFundamentalDiagrams[linkSegmentId], inflow, outflow);
    }

    @Override
    public void populateWithCost(UntypedPhysicalLayer<?, ?, ?> physicalLayer, Mode mode, double[] costToFill) throws PlanItException {
        double[] inflows = this.accessee.getLinkSegmentInflowsPcuHour();
        double[] outflows = this.accessee.getLinkSegmentOutflowsPcuHour();
        for (LinkSegment linkSegment : physicalLayer.getLinkSegments()) {
            int linkSegmentId = (int)linkSegment.getLinkSegmentId();
            costToFill[linkSegmentId] = this.computeTravelTime(linkSegment, this.linkSegmentFundamentalDiagrams[linkSegmentId], inflows[linkSegmentId], outflows[linkSegmentId]);
        }
    }

    @Override
    public SteadyStateTravelTimeCost clone() {
        return new SteadyStateTravelTimeCost(this);
    }

    @Override
    public void setAccessee(LinkInflowOutflowAccessee accessee) {
        this.accessee = accessee;
    }

    @Override
    public void reset() {
        this.freeFlowTravelTimePerLinkSegment = null;
        this.linkSegmentFundamentalDiagrams = null;
    }

    @Override
    public double getTravelTimeCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.getGeneralisedCost(mode, linkSegment);
    }

    @Override
    public double getDTravelTimeDFlow(boolean uncongested, Mode mode, MacroscopicLinkSegment linkSegment) {
        double outflowRatePcuH = this.accessee.getLinkSegmentOutflowPcuHour(linkSegment);
        int linkSegmentId = (int)linkSegment.getLinkSegmentId();
        FundamentalDiagram fd = this.linkSegmentFundamentalDiagrams[linkSegmentId];
        if (uncongested) {
            if (fd.getFreeFlowBranch().isLinear()) {
                return 0.0;
            }
            LOGGER.severe("Steady state travel time implementation does not yet support derivative of hypocritical delay on non-linear uncongested FD branches");
            throw new RuntimeException("Unable to continue due to error in Steady State travel time cost computation");
        }
        if (Precision.isPositive(outflowRatePcuH)) {
            return 0.5 * this.currentTimePeriodHours / outflowRatePcuH;
        }
        return Double.POSITIVE_INFINITY;
    }
}

