/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.cost.physical;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.interactor.LinkVolumeAccessee;
import org.goplanit.interactor.LinkVolumeAccessor;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.Pair;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegmentType;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.time.TimePeriod;

public class BPRLinkTravelTimeCost
extends AbstractPhysicalCost
implements LinkVolumeAccessor {
    private static final long serialVersionUID = -1529475107840907959L;
    private static final Logger LOGGER = Logger.getLogger(BPRLinkTravelTimeCost.class.getCanonicalName());
    protected LinkVolumeAccessee linkVolumeAccessee = null;
    protected Pair<Double, Double> defaultParameters;
    protected BPRParameters defaultParametersPerMode;
    protected Map<MacroscopicLinkSegmentType, BPRParameters> defaultParametersPerLinkSegmentTypeAndMode;
    protected Map<MacroscopicLinkSegment, BPRParameters> parametersPerLinkSegmentAndMode;
    protected BPRParameters[] bprParametersPerLinkSegment = null;
    protected double[][] freeFlowTravelTimePerLinkSegment = null;
    public static final double DEFAULT_ALPHA = 0.5;
    public static final double DEFAULT_BETA = 4.0;

    protected double computeCostInHours(MacroscopicLinkSegment linkSegment, Mode mode, double flowPcuPerHour) {
        if (!linkSegment.isModeAllowed(mode)) {
            return Double.MAX_VALUE;
        }
        int id = (int)linkSegment.getId();
        double freeFlowTravelTime = this.freeFlowTravelTimePerLinkSegment[(int)mode.getId()][id];
        double capacity = linkSegment.getCapacityOrDefaultPcuH();
        Pair<Double, Double> alphaBetaParameters = this.bprParametersPerLinkSegment[id].getAlphaBetaParameters(mode);
        double alpha = alphaBetaParameters.first();
        double beta = alphaBetaParameters.second();
        return freeFlowTravelTime * (1.0 + alpha * Math.pow(flowPcuPerHour / capacity, beta));
    }

    public BPRLinkTravelTimeCost(IdGroupingToken groupId) {
        super(groupId);
        this.parametersPerLinkSegmentAndMode = new HashMap<MacroscopicLinkSegment, BPRParameters>();
        this.defaultParametersPerMode = new BPRParameters();
        this.defaultParametersPerLinkSegmentTypeAndMode = new HashMap<MacroscopicLinkSegmentType, BPRParameters>();
        this.defaultParameters = Pair.of(0.5, 4.0);
    }

    public BPRLinkTravelTimeCost(BPRLinkTravelTimeCost bprLinkTravelTimeCost) {
        super(bprLinkTravelTimeCost);
        this.linkVolumeAccessee = bprLinkTravelTimeCost.linkVolumeAccessee;
        this.parametersPerLinkSegmentAndMode = bprLinkTravelTimeCost.parametersPerLinkSegmentAndMode;
        this.defaultParametersPerMode = bprLinkTravelTimeCost.defaultParametersPerMode;
        this.defaultParametersPerLinkSegmentTypeAndMode = bprLinkTravelTimeCost.defaultParametersPerLinkSegmentTypeAndMode;
        this.defaultParameters = bprLinkTravelTimeCost.defaultParameters;
        this.bprParametersPerLinkSegment = bprLinkTravelTimeCost.bprParametersPerLinkSegment;
        this.freeFlowTravelTimePerLinkSegment = bprLinkTravelTimeCost.freeFlowTravelTimePerLinkSegment;
    }

    public void setParameters(MacroscopicLinkSegment linkSegment, Mode mode, double alpha, double beta) {
        if (this.parametersPerLinkSegmentAndMode.get(linkSegment) == null) {
            this.parametersPerLinkSegmentAndMode.put(linkSegment, new BPRParameters());
        }
        this.parametersPerLinkSegmentAndMode.get(linkSegment).registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(Mode mode, double alpha, double beta) {
        this.defaultParametersPerMode.registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(MacroscopicLinkSegmentType macroscopicLinkSegmentType, Mode mode, double alpha, double beta) {
        if (this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType) == null) {
            this.defaultParametersPerLinkSegmentTypeAndMode.put(macroscopicLinkSegmentType, new BPRParameters());
        }
        this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).registerParameters(mode, alpha, beta);
    }

    public void setDefaultParameters(double alpha, double beta) {
        this.defaultParameters = Pair.of(alpha, beta);
    }

    @Override
    public void initialiseBeforeSimulation(TransportLayerNetwork<?, ?> network) throws PlanItException {
        PlanItException.throwIf(!(network instanceof MacroscopicNetwork), "BPR cost is only compatible with macroscopic networks", new Object[0]);
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)network;
        PlanItException.throwIf(((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).size() != 1, "BPR cost is currently only compatible with networks using a single infrastructure layer", new Object[0]);
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).getFirst();
        if (network.getModes().size() != networkLayer.getSupportedModes().size()) {
            LOGGER.warning("network wide modes do not match modes supported by only layer, this makes the assignment less efficient, consider removing unused modes");
        }
        this.freeFlowTravelTimePerLinkSegment = new double[network.getModes().size()][networkLayer.getLinkSegments().size()];
        for (Mode mode : network.getModes()) {
            this.freeFlowTravelTimePerLinkSegment[(int)mode.getId()] = networkLayer.getLinkSegments().getFreeFlowTravelTimeHourPerLinkSegment(mode);
        }
        this.bprParametersPerLinkSegment = new BPRParameters[networkLayer.getLinkSegments().size()];
        for (MacroscopicLinkSegment macroscopicLinkSegment : networkLayer.getLinkSegments()) {
            int id = (int)macroscopicLinkSegment.getLinkSegmentId();
            this.bprParametersPerLinkSegment[id] = new BPRParameters();
            MacroscopicLinkSegmentType macroscopicLinkSegmentType = macroscopicLinkSegment.getLinkSegmentType();
            for (Mode mode : network.getModes()) {
                Pair<Double, Double> alphaBetaPair = this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment) != null && this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment).getAlphaBetaParameters(mode) != null ? this.parametersPerLinkSegmentAndMode.get(macroscopicLinkSegment).getAlphaBetaParameters(mode) : (this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType) != null && this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).getAlphaBetaParameters(mode) != null ? this.defaultParametersPerLinkSegmentTypeAndMode.get(macroscopicLinkSegmentType).getAlphaBetaParameters(mode) : (this.defaultParametersPerMode.getAlphaBetaParameters(mode) != null ? this.defaultParametersPerMode.getAlphaBetaParameters(mode) : this.defaultParameters));
                this.bprParametersPerLinkSegment[id].registerParameters(mode, alphaBetaPair);
            }
        }
    }

    @Override
    public void updateTimePeriod(TimePeriod timePeriod) {
    }

    @Override
    public double getGeneralisedCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.computeCostInHours(linkSegment, mode, this.linkVolumeAccessee.getLinkSegmentVolume(linkSegment));
    }

    @Override
    public double getTravelTimeCost(Mode mode, MacroscopicLinkSegment linkSegment) {
        return this.computeCostInHours(linkSegment, mode, this.linkVolumeAccessee.getLinkSegmentVolume(linkSegment));
    }

    @Override
    public double getDTravelTimeDFlow(boolean uncongested, Mode mode, MacroscopicLinkSegment linkSegment) {
        if (!linkSegment.isModeAllowed(mode)) {
            return Double.MAX_VALUE;
        }
        int id = (int)linkSegment.getId();
        double freeFlowTravelTime = this.freeFlowTravelTimePerLinkSegment[(int)mode.getId()][id];
        double capacity = linkSegment.getCapacityOrDefaultPcuH();
        Pair<Double, Double> alphaBetaParameters = this.bprParametersPerLinkSegment[id].getAlphaBetaParameters(mode);
        double alpha = alphaBetaParameters.first();
        double beta = alphaBetaParameters.second();
        double currentFlow = this.linkVolumeAccessee.getLinkSegmentVolume(linkSegment);
        return (beta - 1.0) * freeFlowTravelTime * alpha * Math.pow(currentFlow / capacity, beta - 1.0);
    }

    @Override
    public void populateWithCost(UntypedPhysicalLayer<?, ?, ?> physicalLayer, Mode mode, double[] costToFill) throws PlanItException {
        double[] linkSegmentFlows = this.linkVolumeAccessee.getLinkSegmentVolumes();
        for (LinkSegment linkSegment : physicalLayer.getLinkSegments()) {
            int id = (int)linkSegment.getLinkSegmentId();
            costToFill[id] = this.computeCostInHours((MacroscopicLinkSegment)linkSegment, mode, linkSegmentFlows[id]);
        }
    }

    @Override
    public void setAccessee(LinkVolumeAccessee linkVolumeAccessee) {
        this.linkVolumeAccessee = linkVolumeAccessee;
    }

    @Override
    public BPRLinkTravelTimeCost clone() {
        return new BPRLinkTravelTimeCost(this);
    }

    @Override
    public void reset() {
        this.freeFlowTravelTimePerLinkSegment = null;
        this.bprParametersPerLinkSegment = null;
    }

    public class BPRParameters {
        private final Map<Mode, Pair<Double, Double>> parametersMap = new HashMap<Mode, Pair<Double, Double>>();

        private void registerParameters(Mode mode, double alpha, double beta) {
            if (beta < 1.0) {
                LOGGER.warning(String.format("BPR Beta parameter smaller than 1 (%.2f), unlikely choice", mode.getXmlId(), beta));
            }
            this.parametersMap.put(mode, Pair.of(alpha, beta));
        }

        private void registerParameters(Mode mode, Pair<Double, Double> pair) {
            if (pair.second() < 1.0) {
                LOGGER.warning(String.format("BPR Beta parameter smaller than one (%.2f), unlikely choice", mode.getXmlId(), pair.second()));
            }
            this.parametersMap.put(mode, pair);
        }

        public Pair<Double, Double> getAlphaBetaParameters(Mode mode) {
            return this.parametersMap.get(mode);
        }
    }
}

