/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter;

import java.util.logging.Logger;
import org.goplanit.converter.ConverterBase;
import org.goplanit.converter.MultiConverterReader;
import org.goplanit.converter.MultiConverterWriter;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.misc.Pair;

public abstract class MultiConverter<T, U>
extends ConverterBase {
    private static final Logger LOGGER = Logger.getLogger(MultiConverter.class.getCanonicalName());

    protected MultiConverter(MultiConverterReader<T, U> reader, MultiConverterWriter<T, U> writer) {
        super(reader, writer);
    }

    @Override
    public void convert() throws PlanItException {
        MultiConverterReader reader = (MultiConverterReader)this.getReader();
        LOGGER.info(String.format("****************** [START] CONVERTER: READ %s [START] ********************", reader.getTypeDescription()));
        Pair multiResult = reader.read();
        reader.reset();
        LOGGER.info(String.format("****************** [END]   CONVERTER: READ %s [END]   ********************", reader.getTypeDescription()));
        MultiConverterWriter writer = (MultiConverterWriter)this.getWriter();
        LOGGER.info(String.format("****************** [START] NETWORK CONVERTER: WRITE %s [START] ********************", writer.getTypeDescription()));
        writer.write(multiResult.first(), multiResult.second());
        writer.reset();
        LOGGER.info(String.format("****************** [END]   NETWORK CONVERTER: WRITE %s [END]   ********************", writer.getTypeDescription()));
    }
}

