/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.loading.SplittingRateData;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmNetworkLoading;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.network.virtual.VirtualNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.time.TimePeriod;

public abstract class StaticLtmAssignmentStrategy {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmAssignmentStrategy.class.getCanonicalName());
    private final IdGroupingToken idGroupingToken;
    private final long assignmentId;
    private final TransportModelNetwork transportModelNetwork;
    private StaticLtmNetworkLoading networkLoading;
    private OdDemands odDemands;
    private final StaticLtmSettings settings;
    private final TrafficAssignmentComponentAccessee taComponents;

    protected TransportModelNetwork getTransportNetwork() {
        return this.transportModelNetwork;
    }

    protected MacroscopicNetwork getInfrastructureNetwork() {
        return (MacroscopicNetwork)this.getTransportNetwork().getInfrastructureNetwork();
    }

    protected IdGroupingToken getIdGroupingToken() {
        return this.idGroupingToken;
    }

    protected long getAssignmentId() {
        return this.assignmentId;
    }

    protected StaticLtmNetworkLoading getLoading() {
        return this.networkLoading;
    }

    protected StaticLtmSettings getSettings() {
        return this.settings;
    }

    protected OdDemands getOdDemands() {
        return this.odDemands;
    }

    protected void setOdDemands(OdDemands odDemands) {
        this.odDemands = odDemands;
    }

    protected <T> T getTrafficAssignmentComponent(Class<T> taComponentClassKey) {
        return this.taComponents.getTrafficAssignmentComponent(taComponentClassKey);
    }

    protected void verifyNetworkLoadingConvergenceProgress(StaticLtmNetworkLoading networkLoading, int networkLoadingIterationIndex) {
        boolean changedScheme;
        if (!networkLoading.isConverging() && !(changedScheme = networkLoading.activateNextExtension(true))) {
            LOGGER.warning(String.format("%sDetected network loading is not converging as expected (internal loading iteration %d) - unable to activate further extensions, consider aborting", LoggingUtils.createRunIdPrefix(this.getAssignmentId()), networkLoadingIterationIndex));
        }
    }

    protected void executeNetworkLoading() {
        int networkLoadingIterationIndex = 0;
        this.getLoading().stepZeroIterationInitialisation(true);
        do {
            this.verifyNetworkLoadingConvergenceProgress(this.getLoading(), networkLoadingIterationIndex);
            this.getLoading().stepOneSplittingRatesUpdate();
            this.getLoading().stepTwoInflowSendingFlowUpdate();
            this.getLoading().stepThreeSplittingRateUpdate();
            this.getLoading().stepFourOutflowReceivingFlowUpdate();
        } while (!this.getLoading().stepFiveCheckNetworkLoadingConvergence(networkLoadingIterationIndex++));
    }

    protected abstract StaticLtmNetworkLoading createNetworkLoading();

    public StaticLtmAssignmentStrategy(IdGroupingToken idGroupingToken, long assignmentId, TransportModelNetwork transportModelNetwork, StaticLtmSettings settings, TrafficAssignmentComponentAccessee taComponents) {
        this.transportModelNetwork = transportModelNetwork;
        this.assignmentId = assignmentId;
        this.idGroupingToken = idGroupingToken;
        this.settings = settings;
        this.taComponents = taComponents;
    }

    public void updateTimePeriod(TimePeriod timePeriod, Mode mode, OdDemands odDemands) {
        this.networkLoading = this.createNetworkLoading();
        this.networkLoading.initialiseInputs(mode, odDemands, this.getTransportNetwork());
        this.setOdDemands(odDemands);
    }

    public abstract void createInitialSolution(double[] var1);

    public abstract boolean performIteration(Mode var1, double[] var2, int var3);

    public void executeNetworkCostsUpdate(Mode theMode, boolean updateOnlyPotentiallyBlockingNodeCosts, double[] costsToUpdate) throws PlanItException {
        AbstractPhysicalCost physicalCost = this.getTrafficAssignmentComponent(AbstractPhysicalCost.class);
        AbstractVirtualCost virtualCost = this.getTrafficAssignmentComponent(AbstractVirtualCost.class);
        SplittingRateData splittingRateData = this.getLoading().getSplittingRateData();
        if (updateOnlyPotentiallyBlockingNodeCosts) {
            MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)this.getInfrastructureNetwork().getLayerByMode(theMode);
            VirtualNetwork virtualLayer = this.getTransportNetwork().getZoning().getVirtualNetwork();
            for (DirectedVertex trackedFlowNode : splittingRateData.getTrackedNodes()) {
                if (!splittingRateData.isPotentiallyBlocking(trackedFlowNode)) continue;
                networkLayer.getLinkSegments().forEachMatchingIdIn(trackedFlowNode.getEntryEdgeSegments(), es -> {
                    costsToUpdate[(int)es.getId()] = physicalCost.getGeneralisedCost(theMode, (MacroscopicLinkSegment)es);
                });
                virtualLayer.getConnectoidSegments().forEachMatchingIdIn(trackedFlowNode.getEntryEdgeSegments(), es -> {
                    costsToUpdate[(int)es.getId()] = virtualCost.getGeneralisedCost(theMode, (ConnectoidSegment)es);
                });
            }
        } else {
            virtualCost.populateWithCost(this.getTransportNetwork().getVirtualNetwork(), theMode, costsToUpdate);
            physicalCost.populateWithCost((UntypedPhysicalLayer)this.getInfrastructureNetwork().getLayerByMode(theMode), theMode, costsToUpdate);
        }
    }

    public abstract String getDescription();
}

