/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortestpath.ShortestPathResult;
import org.goplanit.assignment.ltm.sltm.Bush;
import org.goplanit.assignment.ltm.sltm.Pas;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.math.Precision;

public class PasManager {
    private static final Logger LOGGER = Logger.getLogger(PasManager.class.getCanonicalName());
    private final double MU = 0.5;
    private final double NU = 0.25;
    private Map<DirectedVertex, Collection<Pas>> passByMergeVertex = new HashMap<DirectedVertex, Collection<Pas>>();
    private final Comparator<Pas> pasReducedCostComparator = new Comparator<Pas>(){

        @Override
        public int compare(Pas p1, Pas p2) {
            if (Precision.isGreater(p1.getReducedCost(), p2.getReducedCost(), 1.0E-15)) {
                return -1;
            }
            if (Precision.isSmaller(p1.getReducedCost(), p2.getReducedCost(), 1.0E-15)) {
                return 1;
            }
            return 0;
        }
    };

    private boolean isCostEffective(Pas pas, double reducedCost) {
        return Precision.isGreater(pas.getAlternativeHighCost() - pas.getAlternativeLowCost(), 0.5 * reducedCost);
    }

    private boolean isFlowEffective(Pas pas, Bush originBush, double[] flowAcceptanceFactors) {
        boolean lowCostPath = true;
        double s2SubPathAcceptedFlowOnBush = pas.computeOverlappingAcceptedFlow(originBush, !lowCostPath, flowAcceptanceFactors);
        EdgeSegment s2LastEdgeSegment = pas.getLastEdgeSegment(!lowCostPath);
        double s2LastSegmentSendingFlowOnBush = originBush.getSendingFlowPcuH(s2LastEdgeSegment);
        double s2LastSegmentAcceptedFlowOnBush = s2LastSegmentSendingFlowOnBush * flowAcceptanceFactors[(int)s2LastEdgeSegment.getId()];
        return Precision.isGreater(s2SubPathAcceptedFlowOnBush, 0.25 * s2LastSegmentAcceptedFlowOnBush);
    }

    private boolean isPasEffectiveForBush(Pas pas, Bush originBush, double[] flowAcceptanceFactors, double reducedCost) {
        return this.isCostEffective(pas, reducedCost) && this.isFlowEffective(pas, originBush, flowAcceptanceFactors);
    }

    public static EdgeSegment[] createSubpathArrayFrom(DirectedVertex start, DirectedVertex end, ShortestPathResult pathTree, int arrayLength, boolean truncateArray) {
        EdgeSegment[] edgeSegmentArray = new EdgeSegment[arrayLength];
        DirectedVertex currVertex = end;
        EdgeSegment currEdgeSegment = null;
        int index = edgeSegmentArray.length - 1;
        do {
            currEdgeSegment = pathTree.getIncomingEdgeSegmentForVertex(currVertex);
            edgeSegmentArray[index--] = currEdgeSegment;
            if (currEdgeSegment != null) continue;
            LOGGER.warning(String.format("Unable to extract subpath from start vertex %s to end vertex %s, no incoming edge segment available at intermediate vertex %s", start.getXmlId(), end.getXmlId(), currVertex.getXmlId()));
            return null;
        } while (!(currVertex = currEdgeSegment.getUpstreamVertex()).idEquals(start));
        if (truncateArray && index > 0) {
            return Arrays.copyOfRange(edgeSegmentArray, index + 1, edgeSegmentArray.length);
        }
        return edgeSegmentArray;
    }

    public static EdgeSegment[] createSubpathArrayFrom(DirectedVertex start, DirectedVertex end, Map<DirectedVertex, EdgeSegment> pathTree, int arrayLength, boolean truncateArray) {
        EdgeSegment[] edgeSegmentArray = new EdgeSegment[arrayLength];
        DirectedVertex currVertex = start;
        EdgeSegment currEdgeSegment = null;
        int index = 0;
        do {
            currEdgeSegment = pathTree.get(currVertex);
            edgeSegmentArray[index++] = currEdgeSegment;
            if (currEdgeSegment != null) continue;
            LOGGER.warning(String.format("Unable to extract subpath from start vertex %s to end vertex %s, no outgoing edge segment available at intermediate vertex %s", start.getXmlId(), end.getXmlId(), currVertex.getXmlId()));
            return null;
        } while (!(currVertex = currEdgeSegment.getDownstreamVertex()).idEquals(end));
        if (truncateArray && index < arrayLength - 1) {
            return Arrays.copyOfRange(edgeSegmentArray, 0, index);
        }
        return edgeSegmentArray;
    }

    public Pas createNewPas(Bush originBush, EdgeSegment[] s1, EdgeSegment[] s2) {
        Pas newPas = Pas.create(s1, s2);
        newPas.registerOrigin(originBush);
        this.passByMergeVertex.putIfAbsent(newPas.getMergeVertex(), new ArrayList());
        this.passByMergeVertex.get(newPas.getMergeVertex()).add(newPas);
        return newPas;
    }

    public void removePas(Pas pas) {
        this.passByMergeVertex.get(pas.getMergeVertex()).remove(pas);
    }

    public Collection<Pas> getPassByMergeVertex(DirectedVertex mergeVertex) {
        return this.passByMergeVertex.get(mergeVertex);
    }

    public Pas findFirstSuitableExistingPas(Bush originBush, DirectedVertex mergeVertex, double[] flowAcceptanceFactors, double reducedCost) {
        Collection<Pas> potentialPass = this.getPassByMergeVertex(mergeVertex);
        if (potentialPass == null) {
            return null;
        }
        Pas matchedPas = null;
        for (Pas pas : potentialPass) {
            boolean pasPotentialMatch = false;
            for (EdgeSegment pasFirstExitSegment : pas.getDivergeVertex().getExitEdgeSegments()) {
                if (!originBush.containsEdgeSegment(pasFirstExitSegment)) continue;
                pasPotentialMatch = true;
            }
            if (!pasPotentialMatch || !this.isPasEffectiveForBush(pas, originBush, flowAcceptanceFactors, reducedCost)) continue;
            matchedPas = pas;
            break;
        }
        return matchedPas;
    }

    public void updateCosts(double[] linkSegmentCosts) {
        for (Collection<Pas> pass : this.passByMergeVertex.values()) {
            this.updateCosts(pass, linkSegmentCosts);
        }
    }

    public void updateCosts(Collection<Pas> pass, double[] linkSegmentCosts) {
        for (Pas pas : pass) {
            pas.updateCost(linkSegmentCosts);
        }
    }

    public PriorityQueue<Pas> getPassSortedByReducedCost() {
        PriorityQueue<Pas> passOrderedByReducedCost = new PriorityQueue<Pas>(this.pasReducedCostComparator);
        this.forEachPas(pas -> passOrderedByReducedCost.add((Pas)pas));
        return passOrderedByReducedCost;
    }

    public void forEachPas(Consumer<Pas> pasConsumer) {
        this.passByMergeVertex.forEach((v, pc) -> pc.forEach(pasConsumer));
    }
}

