/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm;

import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.path.choice.PathChoice;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramComponent;
import org.goplanit.supply.network.nodemodel.NodeModelComponent;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;

public abstract class LtmAssignment
extends TrafficAssignment {
    private static final long serialVersionUID = -8595729519062817426L;
    private static final Logger LOGGER = Logger.getLogger(LtmAssignment.class.getCanonicalName());

    protected MacroscopicNetworkLayer getUsedNetworkLayer() {
        return (MacroscopicNetworkLayer)((MacroscopicNetworkLayers)((MacroscopicNetwork)this.getInfrastructureNetwork()).getTransportLayers()).getFirst();
    }

    @Override
    protected void verifyNetworkDemandZoningCompatibility() throws PlanItException {
        PlanItException.throwIf(!(this.getInfrastructureNetwork() instanceof MacroscopicNetwork), "sLTM is only compatible with macroscopic networks", new Object[0]);
        MacroscopicNetwork macroscopicNetwork = (MacroscopicNetwork)this.getInfrastructureNetwork();
        PlanItException.throwIf(((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).size() != 1, "LTM is currently only compatible with networks using a single transport layer in its physical network", new Object[0]);
        MacroscopicNetworkLayer networkLayer = (MacroscopicNetworkLayer)((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).getFirst();
        if (this.getInfrastructureNetwork().getModes().size() != networkLayer.getSupportedModes().size()) {
            LOGGER.warning("LTM network wide modes do not match modes supported by the single available layer, consider removing unused modes");
        }
        if (this.getInfrastructureNetwork().getModes().size() != 1) {
            LOGGER.warning(String.format("LTM currently only supports a single mode but found %d", this.getInfrastructureNetwork().getModes().size()));
        }
    }

    @Override
    protected void verifyComponentCompatibility() throws PlanItException {
    }

    protected LtmAssignment(IdGroupingToken groupId) {
        super(groupId);
    }

    protected LtmAssignment(LtmAssignment sltm) {
        super(sltm);
    }

    @Override
    public abstract LtmAssignment clone();

    public void setFundamentalDiagram(FundamentalDiagramComponent fundamentalDiagram) {
        this.logRegisteredComponent(fundamentalDiagram, true);
        this.registerComponent(FundamentalDiagramComponent.class, fundamentalDiagram);
    }

    public void setNodeModel(NodeModelComponent nodeModel) {
        this.logRegisteredComponent(nodeModel, true);
        this.registerComponent(NodeModelComponent.class, nodeModel);
    }

    public PathChoice getPathChoice() {
        return this.getTrafficAssignmentComponent(PathChoice.class);
    }

    public void setPathChoice(PathChoice pathChoice) {
        this.logRegisteredComponent(pathChoice, true);
        this.registerComponent(PathChoice.class, pathChoice);
    }

    @Override
    public void reset() {
        super.reset();
    }
}

