/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortestpath;

import java.util.Arrays;
import java.util.Collection;
import org.goplanit.algorithms.shortestpath.MinMaxPathResult;
import org.goplanit.algorithms.shortestpath.MinMaxPathResultImpl;
import org.goplanit.algorithms.shortestpath.OneToAllShortestPathAlgorithm;
import org.goplanit.graph.directed.acyclic.ACyclicSubGraph;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;

public class AcyclicMinMaxShortestPathAlgorithm
implements OneToAllShortestPathAlgorithm {
    private final Collection<? extends DirectedVertex> topologicalOrder;
    private final ACyclicSubGraph acyclicSubGraph;
    private final double[] edgeSegmentCosts;
    private final int numParentNetworkVertices;

    public AcyclicMinMaxShortestPathAlgorithm(ACyclicSubGraph acyclicSubGraph, Collection<? extends DirectedVertex> topologicalOrder, double[] edgeSegmentCosts, int parentNetworkVertices) {
        this.acyclicSubGraph = acyclicSubGraph;
        this.topologicalOrder = topologicalOrder;
        this.edgeSegmentCosts = edgeSegmentCosts;
        this.numParentNetworkVertices = parentNetworkVertices;
    }

    @Override
    public MinMaxPathResult executeOneToAll(DirectedVertex currentOrigin) throws PlanItException {
        double[] minCost = new double[this.numParentNetworkVertices];
        double[] maxCost = new double[this.numParentNetworkVertices];
        Arrays.fill(minCost, Double.POSITIVE_INFINITY);
        Arrays.fill(maxCost, Double.NEGATIVE_INFINITY);
        EdgeSegment[] minBackwardEdgeSegments = new EdgeSegment[this.numParentNetworkVertices];
        EdgeSegment[] maxBackwardEdgeSegments = new EdgeSegment[this.numParentNetworkVertices];
        minCost[(int)currentOrigin.getId()] = 0.0;
        maxCost[(int)currentOrigin.getId()] = 0.0;
        for (DirectedVertex directedVertex : this.topologicalOrder) {
            int vertexIndex = (int)directedVertex.getId();
            for (EdgeSegment exitEdgeSegment : directedVertex.getExitEdgeSegments()) {
                int downstreamVertexIndex;
                if (!this.acyclicSubGraph.containsEdgeSegment(exitEdgeSegment)) continue;
                double edgeCost = this.edgeSegmentCosts[(int)exitEdgeSegment.getId()];
                double foundCostToDownstreamVertex = minCost[vertexIndex] + edgeCost;
                if (foundCostToDownstreamVertex < minCost[downstreamVertexIndex = (int)exitEdgeSegment.getDownstreamVertex().getId()]) {
                    minCost[downstreamVertexIndex] = foundCostToDownstreamVertex;
                    minBackwardEdgeSegments[downstreamVertexIndex] = exitEdgeSegment;
                }
                if (!((foundCostToDownstreamVertex = maxCost[vertexIndex] + edgeCost) >= maxCost[downstreamVertexIndex])) continue;
                maxCost[downstreamVertexIndex] = foundCostToDownstreamVertex;
                maxBackwardEdgeSegments[downstreamVertexIndex] = exitEdgeSegment;
            }
        }
        return new MinMaxPathResultImpl(minCost, minBackwardEdgeSegments, maxCost, maxBackwardEdgeSegments);
    }
}

