/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.geotools.util.ObjectCache;
import org.geotools.util.WeakValueHashMap;

final class FixedSizeObjectCache
implements ObjectCache {
    private final int LIMIT;
    private final Map cache;
    private final Map locks;

    public FixedSizeObjectCache() {
        this(50);
    }

    public FixedSizeObjectCache(int initialSize) {
        this.LIMIT = initialSize;
        this.cache = Collections.synchronizedMap(new WeakValueHashMap(initialSize));
        this.locks = new HashMap(initialSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map map = this.locks;
        synchronized (map) {
            this.locks.clear();
            this.cache.clear();
        }
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public Object peek(Object key) {
        return this.cache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLock(Object key) {
        ReentrantLock lock;
        Map map = this.locks;
        synchronized (map) {
            lock = (ReentrantLock)this.locks.get(key);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(key, lock);
            }
        }
        lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUnLock(Object key) {
        Map map = this.locks;
        synchronized (map) {
            ReentrantLock lock = (ReentrantLock)this.locks.get(key);
            if (lock == null) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            if (lock.getHoldCount() == 0) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            lock.unlock();
            if (lock.getHoldCount() == 0) {
                this.locks.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean holdsLock(Object key) {
        Map map = this.locks;
        synchronized (map) {
            ReentrantLock lock = (ReentrantLock)this.locks.get(key);
            if (lock != null) {
                return lock.getHoldCount() != 0;
            }
        }
        return false;
    }

    @Override
    public void put(Object key, Object object) {
        if (this.cache.size() < this.LIMIT) {
            this.writeLock(key);
            this.cache.put(key, object);
            this.writeUnLock(key);
        }
    }

    @Override
    public Set<Object> getKeys() {
        HashSet<Object> keys = null;
        keys = new HashSet<Object>(this.cache.keySet());
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object key) {
        Map map = this.locks;
        synchronized (map) {
            this.locks.remove(key);
            this.cache.remove(key);
        }
    }
}

