/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import org.geotools.metadata.i18n.Errors;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.util.Classes;
import org.geotools.util.logging.Logging;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public final class Parameters {
    private static final double EPS = 1.0E-8;
    public static ParameterDescriptorGroup EMPTY_GROUP = new DefaultParameterDescriptorGroup("empty", new GeneralParameterDescriptor[0]);

    private Parameters() {
    }

    public static <T> ParameterDescriptor<T> cast(ParameterDescriptor<?> descriptor, Class<T> type) throws ClassCastException {
        Class<?> actual;
        if (descriptor != null && !type.equals(actual = descriptor.getValueClass())) {
            throw new ClassCastException(Errors.format(13, descriptor.getName().getCode(), actual));
        }
        return descriptor;
    }

    public static <T> ParameterValue<T> cast(ParameterValue<?> value, Class<T> type) throws ClassCastException {
        GeneralParameterDescriptor descriptor;
        Class actual;
        if (value != null && !type.equals(actual = (descriptor = value.getDescriptor()).getValueClass())) {
            throw new ClassCastException(Errors.format(13, descriptor.getName().getCode(), actual));
        }
        return value;
    }

    public static boolean isValid(ParameterValue<?> parameter) {
        GeneralParameterDescriptor descriptor = parameter.getDescriptor();
        Object value = parameter.getValue();
        if (value == null) {
            Set validValues = descriptor.getValidValues();
            return validValues != null && validValues.contains(value);
        }
        Class<?> type = Classes.primitiveToWrapper(value.getClass());
        Class<?> expected = Classes.primitiveToWrapper(descriptor.getValueClass());
        if (expected.isAssignableFrom(type)) {
            return false;
        }
        if (type.isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (Parameters.isValidValue(Array.get(value, i), descriptor)) continue;
                return false;
            }
        } else if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                if (Parameters.isValidValue(element, descriptor)) continue;
                return false;
            }
        } else if (!Parameters.isValidValue(value, descriptor)) {
            return false;
        }
        return true;
    }

    private static boolean isValidValue(Object value, ParameterDescriptor<?> descriptor) {
        Set<?> validValues = descriptor.getValidValues();
        if (validValues != null && !validValues.contains(value)) {
            return false;
        }
        Comparable<?> min = descriptor.getMinimumValue();
        if (min != null && min.compareTo(value) > 0) {
            return false;
        }
        Comparable<?> max = descriptor.getMaximumValue();
        return max == null || max.compareTo(value) >= 0;
    }

    public static List<Object> search(GeneralParameterValue param, String name, int maxDepth) {
        ArrayList<Object> list = new ArrayList<Object>();
        Parameters.search(param, name, maxDepth, list);
        return list;
    }

    private static void search(GeneralParameterValue param, String name, int maxDepth, Collection<Object> list) {
        if (maxDepth >= 0) {
            if (AbstractIdentifiedObject.nameMatches((IdentifiedObject)param.getDescriptor(), name)) {
                list.add(param);
            }
            if (maxDepth != 0 && param instanceof ParameterValueGroup) {
                for (GeneralParameterValue value : ((ParameterValueGroup)param).values()) {
                    Parameters.search(value, name, maxDepth - 1, list);
                }
            }
        }
    }

    public static void copy(ParameterValueGroup source, ParameterValueGroup target) {
        for (GeneralParameterValue param : source.values()) {
            String name = param.getDescriptor().getName().getCode();
            if (param instanceof ParameterValueGroup) {
                Parameters.copy((ParameterValueGroup)param, target.addGroup(name));
                continue;
            }
            target.parameter(name).setValue(((ParameterValue)param).getValue());
        }
    }

    public static Map<String, Object> toNameValueMap(GeneralParameterValue parameters, Map<String, Object> destination) {
        if (destination == null) {
            destination = new LinkedHashMap<String, Object>();
        }
        if (parameters instanceof ParameterValue) {
            ParameterValue param = (ParameterValue)parameters;
            Object value = param.getValue();
            Object old = destination.put(param.getDescriptor().getName().getCode(), value);
            if (old != null && !old.equals(value)) {
                throw new IllegalArgumentException("Inconsistent value");
            }
        }
        if (parameters instanceof ParameterValueGroup) {
            ParameterValueGroup group = (ParameterValueGroup)parameters;
            for (GeneralParameterValue value : group.values()) {
                destination = Parameters.toNameValueMap(value, destination);
            }
        }
        return destination;
    }

    public static boolean ensureSet(ParameterValueGroup parameters, String name, double value, Unit<?> unit, boolean force) {
        ParameterValue<?> parameter;
        try {
            parameter = parameters.parameter(name);
        }
        catch (ParameterNotFoundException ignore) {
            return false;
        }
        try {
            if (Math.abs(parameter.doubleValue(unit) / value - 1.0) <= 1.0E-8) {
                return false;
            }
        }
        catch (InvalidParameterTypeException exception) {
            return false;
        }
        catch (IllegalStateException exception) {
            parameter.setValue(value, unit);
            return true;
        }
        if (force) {
            parameter.setValue(value, unit);
        } else {
            LogRecord record = new LogRecord(Level.FINE, "Axis length mismatch.");
            record.setSourceClassName(Parameters.class.getName());
            record.setSourceMethodName("ensureSet");
            Logger logger = Logging.getLogger(Parameters.class);
            record.setLoggerName(logger.getName());
            logger.log(record);
        }
        return true;
    }
}

