/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithm2D;

import java.util.List;
import org.geotools.geometry.iso.aggregate.MultiPrimitiveImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.PrimitiveImpl;
import org.geotools.geometry.iso.primitive.RingImplUnsafe;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.GeometryGraph;
import org.geotools.geometry.iso.topograph2D.util.CoordinateArrays;
import org.geotools.geometry.iso.util.algorithm2D.CGAlgorithms;
import org.opengis.geometry.primitive.Ring;

public class PointLocator {
    private boolean isIn;
    private int numBoundaries;

    public boolean intersects(Coordinate p, GeometryImpl geom) {
        return this.locate(p, geom) != 2;
    }

    public int locate(Coordinate p, GeometryImpl geom) {
        if (geom instanceof CurveImpl) {
            return this.locate(p, (CurveImpl)geom);
        }
        if (geom instanceof SurfaceImpl) {
            return this.locate(p, (SurfaceImpl)geom);
        }
        this.isIn = false;
        this.numBoundaries = 0;
        this.computeLocation(p, geom);
        if (GeometryGraph.isInBoundary(this.numBoundaries)) {
            return 1;
        }
        if (this.numBoundaries > 0 || this.isIn) {
            return 0;
        }
        return 2;
    }

    private void computeLocation(Coordinate p, GeometryImpl geom) {
        if (geom instanceof CurveImpl) {
            this.updateLocationInfo(this.locate(p, (CurveImpl)geom));
        } else if (geom instanceof SurfaceImpl) {
            this.updateLocationInfo(this.locate(p, (SurfaceImpl)geom));
        } else if (geom instanceof MultiPrimitiveImpl) {
            for (PrimitiveImpl primitiveImpl : ((MultiPrimitiveImpl)geom).getElements()) {
                this.updateLocationInfo(this.locate(p, primitiveImpl));
            }
        }
    }

    private void updateLocationInfo(int loc) {
        if (loc == 0) {
            this.isIn = true;
        }
        if (loc == 1) {
            ++this.numBoundaries;
        }
    }

    private int locate(Coordinate p, CurveImpl curve) {
        Coordinate[] pt = CoordinateArrays.toCoordinateArray(curve.asDirectPositions());
        if (!curve.getStartPoint().equals(curve.getEndPoint()) && (p.equals(pt[0]) || p.equals(pt[pt.length - 1]))) {
            return 1;
        }
        if (CGAlgorithms.isOnLine(p, pt)) {
            return 0;
        }
        return 2;
    }

    private int locateInPolygonRing(Coordinate p, Ring ring) {
        Coordinate[] coord = CoordinateArrays.toCoordinateArray(((RingImplUnsafe)ring).asDirectPositions());
        if (CGAlgorithms.isOnLine(p, coord)) {
            return 1;
        }
        if (CGAlgorithms.isPointInRing(p, coord)) {
            return 0;
        }
        return 2;
    }

    private int locate(Coordinate p, SurfaceImpl aSurface) {
        List<Ring> rings = aSurface.getBoundaryRings();
        Ring shell = rings.get(0);
        int shellLoc = this.locateInPolygonRing(p, shell);
        if (shellLoc == 2) {
            return 2;
        }
        if (shellLoc == 1) {
            return 1;
        }
        for (int i = 1; i < rings.size(); ++i) {
            Ring hole = rings.get(i);
            int holeLoc = this.locateInPolygonRing(p, hole);
            if (holeLoc == 0) {
                return 2;
            }
            if (holeLoc != 1) continue;
            return 1;
        }
        return 0;
    }
}

